"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sameEnv = exports.hashcode = void 0;
const cdk = require("aws-cdk-lib");
const helpers_internal_1 = require("aws-cdk-lib/core/lib/helpers-internal");
/**
 * Generates a hash from the provided string for the purposes of avoiding construct ID collision
 * for models with multiple distinct sets of model data.
 * @param s A string for which to generate a hash
 * @returns A hex string representing the hash of the provided string
 */
function hashcode(s) {
    return (0, helpers_internal_1.md5hash)(s);
}
exports.hashcode = hashcode;
/**
 * Whether two strings probably contain the same environment attribute (region or account).
 *
 * Used to compare either accounts or regions, and also returns true if both
 * are unresolved (in which case both are expected to be "current region" or "current account").
 * @param attr1 The first attribute to compare
 * @param attr2 The second attribute to compare
 */
function sameEnv(attr1, attr2) {
    return [cdk.TokenComparison.SAME, cdk.TokenComparison.BOTH_UNRESOLVED].includes(cdk.Token.compareStrings(attr1, attr2));
}
exports.sameEnv = sameEnv;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsbUNBQW1DO0FBQ25DLDRFQUFnRTtBQUVoRTs7Ozs7R0FLRztBQUNILFNBQWdCLFFBQVEsQ0FBQyxDQUFTO0lBQ2hDLE9BQU8sSUFBQSwwQkFBTyxFQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3BCLENBQUM7QUFGRCw0QkFFQztBQUVEOzs7Ozs7O0dBT0c7QUFDSCxTQUFnQixPQUFPLENBQUMsS0FBYSxFQUFFLEtBQWE7SUFDbEQsT0FBTyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUFDLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDO0FBQzFILENBQUM7QUFGRCwwQkFFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBtZDVoYXNoIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZS9saWIvaGVscGVycy1pbnRlcm5hbCc7XG5cbi8qKlxuICogR2VuZXJhdGVzIGEgaGFzaCBmcm9tIHRoZSBwcm92aWRlZCBzdHJpbmcgZm9yIHRoZSBwdXJwb3NlcyBvZiBhdm9pZGluZyBjb25zdHJ1Y3QgSUQgY29sbGlzaW9uXG4gKiBmb3IgbW9kZWxzIHdpdGggbXVsdGlwbGUgZGlzdGluY3Qgc2V0cyBvZiBtb2RlbCBkYXRhLlxuICogQHBhcmFtIHMgQSBzdHJpbmcgZm9yIHdoaWNoIHRvIGdlbmVyYXRlIGEgaGFzaFxuICogQHJldHVybnMgQSBoZXggc3RyaW5nIHJlcHJlc2VudGluZyB0aGUgaGFzaCBvZiB0aGUgcHJvdmlkZWQgc3RyaW5nXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBoYXNoY29kZShzOiBzdHJpbmcpOiBzdHJpbmcge1xuICByZXR1cm4gbWQ1aGFzaChzKTtcbn1cblxuLyoqXG4gKiBXaGV0aGVyIHR3byBzdHJpbmdzIHByb2JhYmx5IGNvbnRhaW4gdGhlIHNhbWUgZW52aXJvbm1lbnQgYXR0cmlidXRlIChyZWdpb24gb3IgYWNjb3VudCkuXG4gKlxuICogVXNlZCB0byBjb21wYXJlIGVpdGhlciBhY2NvdW50cyBvciByZWdpb25zLCBhbmQgYWxzbyByZXR1cm5zIHRydWUgaWYgYm90aFxuICogYXJlIHVucmVzb2x2ZWQgKGluIHdoaWNoIGNhc2UgYm90aCBhcmUgZXhwZWN0ZWQgdG8gYmUgXCJjdXJyZW50IHJlZ2lvblwiIG9yIFwiY3VycmVudCBhY2NvdW50XCIpLlxuICogQHBhcmFtIGF0dHIxIFRoZSBmaXJzdCBhdHRyaWJ1dGUgdG8gY29tcGFyZVxuICogQHBhcmFtIGF0dHIyIFRoZSBzZWNvbmQgYXR0cmlidXRlIHRvIGNvbXBhcmVcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHNhbWVFbnYoYXR0cjE6IHN0cmluZywgYXR0cjI6IHN0cmluZyk6IGJvb2xlYW4ge1xuICByZXR1cm4gW2Nkay5Ub2tlbkNvbXBhcmlzb24uU0FNRSwgY2RrLlRva2VuQ29tcGFyaXNvbi5CT1RIX1VOUkVTT0xWRURdLmluY2x1ZGVzKGNkay5Ub2tlbi5jb21wYXJlU3RyaW5ncyhhdHRyMSwgYXR0cjIpKTtcbn1cbiJdfQ==