"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
/**
 * Supported instance types for SageMaker instance-based production variants.
 */
class InstanceType {
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType) {
        return new InstanceType(instanceType);
    }
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('ml.')) {
            this.instanceTypeIdentifier = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${instanceType})`);
        }
    }
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.InstanceType", version: "2.79.1-alpha.0" };
/**
 * ml.c4.2xlarge
 */
InstanceType.C4_2XLARGE = InstanceType.of('ml.c4.2xlarge');
/**
 * ml.c4.4xlarge
 */
InstanceType.C4_4XLARGE = InstanceType.of('ml.c4.4xlarge');
/**
 * ml.c4.8xlarge
 */
InstanceType.C4_8XLARGE = InstanceType.of('ml.c4.8xlarge');
/**
 * ml.c4.large
 */
InstanceType.C4_LARGE = InstanceType.of('ml.c4.large');
/**
 * ml.c4.xlarge
 */
InstanceType.C4_XLARGE = InstanceType.of('ml.c4.xlarge');
/**
 * ml.c5.18xlarge
 */
InstanceType.C5_18XLARGE = InstanceType.of('ml.c5.18xlarge');
/**
 * ml.c5.2xlarge
 */
InstanceType.C5_2XLARGE = InstanceType.of('ml.c5.2xlarge');
/**
 * ml.c5.4xlarge
 */
InstanceType.C5_4XLARGE = InstanceType.of('ml.c5.4xlarge');
/**
 * ml.c5.9xlarge
 */
InstanceType.C5_9XLARGE = InstanceType.of('ml.c5.9xlarge');
/**
 * ml.c5.large
 */
InstanceType.C5_LARGE = InstanceType.of('ml.c5.large');
/**
 * ml.c5.xlarge
 */
InstanceType.C5_XLARGE = InstanceType.of('ml.c5.xlarge');
/**
 * ml.c5d.18xlarge
 */
InstanceType.C5D_18XLARGE = InstanceType.of('ml.c5d.18xlarge');
/**
 * ml.c5d.2xlarge
 */
InstanceType.C5D_2XLARGE = InstanceType.of('ml.c5d.2xlarge');
/**
 * ml.c5d.4xlarge
 */
InstanceType.C5D_4XLARGE = InstanceType.of('ml.c5d.4xlarge');
/**
 * ml.c5d.9xlarge
 */
InstanceType.C5D_9XLARGE = InstanceType.of('ml.c5d.9xlarge');
/**
 * ml.c5d.large
 */
InstanceType.C5D_LARGE = InstanceType.of('ml.c5d.large');
/**
 * ml.c5d.xlarge
 */
InstanceType.C5D_XLARGE = InstanceType.of('ml.c5d.xlarge');
/**
 * ml.c6i.12xlarge
 */
InstanceType.C6I_12XLARGE = InstanceType.of('ml.c6i.12xlarge');
/**
 * ml.c6i.16xlarge
 */
InstanceType.C6I_16XLARGE = InstanceType.of('ml.c6i.16xlarge');
/**
 * ml.c6i.24xlarge
 */
InstanceType.C6I_24XLARGE = InstanceType.of('ml.c6i.24xlarge');
/**
 * ml.c6i.2xlarge
 */
InstanceType.C6I_2XLARGE = InstanceType.of('ml.c6i.2xlarge');
/**
 * ml.c6i.32xlarge
 */
InstanceType.C6I_32XLARGE = InstanceType.of('ml.c6i.32xlarge');
/**
 * ml.c6i.4xlarge
 */
InstanceType.C6I_4XLARGE = InstanceType.of('ml.c6i.4xlarge');
/**
 * ml.c6i.8xlarge
 */
InstanceType.C6I_8XLARGE = InstanceType.of('ml.c6i.8xlarge');
/**
 * ml.c6i.large
 */
InstanceType.C6I_LARGE = InstanceType.of('ml.c6i.large');
/**
 * ml.c6i.xlarge
 */
InstanceType.C6I_XLARGE = InstanceType.of('ml.c6i.xlarge');
/**
 * ml.g4dn.12xlarge
 */
InstanceType.G4DN_12XLARGE = InstanceType.of('ml.g4dn.12xlarge');
/**
 * ml.g4dn.16xlarge
 */
InstanceType.G4DN_16XLARGE = InstanceType.of('ml.g4dn.16xlarge');
/**
 * ml.g4dn.2xlarge
 */
InstanceType.G4DN_2XLARGE = InstanceType.of('ml.g4dn.2xlarge');
/**
 * ml.g4dn.4xlarge
 */
InstanceType.G4DN_4XLARGE = InstanceType.of('ml.g4dn.4xlarge');
/**
 * ml.g4dn.8xlarge
 */
InstanceType.G4DN_8XLARGE = InstanceType.of('ml.g4dn.8xlarge');
/**
 * ml.g4dn.xlarge
 */
InstanceType.G4DN_XLARGE = InstanceType.of('ml.g4dn.xlarge');
/**
 * ml.g5.12xlarge
 */
InstanceType.G5_12XLARGE = InstanceType.of('ml.g5.12xlarge');
/**
 * ml.g5.16xlarge
 */
InstanceType.G5_16XLARGE = InstanceType.of('ml.g5.16xlarge');
/**
 * ml.g5.24xlarge
 */
InstanceType.G5_24XLARGE = InstanceType.of('ml.g5.24xlarge');
/**
 * ml.g5.2xlarge
 */
InstanceType.G5_2XLARGE = InstanceType.of('ml.g5.2xlarge');
/**
 * ml.g5.48xlarge
 */
InstanceType.G5_48XLARGE = InstanceType.of('ml.g5.48xlarge');
/**
 * ml.g5.4xlarge
 */
InstanceType.G5_4XLARGE = InstanceType.of('ml.g5.4xlarge');
/**
 * ml.g5.8xlarge
 */
InstanceType.G5_8XLARGE = InstanceType.of('ml.g5.8xlarge');
/**
 * ml.g5.xlarge
 */
InstanceType.G5_XLARGE = InstanceType.of('ml.g5.xlarge');
/**
 * ml.inf1.24xlarge
 */
InstanceType.INF1_24XLARGE = InstanceType.of('ml.inf1.24xlarge');
/**
 * ml.inf1.2xlarge
 */
InstanceType.INF1_2XLARGE = InstanceType.of('ml.inf1.2xlarge');
/**
 * ml.inf1.6xlarge
 */
InstanceType.INF1_6XLARGE = InstanceType.of('ml.inf1.6xlarge');
/**
 * ml.inf1.xlarge
 */
InstanceType.INF1_XLARGE = InstanceType.of('ml.inf1.xlarge');
/**
 * ml.m4.10xlarge
 */
InstanceType.M4_10XLARGE = InstanceType.of('ml.m4.10xlarge');
/**
 * ml.m4.16xlarge
 */
InstanceType.M4_16XLARGE = InstanceType.of('ml.m4.16xlarge');
/**
 * ml.m4.2xlarge
 */
InstanceType.M4_2XLARGE = InstanceType.of('ml.m4.2xlarge');
/**
 * ml.m4.4xlarge
 */
InstanceType.M4_4XLARGE = InstanceType.of('ml.m4.4xlarge');
/**
 * ml.m4.xlarge
 */
InstanceType.M4_XLARGE = InstanceType.of('ml.m4.xlarge');
/**
 * ml.m5.12xlarge
 */
InstanceType.M5_12XLARGE = InstanceType.of('ml.m5.12xlarge');
/**
 * ml.m5.24xlarge
 */
InstanceType.M5_24XLARGE = InstanceType.of('ml.m5.24xlarge');
/**
 * ml.m5.2xlarge
 */
InstanceType.M5_2XLARGE = InstanceType.of('ml.m5.2xlarge');
/**
 * ml.m5.4xlarge
 */
InstanceType.M5_4XLARGE = InstanceType.of('ml.m5.4xlarge');
/**
 * ml.m5.large
 */
InstanceType.M5_LARGE = InstanceType.of('ml.m5.large');
/**
 * ml.m5.xlarge
 */
InstanceType.M5_XLARGE = InstanceType.of('ml.m5.xlarge');
/**
 * ml.m5d.12xlarge
 */
InstanceType.M5D_12XLARGE = InstanceType.of('ml.m5d.12xlarge');
/**
 * ml.m5d.24xlarge
 */
InstanceType.M5D_24XLARGE = InstanceType.of('ml.m5d.24xlarge');
/**
 * ml.m5d.2xlarge
 */
InstanceType.M5D_2XLARGE = InstanceType.of('ml.m5d.2xlarge');
/**
 * ml.m5d.4xlarge
 */
InstanceType.M5D_4XLARGE = InstanceType.of('ml.m5d.4xlarge');
/**
 * ml.m5d.large
 */
InstanceType.M5D_LARGE = InstanceType.of('ml.m5d.large');
/**
 * ml.m5d.xlarge
 */
InstanceType.M5D_XLARGE = InstanceType.of('ml.m5d.xlarge');
/**
 * ml.p2.16xlarge
 */
InstanceType.P2_16XLARGE = InstanceType.of('ml.p2.16xlarge');
/**
 * ml.p2.8xlarge
 */
InstanceType.P2_8XLARGE = InstanceType.of('ml.p2.8xlarge');
/**
 * ml.p2.xlarge
 */
InstanceType.P2_XLARGE = InstanceType.of('ml.p2.xlarge');
/**
 * ml.p3.16xlarge
 */
InstanceType.P3_16XLARGE = InstanceType.of('ml.p3.16xlarge');
/**
 * ml.p3.2xlarge
 */
InstanceType.P3_2XLARGE = InstanceType.of('ml.p3.2xlarge');
/**
 * ml.p3.8xlarge
 */
InstanceType.P3_8XLARGE = InstanceType.of('ml.p3.8xlarge');
/**
 * ml.p4d.24xlarge
 */
InstanceType.P4D_24XLARGE = InstanceType.of('ml.p4d.24xlarge');
/**
 * ml.r5.12xlarge
 */
InstanceType.R5_12XLARGE = InstanceType.of('ml.r5.12xlarge');
/**
 * ml.r5.24xlarge
 */
InstanceType.R5_24XLARGE = InstanceType.of('ml.r5.24xlarge');
/**
 * ml.r5.2xlarge
 */
InstanceType.R5_2XLARGE = InstanceType.of('ml.r5.2xlarge');
/**
 * ml.r5.4xlarge
 */
InstanceType.R5_4XLARGE = InstanceType.of('ml.r5.4xlarge');
/**
 * ml.r5.large
 */
InstanceType.R5_LARGE = InstanceType.of('ml.r5.large');
/**
 * ml.r5.xlarge
 */
InstanceType.R5_XLARGE = InstanceType.of('ml.r5.xlarge');
/**
 * ml.r5d.12xlarge
 */
InstanceType.R5D_12XLARGE = InstanceType.of('ml.r5d.12xlarge');
/**
 * ml.r5d.24xlarge
 */
InstanceType.R5D_24XLARGE = InstanceType.of('ml.r5d.24xlarge');
/**
 * ml.r5d.2xlarge
 */
InstanceType.R5D_2XLARGE = InstanceType.of('ml.r5d.2xlarge');
/**
 * ml.r5d.4xlarge
 */
InstanceType.R5D_4XLARGE = InstanceType.of('ml.r5d.4xlarge');
/**
 * ml.r5d.large
 */
InstanceType.R5D_LARGE = InstanceType.of('ml.r5d.large');
/**
 * ml.r5d.xlarge
 */
InstanceType.R5D_XLARGE = InstanceType.of('ml.r5d.xlarge');
/**
 * ml.t2.2xlarge
 */
InstanceType.T2_2XLARGE = InstanceType.of('ml.t2.2xlarge');
/**
 * ml.t2.large
 */
InstanceType.T2_LARGE = InstanceType.of('ml.t2.large');
/**
 * ml.t2.medium
 */
InstanceType.T2_MEDIUM = InstanceType.of('ml.t2.medium');
/**
 * ml.t2.xlarge
 */
InstanceType.T2_XLARGE = InstanceType.of('ml.t2.xlarge');
exports.InstanceType = InstanceType;
//# sourceMappingURL=data:application/json;base64,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