"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcceleratorType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
/**
 * Supported Elastic Inference (EI) instance types for SageMaker instance-based production variants.
 * EI instances provide on-demand GPU computing for inference.
 */
class AcceleratorType {
    /**
     * Builds an AcceleratorType from a given string or token (such as a CfnParameter).
     * @param acceleratorType An accelerator type as string
     * @returns A strongly typed AcceleratorType
     */
    static of(acceleratorType) {
        return new AcceleratorType(acceleratorType);
    }
    constructor(acceleratorType) {
        if (cdk.Token.isUnresolved(acceleratorType) || acceleratorType.startsWith('ml.')) {
            this.acceleratorTypeIdentifier = acceleratorType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${acceleratorType})`);
        }
    }
    /**
     * Return the accelerator type as a string
     * @returns The accelerator type as a string
     */
    toString() {
        return this.acceleratorTypeIdentifier;
    }
}
_a = JSII_RTTI_SYMBOL_1;
AcceleratorType[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.AcceleratorType", version: "2.79.1-alpha.0" };
/**
 * ml.eia1.large
 */
AcceleratorType.EIA1_LARGE = AcceleratorType.of('ml.eia1.large');
/**
 * ml.eia1.medium
 */
AcceleratorType.EIA1_MEDIUM = AcceleratorType.of('ml.eia1.medium');
/**
 * ml.eia1.xlarge
 */
AcceleratorType.EIA1_XLARGE = AcceleratorType.of('ml.eia1.xlarge');
/**
 * ml.eia2.large
 */
AcceleratorType.EIA2_LARGE = AcceleratorType.of('ml.eia2.large');
/**
 * ml.eia2.medium
 */
AcceleratorType.EIA2_MEDIUM = AcceleratorType.of('ml.eia2.medium');
/**
 * ml.eia2.xlarge
 */
AcceleratorType.EIA2_XLARGE = AcceleratorType.of('ml.eia2.xlarge');
exports.AcceleratorType = AcceleratorType;
//# sourceMappingURL=data:application/json;base64,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