"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkGroup = exports.EncryptionOption = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::Athena-WorkGroup';
const ID = `CFN::Resource::${resourceType}`;
const createdByTag = 'CreatedByCfnCustomResource';
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["SSE_S3"] = "SSE_S3";
    EncryptionOption["SSE_KMS"] = "SSE_KMS";
    EncryptionOption["CSE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
/**
 * An Athena WorkGroup
 */
class WorkGroup extends constructs_1.Construct {
    /**
     * Defines a new Athena WorkGroup
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Name of the WorkGroup
         */
        this.name = '';
        /**
         * ARN of the WorkGroup
         */
        this.arn = '';
        if (typeof props.bytesScannedCutoffPerQuery !== 'undefined' &&
            props.bytesScannedCutoffPerQuery < 10000000) {
            aws_cdk_lib_1.Annotations.of(this).addError(`Parameter bytesScannedCutoffPerQuery must have value greater than or equal to 10000000. Got ${props.bytesScannedCutoffPerQuery}`);
        }
        if (!props.name.match(/^[a-zA-Z0-9._-]{1,128}$/)) {
            aws_cdk_lib_1.Annotations.of(this).addError(`The WorkGroup name must match /^[a-zA-Z0-9._-]{1,128}$/. Got "${props.name}"`);
        }
        this.tags = new aws_cdk_lib_1.TagManager(aws_cdk_lib_1.TagType.MAP, resourceType);
        this.tags.setTag(createdByTag, ID);
        const stack = aws_cdk_lib_1.Stack.of(this);
        this.lambda = lambda_1.ensureLambda(this);
        this.name = props.name;
        const workGroup = new aws_cdk_lib_1.CustomResource(this, `Athena-WorkGroup-${this.name}`, {
            serviceToken: this.lambda.functionArn,
            resourceType: resourceType,
            properties: {
                Name: this.name,
                Description: props.desc || '',
                BytesScannedCutoffPerQuery: props.bytesScannedCutoffPerQuery,
                EnforceWorkGroupConfiguration: props.enforceWorkGroupConfiguration || false,
                PublishCloudWatchMetricsEnabled: props.publishCloudWatchMetricsEnabled || false,
                RequesterPaysEnabled: props.requesterPaysEnabled || false,
                //EngineVersion: props.engineVersion,
                ResultConfiguration: props.resultConfiguration,
                StackName: stack.stackName,
                Arn: `arn:aws:athena:${aws_cdk_lib_1.Aws.REGION}:${aws_cdk_lib_1.Aws.ACCOUNT_ID}:workgroup/${this.name}`,
                Tags: aws_cdk_lib_1.Lazy.any({
                    produce: () => this.tags.renderTags(),
                }),
            },
        });
        this.arn = workGroup.getAttString('ARN');
    }
}
exports.WorkGroup = WorkGroup;
_a = JSII_RTTI_SYMBOL_1;
WorkGroup[_a] = { fqn: "cdk-athena.WorkGroup", version: "3.0.0" };
//# sourceMappingURL=data:application/json;base64,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