"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamedQuery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const lambda_1 = require("./lambda");
const resourceType = 'Custom::Athena-NamedQuery';
/**
 * An Athena NamedQuery
 */
class NamedQuery extends constructs_1.Construct {
    /**
     * Defines a new Athena NamedQuery
     */
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Name of the query
         */
        this.name = '';
        /**
         * The unique ID of the query
         */
        this.id = '';
        this.lambda = lambda_1.ensureLambda(this);
        this.name = props.name;
        const queryProps = {
            serviceToken: this.lambda.functionArn,
            resourceType: resourceType,
            properties: {
                Name: this.name,
                Description: props.desc || '',
                Database: props.database,
                QueryString: props.queryString,
                WorkGroup: '',
            },
        };
        if (typeof props.workGroup === 'string') {
            queryProps.properties.WorkGroup = props.workGroup;
        }
        else if (typeof props.workGroup !== 'undefined') {
            queryProps.properties.WorkGroup = props.workGroup.name;
        }
        const namedQuery = new aws_cdk_lib_1.CustomResource(this, `Athena-NamedQuery-${props.name
            .replace(/\s+/g, '-')
            .replace(/[a-z0-9_-]+/gi, '')}`, queryProps);
        if (['undefined', 'string'].indexOf(typeof props.workGroup) < 0) {
            namedQuery.node.addDependency(props.workGroup);
        }
        this.id = namedQuery.getAttString('id');
    }
}
exports.NamedQuery = NamedQuery;
_a = JSII_RTTI_SYMBOL_1;
NamedQuery[_a] = { fqn: "cdk-athena.NamedQuery", version: "3.0.0" };
//# sourceMappingURL=data:application/json;base64,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