import { aws_lambda, StackProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { WorkGroup } from './workGroup';
/**
 * Definition of the Athena NamedQuery
 */
export interface NamedQueryProps extends StackProps {
    /**
     * The query name
     */
    readonly name: string;
    /**
     * The query description
     */
    readonly desc?: string;
    /**
     * The database to which the query belongs
     */
    readonly database: string;
    /**
     * The workgroup in which the named query is being created
     */
    readonly workGroup?: WorkGroup | string;
    /**
     * The contents of the query with all query statements
     */
    readonly queryString: string;
}
/**
 * An Athena NamedQuery
 */
export declare class NamedQuery extends Construct {
    /**
     * The lambda function that is created
     */
    readonly lambda: aws_lambda.IFunction;
    /**
     * Name of the query
     */
    readonly name: string;
    /**
     * The unique ID of the query
     */
    readonly id: string;
    /**
     * Defines a new Athena NamedQuery
     */
    constructor(scope: Construct, id: string, props: NamedQueryProps);
}
