TITLE Mod file for component: Component(id=syn1 type=expOneSynapse)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.5.4
         org.neuroml.model   v1.5.4
         jLEMS               v0.9.9.1

ENDCOMMENT

NEURON {
    POINT_PROCESS syn1
    RANGE tauDecay                          : parameter
    RANGE gbase                             : parameter
    RANGE erev                              : parameter
    
    RANGE i                                 : exposure
    
    
    NONSPECIFIC_CURRENT i 
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    tauDecay = 2 (ms)
    gbase = 1.0E-4 (uS)
    erev = 10 (mV)
}

ASSIGNED {
    ? Standard Assigned variables with baseSynapse
    v (mV)
    celsius (degC)
    temperature (K)
    
    i (nA)                                 : derived variable
    rate_g (uS/ms)
    
}

STATE {
    g (uS) 
    
}

INITIAL {
    temperature = celsius + 273.15
    
    rates()
    rates() ? To ensure correct initialisation.
    
    g = 0
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    
    
}

NET_RECEIVE(weight) {
    
    : paramMappings . : {syn1={g=g, tauDecay=tauDecay, gbase=gbase, erev=erev, i=i}}
    : state_discontinuity(g, g  + (weight *   gbase  )) : From syn1
    g = g  + (weight *   gbase  ) : From syn1
    
}

DERIVATIVE states {
    rates()
    g' = rate_g 
    
}

PROCEDURE rates() {
    
    i = -1 * g  * (  erev   - v) ? evaluable
    rate_g = -  g   /  tauDecay ? Note units of all quantities used here need to be consistent!
    
     
    
}

