TITLE Mod file for component: Component(id=if1 type=intFire1Cell)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.5.4
         org.neuroml.model   v1.5.4
         jLEMS               v0.9.9.1

ENDCOMMENT

NEURON {
    POINT_PROCESS if1
    
    
    NONSPECIFIC_CURRENT i                    : To ensure v of section follows v_I
    RANGE tau                               : parameter
    RANGE C                                 : parameter
    RANGE thresh                            : parameter
    RANGE reset                             : parameter
    RANGE MVOLT                             : parameter
    RANGE PAMPERE                           : parameter
    
    RANGE iSyn                              : exposure
    
    RANGE copy_v                           : copy of v on section
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    tau = 24 (ms)
    C = 1.0E-5 (microfarads)
    thresh = 1 (mV)
    reset = 0 (mV)
    MVOLT = 1 (mV)
    PAMPERE = 0.001 (nA)
}

ASSIGNED {
    v (mV)
    i (mA/cm2)
    
    copy_v (mV)
    
    v_I (nA) 
    
    iSyn (nA)                              : derived variable
    rate_v (mV/ms)
    
}

STATE {
    
}

INITIAL {
    rates()
    rates() ? To ensure correct initialisation.
    
    net_send(0, 1) : go to NET_RECEIVE block, flag 1, for initial state
    
}

BREAKPOINT {
    
    rates()
    
    copy_v = v
    i = v_I
}

NET_RECEIVE(flag) {
    
    if (flag == 1) { : Setting watch for top level OnCondition...
        WATCH (v >  thresh) 1000
    }
    if (flag == 1000) {
    
        v = reset
    
        v_I = 0 : Setting rate of change of v to 0
    }
    
    if (flag == 1) { : Setting watch for top level OnCondition...
        WATCH (iSyn  > 0) 1001
    }
    if (flag == 1001) {
    
        v = v +   MVOLT  *(  iSyn  /  PAMPERE  )
    
        v_I = 0 : Setting rate of change of v to 0
    }
    if (flag == 1) { : Set initial states
    
        v = reset
    }
    
}

PROCEDURE rates() {
    
    ? DerivedVariable is based on path: synapses[*]/i, on: Component(id=if1 type=intFire1Cell), from synapses; null
    iSyn = 0 ? Was: synapses[*]_i but insertion of currents from external attachments not yet supported ? path based, prefix = 
    
    rate_v = (  iSyn   /   C  ) + ((  reset   - v) /   tau  ) ? Note units of all quantities used here need to be consistent!
    
    v_I = -1 * rate_v
     
    
}

