'''
Neuron simulator export for:

Components:
    null (Type: notes)
    ifcell (Type: IF_curr_alpha:  tau_refrac=2.0 (dimensionless) v_thresh=20.0 (dimensionless) tau_m=20.0 (dimensionless) v_rest=0.0 (dimensionless) v_reset=0.0 (dimensionless) cm=0.001 (dimensionless) i_offset=0.0 (dimensionless) tau_syn_E=0.1 (dimensionless) tau_syn_I=0.1 (dimensionless) v_init=0.0 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NFARAD=1.0E-9 (SI capacitance))
    ampa (Type: alphaCurrSynapse:  tau_syn=0.1 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NAMP=1.0E-9 (SI current))
    gaba (Type: alphaCurrSynapse:  tau_syn=0.1 (dimensionless) MSEC=0.001 (SI time) MVOLT=0.001 (SI voltage) NAMP=1.0E-9 (SI current))
    poisson_input (Type: SpikeSourcePoisson:  start=0.0 (SI time) duration=1000000.0 (SI time) rate=10000.0 (SI per_time) end=1000000.0 (SI time) LONG_TIME=3.6E12 (SI time) SMALL_TIME=1.0000000000000002E-12 (SI time))
    Example7_Brunel2000 (Type: network)
    SimExample7 (Type: Simulation:  length=1.0 (SI time) step=2.5E-5 (SI time))


    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.8.1
         org.neuroml.model   v1.8.1
         jLEMS               v0.10.6

'''

import neuron

import time
import datetime
import sys

import hashlib
h = neuron.h
h.load_file("stdlib.hoc")

h.load_file("stdgui.hoc")

h("objref p")
h("p = new PythonObject()")

class NeuronSimulation():

    def __init__(self, tstop, dt, seed=123):

        print("\n    Starting simulation in NEURON of %sms generated from NeuroML2 model...\n"%tstop)

        self.setup_start = time.time()
        self.seed = seed
        import socket
        self.report_file = open('report.SimExample7.txt','w')
        print('Simulator version:  %s'%h.nrnversion())
        self.report_file.write('# Report of running simulation with %s\n'%h.nrnversion())
        self.report_file.write('Simulator=NEURON\n')
        self.report_file.write('SimulatorVersion=%s\n'%h.nrnversion())

        self.report_file.write('SimulationFile=%s\n'%__file__)
        self.report_file.write('PythonVersion=%s\n'%sys.version.replace('\n',' '))
        print('Python version:     %s'%sys.version.replace('\n',' '))
        self.report_file.write('NeuroMLExportVersion=1.8.1\n')
        self.report_file.write('SimulationSeed=%s\n'%self.seed)
        self.report_file.write('Hostname=%s\n'%socket.gethostname())
        self.randoms = []
        self.next_global_id = 0  # Used in Random123 classes for elements using random(), etc. 

        self.next_spiking_input_id = 0  # Used in Random123 classes for elements using random(), etc. 

        '''
        Adding simulation Component(id=SimExample7 type=Simulation) of network/component: Example7_Brunel2000 (Type: network)
        
        '''
        # ######################   Population: Epop
        print("Population Epop contains 20 instance(s) of component: ifcell of type: IF_curr_alpha")

        h(" {n_Epop = 20} ")
        '''
        Population Epop contains instances of Component(id=ifcell type=IF_curr_alpha)
        whose dynamics will be implemented as a mechanism (ifcell) in a mod file
        '''
        h(" create Epop[20]")
        h(" objectvar m_ifcell_Epop[20] ")

        for i in range(int(h.n_Epop)):
            h.Epop[i].L = 10.0
            h.Epop[i](0.5).diam = 10.0
            h.Epop[i](0.5).cm = 0.3183098861837907
            h.Epop[i].push()
            h(" Epop[%i]  { m_ifcell_Epop[%i] = new ifcell(0.5) } "%(i,i))

            h.m_ifcell_Epop[i].tau_refrac = 2.0
            h.m_ifcell_Epop[i].v_thresh = 20.0
            h.m_ifcell_Epop[i].tau_m = 20.0
            h.m_ifcell_Epop[i].v_rest = 0.0
            h.m_ifcell_Epop[i].v_reset = 0.0
            h.m_ifcell_Epop[i].cm = 0.001
            h.m_ifcell_Epop[i].i_offset = 0.0
            h.m_ifcell_Epop[i].tau_syn_E = 0.1
            h.m_ifcell_Epop[i].tau_syn_I = 0.1
            h.m_ifcell_Epop[i].v_init = 0.0
            h.m_ifcell_Epop[i].MSEC = 1.0
            h.m_ifcell_Epop[i].MVOLT = 1.0
            h.m_ifcell_Epop[i].NFARAD = 0.001
            h.pop_section()

            self.next_global_id+=1

        h(" Epop[0] { pt3dclear() } ")
        h(" Epop[0] { pt3dadd(966.45355, 44.07326 + (5), 7.49147, 10) } ")
        h(" Epop[0] { pt3dadd(966.45355, 44.07326 + (-5), 7.49147, 10) } ")
        h(" Epop[1] { pt3dclear() } ")
        h(" Epop[1] { pt3dadd(910.97595, 93.9269 + (5), 582.2276, 10) } ")
        h(" Epop[1] { pt3dadd(910.97595, 93.9269 + (-5), 582.2276, 10) } ")
        h(" Epop[2] { pt3dclear() } ")
        h(" Epop[2] { pt3dadd(671.5635, 8.393823 + (5), 766.48096, 10) } ")
        h(" Epop[2] { pt3dadd(671.5635, 8.393823 + (-5), 766.48096, 10) } ")
        h(" Epop[3] { pt3dclear() } ")
        h(" Epop[3] { pt3dadd(236.80977, 3.081402 + (5), 788.7727, 10) } ")
        h(" Epop[3] { pt3dadd(236.80977, 3.081402 + (-5), 788.7727, 10) } ")
        h(" Epop[4] { pt3dclear() } ")
        h(" Epop[4] { pt3dadd(346.08896, 62.328148 + (5), 615.8157, 10) } ")
        h(" Epop[4] { pt3dadd(346.08896, 62.328148 + (-5), 615.8157, 10) } ")
        h(" Epop[5] { pt3dclear() } ")
        h(" Epop[5] { pt3dadd(148.55464, 18.309065 + (5), 114.41297, 10) } ")
        h(" Epop[5] { pt3dadd(148.55464, 18.309065 + (-5), 114.41297, 10) } ")
        h(" Epop[6] { pt3dclear() } ")
        h(" Epop[6] { pt3dadd(14.61878, 48.675156 + (5), 964.90155, 10) } ")
        h(" Epop[6] { pt3dadd(14.61878, 48.675156 + (-5), 964.90155, 10) } ")
        h(" Epop[7] { pt3dclear() } ")
        h(" Epop[7] { pt3dadd(64.56228, 54.108818 + (5), 465.89856, 10) } ")
        h(" Epop[7] { pt3dadd(64.56228, 54.108818 + (-5), 465.89856, 10) } ")
        h(" Epop[8] { pt3dclear() } ")
        h(" Epop[8] { pt3dadd(601.46344, 8.892883 + (5), 579.0027, 10) } ")
        h(" Epop[8] { pt3dadd(601.46344, 8.892883 + (-5), 579.0027, 10) } ")
        h(" Epop[9] { pt3dclear() } ")
        h(" Epop[9] { pt3dadd(269.5855, 55.643257 + (5), 644.6342, 10) } ")
        h(" Epop[9] { pt3dadd(269.5855, 55.643257 + (-5), 644.6342, 10) } ")
        h(" Epop[10] { pt3dclear() } ")
        h(" Epop[10] { pt3dadd(481.03638, 35.523914 + (5), 249.15211, 10) } ")
        h(" Epop[10] { pt3dadd(481.03638, 35.523914 + (-5), 249.15211, 10) } ")
        h(" Epop[11] { pt3dclear() } ")
        h(" Epop[11] { pt3dadd(933.5155, 45.338802 + (5), 530.1612, 10) } ")
        h(" Epop[11] { pt3dadd(933.5155, 45.338802 + (-5), 530.1612, 10) } ")
        h(" Epop[12] { pt3dclear() } ")
        h(" Epop[12] { pt3dadd(19.299566, 50.810192 + (5), 5.780237, 10) } ")
        h(" Epop[12] { pt3dadd(19.299566, 50.810192 + (-5), 5.780237, 10) } ")
        h(" Epop[13] { pt3dclear() } ")
        h(" Epop[13] { pt3dadd(143.76843, 47.282692 + (5), 377.34744, 10) } ")
        h(" Epop[13] { pt3dadd(143.76843, 47.282692 + (-5), 377.34744, 10) } ")
        h(" Epop[14] { pt3dclear() } ")
        h(" Epop[14] { pt3dadd(54.175198, 58.75285 + (5), 164.00322, 10) } ")
        h(" Epop[14] { pt3dadd(54.175198, 58.75285 + (-5), 164.00322, 10) } ")
        h(" Epop[15] { pt3dclear() } ")
        h(" Epop[15] { pt3dadd(557.33026, 14.424572 + (5), 937.30707, 10) } ")
        h(" Epop[15] { pt3dadd(557.33026, 14.424572 + (-5), 937.30707, 10) } ")
        h(" Epop[16] { pt3dclear() } ")
        h(" Epop[16] { pt3dadd(770.98, 95.69331 + (5), 141.22777, 10) } ")
        h(" Epop[16] { pt3dadd(770.98, 95.69331 + (-5), 141.22777, 10) } ")
        h(" Epop[17] { pt3dclear() } ")
        h(" Epop[17] { pt3dadd(305.3927, 3.9589624 + (5), 276.7837, 10) } ")
        h(" Epop[17] { pt3dadd(305.3927, 3.9589624 + (-5), 276.7837, 10) } ")
        h(" Epop[18] { pt3dclear() } ")
        h(" Epop[18] { pt3dadd(806.5125, 17.734304 + (5), 154.57051, 10) } ")
        h(" Epop[18] { pt3dadd(806.5125, 17.734304 + (-5), 154.57051, 10) } ")
        h(" Epop[19] { pt3dclear() } ")
        h(" Epop[19] { pt3dadd(954.7186, 15.45514 + (5), 833.8893, 10) } ")
        h(" Epop[19] { pt3dadd(954.7186, 15.45514 + (-5), 833.8893, 10) } ")

        # ######################   Population: expoisson
        print("Population expoisson contains 20 instance(s) of component: poisson_input of type: SpikeSourcePoisson")

        h(" {n_expoisson = 20} ")
        '''
        Population expoisson contains instances of Component(id=poisson_input type=SpikeSourcePoisson)
        whose dynamics will be implemented as a mechanism (poisson_input) in a mod file
        '''
        h(" create expoisson[20]")
        h(" objectvar m_poisson_input_expoisson[20] ")

        for i in range(int(h.n_expoisson)):
            h.expoisson[i].L = 10.0
            h.expoisson[i](0.5).diam = 10.0
            h.expoisson[i](0.5).cm = 318.31
            h.expoisson[i].push()
            h(" expoisson[%i]  { m_poisson_input_expoisson[%i] = new poisson_input(0.5) } "%(i,i))

            h.m_poisson_input_expoisson[i].start = 0.0
            h.m_poisson_input_expoisson[i].duration = 1.0E9
            h.m_poisson_input_expoisson[i].rate = 10.0
            h.m_poisson_input_expoisson[i].end = 1.0E9
            h.m_poisson_input_expoisson[i].LONG_TIME = 3.59999998E15
            h.m_poisson_input_expoisson[i].SMALL_TIME = 1.0E-9
            # Spiking element (SpikeSourcePoisson), will require seeding...
            rand = h.Random()
            self.randoms.append(rand)
            #print("Seeding random generator on m_poisson_input_expoisson[i] (i=%i) with stim seed %s"%(i, self.seed))
            self._init_stim_randomizer(rand,"expoisson",i, self.seed)
            rand.negexp(1)
            h.m_poisson_input_expoisson[i].noiseFromRandom(rand)

            h.pop_section()

            self.next_global_id+=1

        h(" expoisson[0] { pt3dclear() } ")
        h(" expoisson[0] { pt3dadd(41.062805, 38.61835 + (5), 349.59232, 10) } ")
        h(" expoisson[0] { pt3dadd(41.062805, 38.61835 + (-5), 349.59232, 10) } ")
        h(" expoisson[1] { pt3dclear() } ")
        h(" expoisson[1] { pt3dadd(341.7078, 81.64631 + (5), 475.9349, 10) } ")
        h(" expoisson[1] { pt3dadd(341.7078, 81.64631 + (-5), 475.9349, 10) } ")
        h(" expoisson[2] { pt3dclear() } ")
        h(" expoisson[2] { pt3dadd(782.8903, 47.08401 + (5), 817.344, 10) } ")
        h(" expoisson[2] { pt3dadd(782.8903, 47.08401 + (-5), 817.344, 10) } ")
        h(" expoisson[3] { pt3dclear() } ")
        h(" expoisson[3] { pt3dadd(881.5676, 43.95964 + (5), 781.0636, 10) } ")
        h(" expoisson[3] { pt3dadd(881.5676, 43.95964 + (-5), 781.0636, 10) } ")
        h(" expoisson[4] { pt3dclear() } ")
        h(" expoisson[4] { pt3dadd(814.74115, 29.567892 + (5), 123.87667, 10) } ")
        h(" expoisson[4] { pt3dadd(814.74115, 29.567892 + (-5), 123.87667, 10) } ")
        h(" expoisson[5] { pt3dclear() } ")
        h(" expoisson[5] { pt3dadd(185.62186, 43.60598 + (5), 119.46741, 10) } ")
        h(" expoisson[5] { pt3dadd(185.62186, 43.60598 + (-5), 119.46741, 10) } ")
        h(" expoisson[6] { pt3dclear() } ")
        h(" expoisson[6] { pt3dadd(529.79913, 82.942116 + (5), 485.20114, 10) } ")
        h(" expoisson[6] { pt3dadd(529.79913, 82.942116 + (-5), 485.20114, 10) } ")
        h(" expoisson[7] { pt3dclear() } ")
        h(" expoisson[7] { pt3dadd(817.734, 65.63916 + (5), 641.043, 10) } ")
        h(" expoisson[7] { pt3dadd(817.734, 65.63916 + (-5), 641.043, 10) } ")
        h(" expoisson[8] { pt3dclear() } ")
        h(" expoisson[8] { pt3dadd(345.34894, 70.26589 + (5), 809.9406, 10) } ")
        h(" expoisson[8] { pt3dadd(345.34894, 70.26589 + (-5), 809.9406, 10) } ")
        h(" expoisson[9] { pt3dclear() } ")
        h(" expoisson[9] { pt3dadd(157.16959, 90.799065 + (5), 269.33035, 10) } ")
        h(" expoisson[9] { pt3dadd(157.16959, 90.799065 + (-5), 269.33035, 10) } ")
        h(" expoisson[10] { pt3dclear() } ")
        h(" expoisson[10] { pt3dadd(154.8465, 84.04792 + (5), 720.128, 10) } ")
        h(" expoisson[10] { pt3dadd(154.8465, 84.04792 + (-5), 720.128, 10) } ")
        h(" expoisson[11] { pt3dclear() } ")
        h(" expoisson[11] { pt3dadd(793.5624, 44.667065 + (5), 70.77389, 10) } ")
        h(" expoisson[11] { pt3dadd(793.5624, 44.667065 + (-5), 70.77389, 10) } ")
        h(" expoisson[12] { pt3dclear() } ")
        h(" expoisson[12] { pt3dadd(395.24304, 4.7735295 + (5), 286.1335, 10) } ")
        h(" expoisson[12] { pt3dadd(395.24304, 4.7735295 + (-5), 286.1335, 10) } ")
        h(" expoisson[13] { pt3dclear() } ")
        h(" expoisson[13] { pt3dadd(37.994595, 50.671486 + (5), 87.6678, 10) } ")
        h(" expoisson[13] { pt3dadd(37.994595, 50.671486 + (-5), 87.6678, 10) } ")
        h(" expoisson[14] { pt3dclear() } ")
        h(" expoisson[14] { pt3dadd(932.8256, 69.93873 + (5), 316.98602, 10) } ")
        h(" expoisson[14] { pt3dadd(932.8256, 69.93873 + (-5), 316.98602, 10) } ")
        h(" expoisson[15] { pt3dclear() } ")
        h(" expoisson[15] { pt3dadd(945.0511, 6.6227603 + (5), 257.4289, 10) } ")
        h(" expoisson[15] { pt3dadd(945.0511, 6.6227603 + (-5), 257.4289, 10) } ")
        h(" expoisson[16] { pt3dclear() } ")
        h(" expoisson[16] { pt3dadd(72.99965, 42.630424 + (5), 201.89677, 10) } ")
        h(" expoisson[16] { pt3dadd(72.99965, 42.630424 + (-5), 201.89677, 10) } ")
        h(" expoisson[17] { pt3dclear() } ")
        h(" expoisson[17] { pt3dadd(396.64664, 70.48599 + (5), 887.35333, 10) } ")
        h(" expoisson[17] { pt3dadd(396.64664, 70.48599 + (-5), 887.35333, 10) } ")
        h(" expoisson[18] { pt3dclear() } ")
        h(" expoisson[18] { pt3dadd(500.5178, 81.85316 + (5), 361.25452, 10) } ")
        h(" expoisson[18] { pt3dadd(500.5178, 81.85316 + (-5), 361.25452, 10) } ")
        h(" expoisson[19] { pt3dclear() } ")
        h(" expoisson[19] { pt3dadd(858.68616, 51.503418 + (5), 702.41547, 10) } ")
        h(" expoisson[19] { pt3dadd(858.68616, 51.503418 + (-5), 702.41547, 10) } ")

        # ######################   Population: Ipop
        print("Population Ipop contains 5 instance(s) of component: ifcell of type: IF_curr_alpha")

        h(" {n_Ipop = 5} ")
        '''
        Population Ipop contains instances of Component(id=ifcell type=IF_curr_alpha)
        whose dynamics will be implemented as a mechanism (ifcell) in a mod file
        '''
        h(" create Ipop[5]")
        h(" objectvar m_ifcell_Ipop[5] ")

        for i in range(int(h.n_Ipop)):
            h.Ipop[i].L = 10.0
            h.Ipop[i](0.5).diam = 10.0
            h.Ipop[i](0.5).cm = 0.3183098861837907
            h.Ipop[i].push()
            h(" Ipop[%i]  { m_ifcell_Ipop[%i] = new ifcell(0.5) } "%(i,i))

            h.m_ifcell_Ipop[i].tau_refrac = 2.0
            h.m_ifcell_Ipop[i].v_thresh = 20.0
            h.m_ifcell_Ipop[i].tau_m = 20.0
            h.m_ifcell_Ipop[i].v_rest = 0.0
            h.m_ifcell_Ipop[i].v_reset = 0.0
            h.m_ifcell_Ipop[i].cm = 0.001
            h.m_ifcell_Ipop[i].i_offset = 0.0
            h.m_ifcell_Ipop[i].tau_syn_E = 0.1
            h.m_ifcell_Ipop[i].tau_syn_I = 0.1
            h.m_ifcell_Ipop[i].v_init = 0.0
            h.m_ifcell_Ipop[i].MSEC = 1.0
            h.m_ifcell_Ipop[i].MVOLT = 1.0
            h.m_ifcell_Ipop[i].NFARAD = 0.001
            h.pop_section()

            self.next_global_id+=1

        h(" Ipop[0] { pt3dclear() } ")
        h(" Ipop[0] { pt3dadd(174.68991, 58.45118 + (5), 301.77707, 10) } ")
        h(" Ipop[0] { pt3dadd(174.68991, 58.45118 + (-5), 301.77707, 10) } ")
        h(" Ipop[1] { pt3dclear() } ")
        h(" Ipop[1] { pt3dadd(812.8514, 53.434074 + (5), 499.5873, 10) } ")
        h(" Ipop[1] { pt3dadd(812.8514, 53.434074 + (-5), 499.5873, 10) } ")
        h(" Ipop[2] { pt3dclear() } ")
        h(" Ipop[2] { pt3dadd(773.3252, 54.90307 + (5), 333.75803, 10) } ")
        h(" Ipop[2] { pt3dadd(773.3252, 54.90307 + (-5), 333.75803, 10) } ")
        h(" Ipop[3] { pt3dclear() } ")
        h(" Ipop[3] { pt3dadd(130.93286, 62.4506 + (5), 925.3462, 10) } ")
        h(" Ipop[3] { pt3dadd(130.93286, 62.4506 + (-5), 925.3462, 10) } ")
        h(" Ipop[4] { pt3dclear() } ")
        h(" Ipop[4] { pt3dadd(842.33887, 6.9749784 + (5), 325.28522, 10) } ")
        h(" Ipop[4] { pt3dadd(842.33887, 6.9749784 + (-5), 325.28522, 10) } ")

        # ######################   Population: inpoisson
        print("Population inpoisson contains 5 instance(s) of component: poisson_input of type: SpikeSourcePoisson")

        h(" {n_inpoisson = 5} ")
        '''
        Population inpoisson contains instances of Component(id=poisson_input type=SpikeSourcePoisson)
        whose dynamics will be implemented as a mechanism (poisson_input) in a mod file
        '''
        h(" create inpoisson[5]")
        h(" objectvar m_poisson_input_inpoisson[5] ")

        for i in range(int(h.n_inpoisson)):
            h.inpoisson[i].L = 10.0
            h.inpoisson[i](0.5).diam = 10.0
            h.inpoisson[i](0.5).cm = 318.31
            h.inpoisson[i].push()
            h(" inpoisson[%i]  { m_poisson_input_inpoisson[%i] = new poisson_input(0.5) } "%(i,i))

            h.m_poisson_input_inpoisson[i].start = 0.0
            h.m_poisson_input_inpoisson[i].duration = 1.0E9
            h.m_poisson_input_inpoisson[i].rate = 10.0
            h.m_poisson_input_inpoisson[i].end = 1.0E9
            h.m_poisson_input_inpoisson[i].LONG_TIME = 3.59999998E15
            h.m_poisson_input_inpoisson[i].SMALL_TIME = 1.0E-9
            # Spiking element (SpikeSourcePoisson), will require seeding...
            rand = h.Random()
            self.randoms.append(rand)
            #print("Seeding random generator on m_poisson_input_inpoisson[i] (i=%i) with stim seed %s"%(i, self.seed))
            self._init_stim_randomizer(rand,"inpoisson",i, self.seed)
            rand.negexp(1)
            h.m_poisson_input_inpoisson[i].noiseFromRandom(rand)

            h.pop_section()

            self.next_global_id+=1

        h(" inpoisson[0] { pt3dclear() } ")
        h(" inpoisson[0] { pt3dadd(1.7063742, 67.46972 + (5), 638.2801, 10) } ")
        h(" inpoisson[0] { pt3dadd(1.7063742, 67.46972 + (-5), 638.2801, 10) } ")
        h(" inpoisson[1] { pt3dclear() } ")
        h(" inpoisson[1] { pt3dadd(757.90875, 14.827393 + (5), 217.03369, 10) } ")
        h(" inpoisson[1] { pt3dadd(757.90875, 14.827393 + (-5), 217.03369, 10) } ")
        h(" inpoisson[2] { pt3dclear() } ")
        h(" inpoisson[2] { pt3dadd(432.77237, 73.672485 + (5), 207.119, 10) } ")
        h(" inpoisson[2] { pt3dadd(432.77237, 73.672485 + (-5), 207.119, 10) } ")
        h(" inpoisson[3] { pt3dclear() } ")
        h(" inpoisson[3] { pt3dadd(822.8369, 38.12011 + (5), 874.28577, 10) } ")
        h(" inpoisson[3] { pt3dadd(822.8369, 38.12011 + (-5), 874.28577, 10) } ")
        h(" inpoisson[4] { pt3dclear() } ")
        h(" inpoisson[4] { pt3dadd(960.02466, 53.74877 + (5), 921.0674, 10) } ")
        h(" inpoisson[4] { pt3dadd(960.02466, 53.74877 + (-5), 921.0674, 10) } ")

        # ######################   Projection: projEinput
        print("Adding projection: projEinput, from expoisson to Epop with synapse ampa, 20 connection(s)")

        h("objectvar syn_projEinput_ampa[20]")

        h("objectvar netConn_projEinput_ampa[20]")

        # Connection 0: cell 0, seg 0 (0.5) [0.5 on expoisson[0]] -> cell 0, seg 0 (0.5) [0.5 on Epop[0]], weight: 4.1363508E-4, delay 0.025
        h("Epop[0] syn_projEinput_ampa[0] = new ampa(0.5)")
        h("expoisson[0] netConn_projEinput_ampa[0] = new NetCon(m_poisson_input_expoisson[0], syn_projEinput_ampa[0], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 1: cell 1, seg 0 (0.5) [0.5 on expoisson[1]] -> cell 1, seg 0 (0.5) [0.5 on Epop[1]], weight: 4.1363508E-4, delay 0.025
        h("Epop[1] syn_projEinput_ampa[1] = new ampa(0.5)")
        h("expoisson[1] netConn_projEinput_ampa[1] = new NetCon(m_poisson_input_expoisson[1], syn_projEinput_ampa[1], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 2: cell 2, seg 0 (0.5) [0.5 on expoisson[2]] -> cell 2, seg 0 (0.5) [0.5 on Epop[2]], weight: 4.1363508E-4, delay 0.025
        h("Epop[2] syn_projEinput_ampa[2] = new ampa(0.5)")
        h("expoisson[2] netConn_projEinput_ampa[2] = new NetCon(m_poisson_input_expoisson[2], syn_projEinput_ampa[2], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 3: cell 3, seg 0 (0.5) [0.5 on expoisson[3]] -> cell 3, seg 0 (0.5) [0.5 on Epop[3]], weight: 4.1363508E-4, delay 0.025
        h("Epop[3] syn_projEinput_ampa[3] = new ampa(0.5)")
        h("expoisson[3] netConn_projEinput_ampa[3] = new NetCon(m_poisson_input_expoisson[3], syn_projEinput_ampa[3], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 4: cell 4, seg 0 (0.5) [0.5 on expoisson[4]] -> cell 4, seg 0 (0.5) [0.5 on Epop[4]], weight: 4.1363508E-4, delay 0.025
        h("Epop[4] syn_projEinput_ampa[4] = new ampa(0.5)")
        h("expoisson[4] netConn_projEinput_ampa[4] = new NetCon(m_poisson_input_expoisson[4], syn_projEinput_ampa[4], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 5: cell 5, seg 0 (0.5) [0.5 on expoisson[5]] -> cell 5, seg 0 (0.5) [0.5 on Epop[5]], weight: 4.1363508E-4, delay 0.025
        h("Epop[5] syn_projEinput_ampa[5] = new ampa(0.5)")
        h("expoisson[5] netConn_projEinput_ampa[5] = new NetCon(m_poisson_input_expoisson[5], syn_projEinput_ampa[5], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 6: cell 6, seg 0 (0.5) [0.5 on expoisson[6]] -> cell 6, seg 0 (0.5) [0.5 on Epop[6]], weight: 4.1363508E-4, delay 0.025
        h("Epop[6] syn_projEinput_ampa[6] = new ampa(0.5)")
        h("expoisson[6] netConn_projEinput_ampa[6] = new NetCon(m_poisson_input_expoisson[6], syn_projEinput_ampa[6], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 7: cell 7, seg 0 (0.5) [0.5 on expoisson[7]] -> cell 7, seg 0 (0.5) [0.5 on Epop[7]], weight: 4.1363508E-4, delay 0.025
        h("Epop[7] syn_projEinput_ampa[7] = new ampa(0.5)")
        h("expoisson[7] netConn_projEinput_ampa[7] = new NetCon(m_poisson_input_expoisson[7], syn_projEinput_ampa[7], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 8: cell 8, seg 0 (0.5) [0.5 on expoisson[8]] -> cell 8, seg 0 (0.5) [0.5 on Epop[8]], weight: 4.1363508E-4, delay 0.025
        h("Epop[8] syn_projEinput_ampa[8] = new ampa(0.5)")
        h("expoisson[8] netConn_projEinput_ampa[8] = new NetCon(m_poisson_input_expoisson[8], syn_projEinput_ampa[8], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 9: cell 9, seg 0 (0.5) [0.5 on expoisson[9]] -> cell 9, seg 0 (0.5) [0.5 on Epop[9]], weight: 4.1363508E-4, delay 0.025
        h("Epop[9] syn_projEinput_ampa[9] = new ampa(0.5)")
        h("expoisson[9] netConn_projEinput_ampa[9] = new NetCon(m_poisson_input_expoisson[9], syn_projEinput_ampa[9], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 10: cell 10, seg 0 (0.5) [0.5 on expoisson[10]] -> cell 10, seg 0 (0.5) [0.5 on Epop[10]], weight: 4.1363508E-4, delay 0.025
        h("Epop[10] syn_projEinput_ampa[10] = new ampa(0.5)")
        h("expoisson[10] netConn_projEinput_ampa[10] = new NetCon(m_poisson_input_expoisson[10], syn_projEinput_ampa[10], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 11: cell 11, seg 0 (0.5) [0.5 on expoisson[11]] -> cell 11, seg 0 (0.5) [0.5 on Epop[11]], weight: 4.1363508E-4, delay 0.025
        h("Epop[11] syn_projEinput_ampa[11] = new ampa(0.5)")
        h("expoisson[11] netConn_projEinput_ampa[11] = new NetCon(m_poisson_input_expoisson[11], syn_projEinput_ampa[11], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 12: cell 12, seg 0 (0.5) [0.5 on expoisson[12]] -> cell 12, seg 0 (0.5) [0.5 on Epop[12]], weight: 4.1363508E-4, delay 0.025
        h("Epop[12] syn_projEinput_ampa[12] = new ampa(0.5)")
        h("expoisson[12] netConn_projEinput_ampa[12] = new NetCon(m_poisson_input_expoisson[12], syn_projEinput_ampa[12], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 13: cell 13, seg 0 (0.5) [0.5 on expoisson[13]] -> cell 13, seg 0 (0.5) [0.5 on Epop[13]], weight: 4.1363508E-4, delay 0.025
        h("Epop[13] syn_projEinput_ampa[13] = new ampa(0.5)")
        h("expoisson[13] netConn_projEinput_ampa[13] = new NetCon(m_poisson_input_expoisson[13], syn_projEinput_ampa[13], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 14: cell 14, seg 0 (0.5) [0.5 on expoisson[14]] -> cell 14, seg 0 (0.5) [0.5 on Epop[14]], weight: 4.1363508E-4, delay 0.025
        h("Epop[14] syn_projEinput_ampa[14] = new ampa(0.5)")
        h("expoisson[14] netConn_projEinput_ampa[14] = new NetCon(m_poisson_input_expoisson[14], syn_projEinput_ampa[14], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 15: cell 15, seg 0 (0.5) [0.5 on expoisson[15]] -> cell 15, seg 0 (0.5) [0.5 on Epop[15]], weight: 4.1363508E-4, delay 0.025
        h("Epop[15] syn_projEinput_ampa[15] = new ampa(0.5)")
        h("expoisson[15] netConn_projEinput_ampa[15] = new NetCon(m_poisson_input_expoisson[15], syn_projEinput_ampa[15], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 16: cell 16, seg 0 (0.5) [0.5 on expoisson[16]] -> cell 16, seg 0 (0.5) [0.5 on Epop[16]], weight: 4.1363508E-4, delay 0.025
        h("Epop[16] syn_projEinput_ampa[16] = new ampa(0.5)")
        h("expoisson[16] netConn_projEinput_ampa[16] = new NetCon(m_poisson_input_expoisson[16], syn_projEinput_ampa[16], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 17: cell 17, seg 0 (0.5) [0.5 on expoisson[17]] -> cell 17, seg 0 (0.5) [0.5 on Epop[17]], weight: 4.1363508E-4, delay 0.025
        h("Epop[17] syn_projEinput_ampa[17] = new ampa(0.5)")
        h("expoisson[17] netConn_projEinput_ampa[17] = new NetCon(m_poisson_input_expoisson[17], syn_projEinput_ampa[17], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 18: cell 18, seg 0 (0.5) [0.5 on expoisson[18]] -> cell 18, seg 0 (0.5) [0.5 on Epop[18]], weight: 4.1363508E-4, delay 0.025
        h("Epop[18] syn_projEinput_ampa[18] = new ampa(0.5)")
        h("expoisson[18] netConn_projEinput_ampa[18] = new NetCon(m_poisson_input_expoisson[18], syn_projEinput_ampa[18], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 19: cell 19, seg 0 (0.5) [0.5 on expoisson[19]] -> cell 19, seg 0 (0.5) [0.5 on Epop[19]], weight: 4.1363508E-4, delay 0.025
        h("Epop[19] syn_projEinput_ampa[19] = new ampa(0.5)")
        h("expoisson[19] netConn_projEinput_ampa[19] = new NetCon(m_poisson_input_expoisson[19], syn_projEinput_ampa[19], 0.0, 0.025, 4.1363508E-4)")  

        # ######################   Projection: projIinput
        print("Adding projection: projIinput, from inpoisson to Ipop with synapse ampa, 5 connection(s)")

        h("objectvar syn_projIinput_ampa[5]")

        h("objectvar netConn_projIinput_ampa[5]")

        # Connection 0: cell 0, seg 0 (0.5) [0.5 on inpoisson[0]] -> cell 0, seg 0 (0.5) [0.5 on Ipop[0]], weight: 4.1363508E-4, delay 0.025
        h("Ipop[0] syn_projIinput_ampa[0] = new ampa(0.5)")
        h("inpoisson[0] netConn_projIinput_ampa[0] = new NetCon(m_poisson_input_inpoisson[0], syn_projIinput_ampa[0], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 1: cell 1, seg 0 (0.5) [0.5 on inpoisson[1]] -> cell 1, seg 0 (0.5) [0.5 on Ipop[1]], weight: 4.1363508E-4, delay 0.025
        h("Ipop[1] syn_projIinput_ampa[1] = new ampa(0.5)")
        h("inpoisson[1] netConn_projIinput_ampa[1] = new NetCon(m_poisson_input_inpoisson[1], syn_projIinput_ampa[1], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 2: cell 2, seg 0 (0.5) [0.5 on inpoisson[2]] -> cell 2, seg 0 (0.5) [0.5 on Ipop[2]], weight: 4.1363508E-4, delay 0.025
        h("Ipop[2] syn_projIinput_ampa[2] = new ampa(0.5)")
        h("inpoisson[2] netConn_projIinput_ampa[2] = new NetCon(m_poisson_input_inpoisson[2], syn_projIinput_ampa[2], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 3: cell 3, seg 0 (0.5) [0.5 on inpoisson[3]] -> cell 3, seg 0 (0.5) [0.5 on Ipop[3]], weight: 4.1363508E-4, delay 0.025
        h("Ipop[3] syn_projIinput_ampa[3] = new ampa(0.5)")
        h("inpoisson[3] netConn_projIinput_ampa[3] = new NetCon(m_poisson_input_inpoisson[3], syn_projIinput_ampa[3], 0.0, 0.025, 4.1363508E-4)")  

        # Connection 4: cell 4, seg 0 (0.5) [0.5 on inpoisson[4]] -> cell 4, seg 0 (0.5) [0.5 on Ipop[4]], weight: 4.1363508E-4, delay 0.025
        h("Ipop[4] syn_projIinput_ampa[4] = new ampa(0.5)")
        h("inpoisson[4] netConn_projIinput_ampa[4] = new NetCon(m_poisson_input_inpoisson[4], syn_projIinput_ampa[4], 0.0, 0.025, 4.1363508E-4)")  

        # ######################   Projection: projEE
        print("Adding projection: projEE, from Epop to Epop with synapse ampa, 28 connection(s)")

        h("objectvar syn_projEE_ampa[28]")

        h("objectvar netConn_projEE_ampa[28]")

        # Connection 0: cell 0, seg 0 (0.5) [0.5 on Epop[0]] -> cell 4, seg 0 (0.5) [0.5 on Epop[4]], weight: 4.1363508E-4, delay 1.5
        h("Epop[4] syn_projEE_ampa[0] = new ampa(0.5)")
        h("Epop[0] netConn_projEE_ampa[0] = new NetCon(&v(0.5), syn_projEE_ampa[0], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 1: cell 0, seg 0 (0.5) [0.5 on Epop[0]] -> cell 14, seg 0 (0.5) [0.5 on Epop[14]], weight: 4.1363508E-4, delay 1.5
        h("Epop[14] syn_projEE_ampa[1] = new ampa(0.5)")
        h("Epop[0] netConn_projEE_ampa[1] = new NetCon(&v(0.5), syn_projEE_ampa[1], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 2: cell 1, seg 0 (0.5) [0.5 on Epop[1]] -> cell 0, seg 0 (0.5) [0.5 on Epop[0]], weight: 4.1363508E-4, delay 1.5
        h("Epop[0] syn_projEE_ampa[2] = new ampa(0.5)")
        h("Epop[1] netConn_projEE_ampa[2] = new NetCon(&v(0.5), syn_projEE_ampa[2], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 3: cell 2, seg 0 (0.5) [0.5 on Epop[2]] -> cell 2, seg 0 (0.5) [0.5 on Epop[2]], weight: 4.1363508E-4, delay 1.5
        h("Epop[2] syn_projEE_ampa[3] = new ampa(0.5)")
        h("Epop[2] netConn_projEE_ampa[3] = new NetCon(&v(0.5), syn_projEE_ampa[3], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 4: cell 3, seg 0 (0.5) [0.5 on Epop[3]] -> cell 9, seg 0 (0.5) [0.5 on Epop[9]], weight: 4.1363508E-4, delay 1.5
        h("Epop[9] syn_projEE_ampa[4] = new ampa(0.5)")
        h("Epop[3] netConn_projEE_ampa[4] = new NetCon(&v(0.5), syn_projEE_ampa[4], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 5: cell 3, seg 0 (0.5) [0.5 on Epop[3]] -> cell 10, seg 0 (0.5) [0.5 on Epop[10]], weight: 4.1363508E-4, delay 1.5
        h("Epop[10] syn_projEE_ampa[5] = new ampa(0.5)")
        h("Epop[3] netConn_projEE_ampa[5] = new NetCon(&v(0.5), syn_projEE_ampa[5], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 6: cell 3, seg 0 (0.5) [0.5 on Epop[3]] -> cell 18, seg 0 (0.5) [0.5 on Epop[18]], weight: 4.1363508E-4, delay 1.5
        h("Epop[18] syn_projEE_ampa[6] = new ampa(0.5)")
        h("Epop[3] netConn_projEE_ampa[6] = new NetCon(&v(0.5), syn_projEE_ampa[6], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 7: cell 5, seg 0 (0.5) [0.5 on Epop[5]] -> cell 17, seg 0 (0.5) [0.5 on Epop[17]], weight: 4.1363508E-4, delay 1.5
        h("Epop[17] syn_projEE_ampa[7] = new ampa(0.5)")
        h("Epop[5] netConn_projEE_ampa[7] = new NetCon(&v(0.5), syn_projEE_ampa[7], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 8: cell 6, seg 0 (0.5) [0.5 on Epop[6]] -> cell 5, seg 0 (0.5) [0.5 on Epop[5]], weight: 4.1363508E-4, delay 1.5
        h("Epop[5] syn_projEE_ampa[8] = new ampa(0.5)")
        h("Epop[6] netConn_projEE_ampa[8] = new NetCon(&v(0.5), syn_projEE_ampa[8], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 9: cell 6, seg 0 (0.5) [0.5 on Epop[6]] -> cell 7, seg 0 (0.5) [0.5 on Epop[7]], weight: 4.1363508E-4, delay 1.5
        h("Epop[7] syn_projEE_ampa[9] = new ampa(0.5)")
        h("Epop[6] netConn_projEE_ampa[9] = new NetCon(&v(0.5), syn_projEE_ampa[9], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 10: cell 7, seg 0 (0.5) [0.5 on Epop[7]] -> cell 9, seg 0 (0.5) [0.5 on Epop[9]], weight: 4.1363508E-4, delay 1.5
        h("Epop[9] syn_projEE_ampa[10] = new ampa(0.5)")
        h("Epop[7] netConn_projEE_ampa[10] = new NetCon(&v(0.5), syn_projEE_ampa[10], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 11: cell 7, seg 0 (0.5) [0.5 on Epop[7]] -> cell 17, seg 0 (0.5) [0.5 on Epop[17]], weight: 4.1363508E-4, delay 1.5
        h("Epop[17] syn_projEE_ampa[11] = new ampa(0.5)")
        h("Epop[7] netConn_projEE_ampa[11] = new NetCon(&v(0.5), syn_projEE_ampa[11], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 12: cell 10, seg 0 (0.5) [0.5 on Epop[10]] -> cell 18, seg 0 (0.5) [0.5 on Epop[18]], weight: 4.1363508E-4, delay 1.5
        h("Epop[18] syn_projEE_ampa[12] = new ampa(0.5)")
        h("Epop[10] netConn_projEE_ampa[12] = new NetCon(&v(0.5), syn_projEE_ampa[12], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 13: cell 11, seg 0 (0.5) [0.5 on Epop[11]] -> cell 5, seg 0 (0.5) [0.5 on Epop[5]], weight: 4.1363508E-4, delay 1.5
        h("Epop[5] syn_projEE_ampa[13] = new ampa(0.5)")
        h("Epop[11] netConn_projEE_ampa[13] = new NetCon(&v(0.5), syn_projEE_ampa[13], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 14: cell 11, seg 0 (0.5) [0.5 on Epop[11]] -> cell 8, seg 0 (0.5) [0.5 on Epop[8]], weight: 4.1363508E-4, delay 1.5
        h("Epop[8] syn_projEE_ampa[14] = new ampa(0.5)")
        h("Epop[11] netConn_projEE_ampa[14] = new NetCon(&v(0.5), syn_projEE_ampa[14], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 15: cell 11, seg 0 (0.5) [0.5 on Epop[11]] -> cell 9, seg 0 (0.5) [0.5 on Epop[9]], weight: 4.1363508E-4, delay 1.5
        h("Epop[9] syn_projEE_ampa[15] = new ampa(0.5)")
        h("Epop[11] netConn_projEE_ampa[15] = new NetCon(&v(0.5), syn_projEE_ampa[15], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 16: cell 11, seg 0 (0.5) [0.5 on Epop[11]] -> cell 19, seg 0 (0.5) [0.5 on Epop[19]], weight: 4.1363508E-4, delay 1.5
        h("Epop[19] syn_projEE_ampa[16] = new ampa(0.5)")
        h("Epop[11] netConn_projEE_ampa[16] = new NetCon(&v(0.5), syn_projEE_ampa[16], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 17: cell 13, seg 0 (0.5) [0.5 on Epop[13]] -> cell 14, seg 0 (0.5) [0.5 on Epop[14]], weight: 4.1363508E-4, delay 1.5
        h("Epop[14] syn_projEE_ampa[17] = new ampa(0.5)")
        h("Epop[13] netConn_projEE_ampa[17] = new NetCon(&v(0.5), syn_projEE_ampa[17], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 18: cell 15, seg 0 (0.5) [0.5 on Epop[15]] -> cell 10, seg 0 (0.5) [0.5 on Epop[10]], weight: 4.1363508E-4, delay 1.5
        h("Epop[10] syn_projEE_ampa[18] = new ampa(0.5)")
        h("Epop[15] netConn_projEE_ampa[18] = new NetCon(&v(0.5), syn_projEE_ampa[18], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 19: cell 16, seg 0 (0.5) [0.5 on Epop[16]] -> cell 9, seg 0 (0.5) [0.5 on Epop[9]], weight: 4.1363508E-4, delay 1.5
        h("Epop[9] syn_projEE_ampa[19] = new ampa(0.5)")
        h("Epop[16] netConn_projEE_ampa[19] = new NetCon(&v(0.5), syn_projEE_ampa[19], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 20: cell 16, seg 0 (0.5) [0.5 on Epop[16]] -> cell 13, seg 0 (0.5) [0.5 on Epop[13]], weight: 4.1363508E-4, delay 1.5
        h("Epop[13] syn_projEE_ampa[20] = new ampa(0.5)")
        h("Epop[16] netConn_projEE_ampa[20] = new NetCon(&v(0.5), syn_projEE_ampa[20], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 21: cell 17, seg 0 (0.5) [0.5 on Epop[17]] -> cell 5, seg 0 (0.5) [0.5 on Epop[5]], weight: 4.1363508E-4, delay 1.5
        h("Epop[5] syn_projEE_ampa[21] = new ampa(0.5)")
        h("Epop[17] netConn_projEE_ampa[21] = new NetCon(&v(0.5), syn_projEE_ampa[21], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 22: cell 18, seg 0 (0.5) [0.5 on Epop[18]] -> cell 3, seg 0 (0.5) [0.5 on Epop[3]], weight: 4.1363508E-4, delay 1.5
        h("Epop[3] syn_projEE_ampa[22] = new ampa(0.5)")
        h("Epop[18] netConn_projEE_ampa[22] = new NetCon(&v(0.5), syn_projEE_ampa[22], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 23: cell 18, seg 0 (0.5) [0.5 on Epop[18]] -> cell 7, seg 0 (0.5) [0.5 on Epop[7]], weight: 4.1363508E-4, delay 1.5
        h("Epop[7] syn_projEE_ampa[23] = new ampa(0.5)")
        h("Epop[18] netConn_projEE_ampa[23] = new NetCon(&v(0.5), syn_projEE_ampa[23], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 24: cell 18, seg 0 (0.5) [0.5 on Epop[18]] -> cell 11, seg 0 (0.5) [0.5 on Epop[11]], weight: 4.1363508E-4, delay 1.5
        h("Epop[11] syn_projEE_ampa[24] = new ampa(0.5)")
        h("Epop[18] netConn_projEE_ampa[24] = new NetCon(&v(0.5), syn_projEE_ampa[24], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 25: cell 18, seg 0 (0.5) [0.5 on Epop[18]] -> cell 12, seg 0 (0.5) [0.5 on Epop[12]], weight: 4.1363508E-4, delay 1.5
        h("Epop[12] syn_projEE_ampa[25] = new ampa(0.5)")
        h("Epop[18] netConn_projEE_ampa[25] = new NetCon(&v(0.5), syn_projEE_ampa[25], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 26: cell 18, seg 0 (0.5) [0.5 on Epop[18]] -> cell 14, seg 0 (0.5) [0.5 on Epop[14]], weight: 4.1363508E-4, delay 1.5
        h("Epop[14] syn_projEE_ampa[26] = new ampa(0.5)")
        h("Epop[18] netConn_projEE_ampa[26] = new NetCon(&v(0.5), syn_projEE_ampa[26], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 27: cell 19, seg 0 (0.5) [0.5 on Epop[19]] -> cell 7, seg 0 (0.5) [0.5 on Epop[7]], weight: 4.1363508E-4, delay 1.5
        h("Epop[7] syn_projEE_ampa[27] = new ampa(0.5)")
        h("Epop[19] netConn_projEE_ampa[27] = new NetCon(&v(0.5), syn_projEE_ampa[27], 20.0, 1.5, 4.1363508E-4)")  

        # ######################   Projection: projEI
        print("Adding projection: projEI, from Epop to Ipop with synapse ampa, 12 connection(s)")

        h("objectvar syn_projEI_ampa[12]")

        h("objectvar netConn_projEI_ampa[12]")

        # Connection 0: cell 0, seg 0 (0.5) [0.5 on Epop[0]] -> cell 2, seg 0 (0.5) [0.5 on Ipop[2]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[2] syn_projEI_ampa[0] = new ampa(0.5)")
        h("Epop[0] netConn_projEI_ampa[0] = new NetCon(&v(0.5), syn_projEI_ampa[0], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 1: cell 6, seg 0 (0.5) [0.5 on Epop[6]] -> cell 2, seg 0 (0.5) [0.5 on Ipop[2]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[2] syn_projEI_ampa[1] = new ampa(0.5)")
        h("Epop[6] netConn_projEI_ampa[1] = new NetCon(&v(0.5), syn_projEI_ampa[1], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 2: cell 7, seg 0 (0.5) [0.5 on Epop[7]] -> cell 1, seg 0 (0.5) [0.5 on Ipop[1]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[1] syn_projEI_ampa[2] = new ampa(0.5)")
        h("Epop[7] netConn_projEI_ampa[2] = new NetCon(&v(0.5), syn_projEI_ampa[2], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 3: cell 7, seg 0 (0.5) [0.5 on Epop[7]] -> cell 2, seg 0 (0.5) [0.5 on Ipop[2]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[2] syn_projEI_ampa[3] = new ampa(0.5)")
        h("Epop[7] netConn_projEI_ampa[3] = new NetCon(&v(0.5), syn_projEI_ampa[3], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 4: cell 10, seg 0 (0.5) [0.5 on Epop[10]] -> cell 0, seg 0 (0.5) [0.5 on Ipop[0]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[0] syn_projEI_ampa[4] = new ampa(0.5)")
        h("Epop[10] netConn_projEI_ampa[4] = new NetCon(&v(0.5), syn_projEI_ampa[4], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 5: cell 11, seg 0 (0.5) [0.5 on Epop[11]] -> cell 0, seg 0 (0.5) [0.5 on Ipop[0]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[0] syn_projEI_ampa[5] = new ampa(0.5)")
        h("Epop[11] netConn_projEI_ampa[5] = new NetCon(&v(0.5), syn_projEI_ampa[5], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 6: cell 11, seg 0 (0.5) [0.5 on Epop[11]] -> cell 4, seg 0 (0.5) [0.5 on Ipop[4]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[4] syn_projEI_ampa[6] = new ampa(0.5)")
        h("Epop[11] netConn_projEI_ampa[6] = new NetCon(&v(0.5), syn_projEI_ampa[6], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 7: cell 12, seg 0 (0.5) [0.5 on Epop[12]] -> cell 0, seg 0 (0.5) [0.5 on Ipop[0]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[0] syn_projEI_ampa[7] = new ampa(0.5)")
        h("Epop[12] netConn_projEI_ampa[7] = new NetCon(&v(0.5), syn_projEI_ampa[7], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 8: cell 13, seg 0 (0.5) [0.5 on Epop[13]] -> cell 2, seg 0 (0.5) [0.5 on Ipop[2]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[2] syn_projEI_ampa[8] = new ampa(0.5)")
        h("Epop[13] netConn_projEI_ampa[8] = new NetCon(&v(0.5), syn_projEI_ampa[8], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 9: cell 14, seg 0 (0.5) [0.5 on Epop[14]] -> cell 4, seg 0 (0.5) [0.5 on Ipop[4]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[4] syn_projEI_ampa[9] = new ampa(0.5)")
        h("Epop[14] netConn_projEI_ampa[9] = new NetCon(&v(0.5), syn_projEI_ampa[9], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 10: cell 15, seg 0 (0.5) [0.5 on Epop[15]] -> cell 3, seg 0 (0.5) [0.5 on Ipop[3]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[3] syn_projEI_ampa[10] = new ampa(0.5)")
        h("Epop[15] netConn_projEI_ampa[10] = new NetCon(&v(0.5), syn_projEI_ampa[10], 20.0, 1.5, 4.1363508E-4)")  

        # Connection 11: cell 16, seg 0 (0.5) [0.5 on Epop[16]] -> cell 4, seg 0 (0.5) [0.5 on Ipop[4]], weight: 4.1363508E-4, delay 1.5
        h("Ipop[4] syn_projEI_ampa[11] = new ampa(0.5)")
        h("Epop[16] netConn_projEI_ampa[11] = new NetCon(&v(0.5), syn_projEI_ampa[11], 20.0, 1.5, 4.1363508E-4)")  

        # ######################   Projection: projIE
        print("Adding projection: projIE, from Ipop to Epop with synapse gaba, 4 connection(s)")

        h("objectvar syn_projIE_gaba[4]")

        h("objectvar netConn_projIE_gaba[4]")

        # Connection 0: cell 0, seg 0 (0.5) [0.5 on Ipop[0]] -> cell 18, seg 0 (0.5) [0.5 on Epop[18]], weight: -0.0016545403, delay 1.5
        h("Epop[18] syn_projIE_gaba[0] = new gaba(0.5)")
        h("Ipop[0] netConn_projIE_gaba[0] = new NetCon(&v(0.5), syn_projIE_gaba[0], 20.0, 1.5, -0.0016545403)")  

        # Connection 1: cell 1, seg 0 (0.5) [0.5 on Ipop[1]] -> cell 2, seg 0 (0.5) [0.5 on Epop[2]], weight: -0.0016545403, delay 1.5
        h("Epop[2] syn_projIE_gaba[1] = new gaba(0.5)")
        h("Ipop[1] netConn_projIE_gaba[1] = new NetCon(&v(0.5), syn_projIE_gaba[1], 20.0, 1.5, -0.0016545403)")  

        # Connection 2: cell 1, seg 0 (0.5) [0.5 on Ipop[1]] -> cell 3, seg 0 (0.5) [0.5 on Epop[3]], weight: -0.0016545403, delay 1.5
        h("Epop[3] syn_projIE_gaba[2] = new gaba(0.5)")
        h("Ipop[1] netConn_projIE_gaba[2] = new NetCon(&v(0.5), syn_projIE_gaba[2], 20.0, 1.5, -0.0016545403)")  

        # Connection 3: cell 4, seg 0 (0.5) [0.5 on Ipop[4]] -> cell 6, seg 0 (0.5) [0.5 on Epop[6]], weight: -0.0016545403, delay 1.5
        h("Epop[6] syn_projIE_gaba[3] = new gaba(0.5)")
        h("Ipop[4] netConn_projIE_gaba[3] = new NetCon(&v(0.5), syn_projIE_gaba[3], 20.0, 1.5, -0.0016545403)")  

        # ######################   Projection: projII
        print("Adding projection: projII, from Ipop to Ipop with synapse gaba, 2 connection(s)")

        h("objectvar syn_projII_gaba[2]")

        h("objectvar netConn_projII_gaba[2]")

        # Connection 0: cell 0, seg 0 (0.5) [0.5 on Ipop[0]] -> cell 4, seg 0 (0.5) [0.5 on Ipop[4]], weight: -0.0016545403, delay 1.5
        h("Ipop[4] syn_projII_gaba[0] = new gaba(0.5)")
        h("Ipop[0] netConn_projII_gaba[0] = new NetCon(&v(0.5), syn_projII_gaba[0], 20.0, 1.5, -0.0016545403)")  

        # Connection 1: cell 2, seg 0 (0.5) [0.5 on Ipop[2]] -> cell 4, seg 0 (0.5) [0.5 on Ipop[4]], weight: -0.0016545403, delay 1.5
        h("Ipop[4] syn_projII_gaba[1] = new gaba(0.5)")
        h("Ipop[2] netConn_projII_gaba[1] = new NetCon(&v(0.5), syn_projII_gaba[1], 20.0, 1.5, -0.0016545403)")  

        trec = h.Vector()
        trec.record(h._ref_t)

        h.tstop = tstop

        h.dt = dt

        h.steps_per_ms = 1/h.dt



        # ######################   File to save: SimExample7.Ipop.spikes (SimExample7_Ipop_spikes)
        h(' objectvar spiketimes_SimExample7_Ipop_spikes, t_spiketimes_SimExample7_Ipop_spikes ')
        h(' { spiketimes_SimExample7_Ipop_spikes = new Vector() } ')
        h(' { t_spiketimes_SimExample7_Ipop_spikes = new Vector() } ')
        h(' objref netConnSpike_SimExample7_Ipop_spikes, nil ')
        # Column: Ipop/0/ifcell (0) Ipop[0]
        h(' Ipop[0] { netConnSpike_SimExample7_Ipop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Ipop_spikes.record(t_spiketimes_SimExample7_Ipop_spikes, spiketimes_SimExample7_Ipop_spikes, 0) } ')
        # Column: Ipop/1/ifcell (1) Ipop[1]
        h(' Ipop[1] { netConnSpike_SimExample7_Ipop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Ipop_spikes.record(t_spiketimes_SimExample7_Ipop_spikes, spiketimes_SimExample7_Ipop_spikes, 1) } ')
        # Column: Ipop/2/ifcell (2) Ipop[2]
        h(' Ipop[2] { netConnSpike_SimExample7_Ipop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Ipop_spikes.record(t_spiketimes_SimExample7_Ipop_spikes, spiketimes_SimExample7_Ipop_spikes, 2) } ')
        # Column: Ipop/3/ifcell (3) Ipop[3]
        h(' Ipop[3] { netConnSpike_SimExample7_Ipop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Ipop_spikes.record(t_spiketimes_SimExample7_Ipop_spikes, spiketimes_SimExample7_Ipop_spikes, 3) } ')
        # Column: Ipop/4/ifcell (4) Ipop[4]
        h(' Ipop[4] { netConnSpike_SimExample7_Ipop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Ipop_spikes.record(t_spiketimes_SimExample7_Ipop_spikes, spiketimes_SimExample7_Ipop_spikes, 4) } ')

        # ######################   File to save: SimExample7.Ipop.v.dat (SimExample7_Ipop_v_dat)
        # Column: Ipop/0/ifcell/v
        h(' objectvar v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat ')
        h(' { v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat = new Vector() } ')
        h(' { v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat.record(&Ipop[0].v(0.5)) } ')
        h.v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat.resize((h.tstop * h.steps_per_ms) + 1)
        # Column: Ipop/1/ifcell/v
        h(' objectvar v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat ')
        h(' { v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat = new Vector() } ')
        h(' { v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat.record(&Ipop[1].v(0.5)) } ')
        h.v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat.resize((h.tstop * h.steps_per_ms) + 1)

        # ######################   File to save: SimExample7.inpoisson.spikes (SimExample7_inpoisson_spikes)
        h(' objectvar spiketimes_SimExample7_inpoisson_spikes, t_spiketimes_SimExample7_inpoisson_spikes ')
        h(' { spiketimes_SimExample7_inpoisson_spikes = new Vector() } ')
        h(' { t_spiketimes_SimExample7_inpoisson_spikes = new Vector() } ')
        h(' objref netConnSpike_SimExample7_inpoisson_spikes, nil ')
        # It's a spike source, will listen to m_poisson_input_inpoisson...
        h(' netConnSpike_SimExample7_inpoisson_spikes = new NetCon(m_poisson_input_inpoisson[0], nil) ')
        h(' { netConnSpike_SimExample7_inpoisson_spikes.record(t_spiketimes_SimExample7_inpoisson_spikes, spiketimes_SimExample7_inpoisson_spikes, 0) } ')
        # It's a spike source, will listen to m_poisson_input_inpoisson...
        h(' netConnSpike_SimExample7_inpoisson_spikes = new NetCon(m_poisson_input_inpoisson[1], nil) ')
        h(' { netConnSpike_SimExample7_inpoisson_spikes.record(t_spiketimes_SimExample7_inpoisson_spikes, spiketimes_SimExample7_inpoisson_spikes, 1) } ')
        # It's a spike source, will listen to m_poisson_input_inpoisson...
        h(' netConnSpike_SimExample7_inpoisson_spikes = new NetCon(m_poisson_input_inpoisson[2], nil) ')
        h(' { netConnSpike_SimExample7_inpoisson_spikes.record(t_spiketimes_SimExample7_inpoisson_spikes, spiketimes_SimExample7_inpoisson_spikes, 2) } ')
        # It's a spike source, will listen to m_poisson_input_inpoisson...
        h(' netConnSpike_SimExample7_inpoisson_spikes = new NetCon(m_poisson_input_inpoisson[3], nil) ')
        h(' { netConnSpike_SimExample7_inpoisson_spikes.record(t_spiketimes_SimExample7_inpoisson_spikes, spiketimes_SimExample7_inpoisson_spikes, 3) } ')
        # It's a spike source, will listen to m_poisson_input_inpoisson...
        h(' netConnSpike_SimExample7_inpoisson_spikes = new NetCon(m_poisson_input_inpoisson[4], nil) ')
        h(' { netConnSpike_SimExample7_inpoisson_spikes.record(t_spiketimes_SimExample7_inpoisson_spikes, spiketimes_SimExample7_inpoisson_spikes, 4) } ')

        # ######################   File to save: SimExample7.Epop.v.dat (SimExample7_Epop_v_dat)
        # Column: Epop/0/ifcell/v
        h(' objectvar v_Epop_0_ifcell_v_SimExample7_Epop_v_dat ')
        h(' { v_Epop_0_ifcell_v_SimExample7_Epop_v_dat = new Vector() } ')
        h(' { v_Epop_0_ifcell_v_SimExample7_Epop_v_dat.record(&Epop[0].v(0.5)) } ')
        h.v_Epop_0_ifcell_v_SimExample7_Epop_v_dat.resize((h.tstop * h.steps_per_ms) + 1)
        # Column: Epop/1/ifcell/v
        h(' objectvar v_Epop_1_ifcell_v_SimExample7_Epop_v_dat ')
        h(' { v_Epop_1_ifcell_v_SimExample7_Epop_v_dat = new Vector() } ')
        h(' { v_Epop_1_ifcell_v_SimExample7_Epop_v_dat.record(&Epop[1].v(0.5)) } ')
        h.v_Epop_1_ifcell_v_SimExample7_Epop_v_dat.resize((h.tstop * h.steps_per_ms) + 1)

        # ######################   File to save: time.dat (time)
        # Column: time
        h(' objectvar v_time ')
        h(' { v_time = new Vector() } ')
        h(' { v_time.record(&t) } ')
        h.v_time.resize((h.tstop * h.steps_per_ms) + 1)

        # ######################   File to save: SimExample7.Epop.spikes (SimExample7_Epop_spikes)
        h(' objectvar spiketimes_SimExample7_Epop_spikes, t_spiketimes_SimExample7_Epop_spikes ')
        h(' { spiketimes_SimExample7_Epop_spikes = new Vector() } ')
        h(' { t_spiketimes_SimExample7_Epop_spikes = new Vector() } ')
        h(' objref netConnSpike_SimExample7_Epop_spikes, nil ')
        # Column: Epop/0/ifcell (0) Epop[0]
        h(' Epop[0] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 0) } ')
        # Column: Epop/1/ifcell (1) Epop[1]
        h(' Epop[1] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 1) } ')
        # Column: Epop/2/ifcell (2) Epop[2]
        h(' Epop[2] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 2) } ')
        # Column: Epop/3/ifcell (3) Epop[3]
        h(' Epop[3] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 3) } ')
        # Column: Epop/4/ifcell (4) Epop[4]
        h(' Epop[4] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 4) } ')
        # Column: Epop/5/ifcell (5) Epop[5]
        h(' Epop[5] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 5) } ')
        # Column: Epop/6/ifcell (6) Epop[6]
        h(' Epop[6] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 6) } ')
        # Column: Epop/7/ifcell (7) Epop[7]
        h(' Epop[7] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 7) } ')
        # Column: Epop/8/ifcell (8) Epop[8]
        h(' Epop[8] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 8) } ')
        # Column: Epop/9/ifcell (9) Epop[9]
        h(' Epop[9] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 9) } ')
        # Column: Epop/10/ifcell (10) Epop[10]
        h(' Epop[10] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 10) } ')
        # Column: Epop/11/ifcell (11) Epop[11]
        h(' Epop[11] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 11) } ')
        # Column: Epop/12/ifcell (12) Epop[12]
        h(' Epop[12] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 12) } ')
        # Column: Epop/13/ifcell (13) Epop[13]
        h(' Epop[13] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 13) } ')
        # Column: Epop/14/ifcell (14) Epop[14]
        h(' Epop[14] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 14) } ')
        # Column: Epop/15/ifcell (15) Epop[15]
        h(' Epop[15] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 15) } ')
        # Column: Epop/16/ifcell (16) Epop[16]
        h(' Epop[16] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 16) } ')
        # Column: Epop/17/ifcell (17) Epop[17]
        h(' Epop[17] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 17) } ')
        # Column: Epop/18/ifcell (18) Epop[18]
        h(' Epop[18] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 18) } ')
        # Column: Epop/19/ifcell (19) Epop[19]
        h(' Epop[19] { netConnSpike_SimExample7_Epop_spikes = new NetCon(&v(0.5), nil, 20.0, 0, 1) } ')
        h(' { netConnSpike_SimExample7_Epop_spikes.record(t_spiketimes_SimExample7_Epop_spikes, spiketimes_SimExample7_Epop_spikes, 19) } ')

        # ######################   File to save: SimExample7.expoisson.spikes (SimExample7_expoisson_spikes)
        h(' objectvar spiketimes_SimExample7_expoisson_spikes, t_spiketimes_SimExample7_expoisson_spikes ')
        h(' { spiketimes_SimExample7_expoisson_spikes = new Vector() } ')
        h(' { t_spiketimes_SimExample7_expoisson_spikes = new Vector() } ')
        h(' objref netConnSpike_SimExample7_expoisson_spikes, nil ')
        # It's a spike source, will listen to m_poisson_input_expoisson...
        h(' netConnSpike_SimExample7_expoisson_spikes = new NetCon(m_poisson_input_expoisson[0], nil) ')
        h(' { netConnSpike_SimExample7_expoisson_spikes.record(t_spiketimes_SimExample7_expoisson_spikes, spiketimes_SimExample7_expoisson_spikes, 0) } ')
        # It's a spike source, will listen to m_poisson_input_expoisson...
        h(' netConnSpike_SimExample7_expoisson_spikes = new NetCon(m_poisson_input_expoisson[1], nil) ')
        h(' { netConnSpike_SimExample7_expoisson_spikes.record(t_spiketimes_SimExample7_expoisson_spikes, spiketimes_SimExample7_expoisson_spikes, 1) } ')
        # It's a spike source, will listen to m_poisson_input_expoisson...
        h(' netConnSpike_SimExample7_expoisson_spikes = new NetCon(m_poisson_input_expoisson[2], nil) ')
        h(' { netConnSpike_SimExample7_expoisson_spikes.record(t_spiketimes_SimExample7_expoisson_spikes, spiketimes_SimExample7_expoisson_spikes, 2) } ')
        # It's a spike source, will listen to m_poisson_input_expoisson...
        h(' netConnSpike_SimExample7_expoisson_spikes = new NetCon(m_poisson_input_expoisson[3], nil) ')
        h(' { netConnSpike_SimExample7_expoisson_spikes.record(t_spiketimes_SimExample7_expoisson_spikes, spiketimes_SimExample7_expoisson_spikes, 3) } ')
        # It's a spike source, will listen to m_poisson_input_expoisson...
        h(' netConnSpike_SimExample7_expoisson_spikes = new NetCon(m_poisson_input_expoisson[4], nil) ')
        h(' { netConnSpike_SimExample7_expoisson_spikes.record(t_spiketimes_SimExample7_expoisson_spikes, spiketimes_SimExample7_expoisson_spikes, 4) } ')

        self.initialized = False

        self.sim_end = -1 # will be overwritten

        setup_end = time.time()
        self.setup_time = setup_end - self.setup_start
        print("Setting up the network to simulate took %f seconds"%(self.setup_time))

    def run(self):

        self.initialized = True
        sim_start = time.time()
        print("Running a simulation of %sms (dt = %sms; seed=%s)" % (h.tstop, h.dt, self.seed))

        try:
            h.run()
        except Exception as e:
            print("Exception running NEURON: %s" % (e))
            quit()


        self.sim_end = time.time()
        self.sim_time = self.sim_end - sim_start
        print("Finished NEURON simulation in %f seconds (%f mins)..."%(self.sim_time, self.sim_time/60.0))

        try:
            self.save_results()
        except Exception as e:
            print("Exception saving results of NEURON simulation: %s" % (e))
            quit()


    def advance(self):

        if not self.initialized:
            h.finitialize()
            self.initialized = True

        h.fadvance()


    ###############################################################################
    # Hash function to use in generation of random value
    # This is copied from NetPyNE: https://github.com/Neurosim-lab/netpyne/blob/master/netpyne/simFuncs.py
    ###############################################################################
    def _id32 (self,obj): 
        return int(hashlib.md5(obj.encode('utf-8')).hexdigest()[0:8],16)  # convert 8 first chars of md5 hash in base 16 to int


    ###############################################################################
    # Initialize the stim randomizer
    # This is copied from NetPyNE: https://github.com/Neurosim-lab/netpyne/blob/master/netpyne/simFuncs.py
    ###############################################################################
    def _init_stim_randomizer(self,rand, stimType, gid, seed): 
        #print("INIT STIM  %s; %s; %s; %s"%(rand, stimType, gid, seed))
        rand.Random123(self._id32(stimType), gid, seed)


    def save_results(self):

        print("Saving results at t=%s..."%h.t)

        if self.sim_end < 0: self.sim_end = time.time()


        # ######################   File to save: time.dat (time)
        py_v_time = [ t/1000 for t in h.v_time.to_python() ]  # Convert to Python list for speed...

        f_time_f2 = open('time.dat', 'w')
        num_points = len(py_v_time)  # Simulation may have been stopped before tstop...

        for i in range(num_points):
            f_time_f2.write('%f'% py_v_time[i])  # Save in SI units...
        f_time_f2.close()
        print("Saved data to: time.dat")

        # ######################   File to save: SimExample7.Ipop.spikes (SimExample7_Ipop_spikes)

        f_SimExample7_Ipop_spikes_f2 = open('SimExample7.Ipop.spikes', 'w')
        h(' objref netConnSpike_SimExample7_Ipop_spikes ')
        spike_ids = h.spiketimes_SimExample7_Ipop_spikes.to_python()  
        spike_times = h.t_spiketimes_SimExample7_Ipop_spikes.to_python()
        for i, id in enumerate(spike_ids):
            # Saving in format: ID_TIME
            f_SimExample7_Ipop_spikes_f2.write("%i\t%s\n"%(id,spike_times[i]/1000.0))
        f_SimExample7_Ipop_spikes_f2.close()
        print("Saved data to: SimExample7.Ipop.spikes")

        # ######################   File to save: SimExample7.Ipop.v.dat (SimExample7_Ipop_v_dat)
        py_v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat = [ float(x  / 1000.0) for x in h.v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat.to_python() ]  # Convert to Python list for speed, variable has dim: voltage
        py_v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat = [ float(x  / 1000.0) for x in h.v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat.to_python() ]  # Convert to Python list for speed, variable has dim: voltage

        f_SimExample7_Ipop_v_dat_f2 = open('SimExample7.Ipop.v.dat', 'w')
        num_points = len(py_v_time)  # Simulation may have been stopped before tstop...

        for i in range(num_points):
            f_SimExample7_Ipop_v_dat_f2.write('%e\t%e\t%e\t\n' % (py_v_time[i], py_v_Ipop_0_ifcell_v_SimExample7_Ipop_v_dat[i], py_v_Ipop_1_ifcell_v_SimExample7_Ipop_v_dat[i], ))
        f_SimExample7_Ipop_v_dat_f2.close()
        print("Saved data to: SimExample7.Ipop.v.dat")

        # ######################   File to save: SimExample7.inpoisson.spikes (SimExample7_inpoisson_spikes)

        f_SimExample7_inpoisson_spikes_f2 = open('SimExample7.inpoisson.spikes', 'w')
        h(' objref netConnSpike_SimExample7_inpoisson_spikes ')
        spike_ids = h.spiketimes_SimExample7_inpoisson_spikes.to_python()  
        spike_times = h.t_spiketimes_SimExample7_inpoisson_spikes.to_python()
        for i, id in enumerate(spike_ids):
            # Saving in format: ID_TIME
            f_SimExample7_inpoisson_spikes_f2.write("%i\t%s\n"%(id,spike_times[i]/1000.0))
        f_SimExample7_inpoisson_spikes_f2.close()
        print("Saved data to: SimExample7.inpoisson.spikes")

        # ######################   File to save: SimExample7.Epop.v.dat (SimExample7_Epop_v_dat)
        py_v_Epop_0_ifcell_v_SimExample7_Epop_v_dat = [ float(x  / 1000.0) for x in h.v_Epop_0_ifcell_v_SimExample7_Epop_v_dat.to_python() ]  # Convert to Python list for speed, variable has dim: voltage
        py_v_Epop_1_ifcell_v_SimExample7_Epop_v_dat = [ float(x  / 1000.0) for x in h.v_Epop_1_ifcell_v_SimExample7_Epop_v_dat.to_python() ]  # Convert to Python list for speed, variable has dim: voltage

        f_SimExample7_Epop_v_dat_f2 = open('SimExample7.Epop.v.dat', 'w')
        num_points = len(py_v_time)  # Simulation may have been stopped before tstop...

        for i in range(num_points):
            f_SimExample7_Epop_v_dat_f2.write('%e\t%e\t%e\t\n' % (py_v_time[i], py_v_Epop_0_ifcell_v_SimExample7_Epop_v_dat[i], py_v_Epop_1_ifcell_v_SimExample7_Epop_v_dat[i], ))
        f_SimExample7_Epop_v_dat_f2.close()
        print("Saved data to: SimExample7.Epop.v.dat")

        # ######################   File to save: SimExample7.Epop.spikes (SimExample7_Epop_spikes)

        f_SimExample7_Epop_spikes_f2 = open('SimExample7.Epop.spikes', 'w')
        h(' objref netConnSpike_SimExample7_Epop_spikes ')
        spike_ids = h.spiketimes_SimExample7_Epop_spikes.to_python()  
        spike_times = h.t_spiketimes_SimExample7_Epop_spikes.to_python()
        for i, id in enumerate(spike_ids):
            # Saving in format: ID_TIME
            f_SimExample7_Epop_spikes_f2.write("%i\t%s\n"%(id,spike_times[i]/1000.0))
        f_SimExample7_Epop_spikes_f2.close()
        print("Saved data to: SimExample7.Epop.spikes")

        # ######################   File to save: SimExample7.expoisson.spikes (SimExample7_expoisson_spikes)

        f_SimExample7_expoisson_spikes_f2 = open('SimExample7.expoisson.spikes', 'w')
        h(' objref netConnSpike_SimExample7_expoisson_spikes ')
        spike_ids = h.spiketimes_SimExample7_expoisson_spikes.to_python()  
        spike_times = h.t_spiketimes_SimExample7_expoisson_spikes.to_python()
        for i, id in enumerate(spike_ids):
            # Saving in format: ID_TIME
            f_SimExample7_expoisson_spikes_f2.write("%i\t%s\n"%(id,spike_times[i]/1000.0))
        f_SimExample7_expoisson_spikes_f2.close()
        print("Saved data to: SimExample7.expoisson.spikes")

        save_end = time.time()
        save_time = save_end - self.sim_end
        print("Finished saving results in %f seconds"%(save_time))

        self.report_file.write('StartTime=%s\n'%datetime.datetime.fromtimestamp(self.setup_start).strftime('%Y-%m-%d %H:%M:%S'))
        self.report_file.write('SetupTime=%s\n'%self.setup_time)
        self.report_file.write('RealSimulationTime=%s\n'%self.sim_time)
        self.report_file.write('SimulationSaveTime=%s\n'%save_time)
        self.report_file.close()

        print("Saving report of simulation to %s"%('report.SimExample7.txt'))

        print("Done")

        quit()


if __name__ == '__main__':

    ns = NeuronSimulation(tstop=1000.0, dt=0.025, seed=123)

    ns.run()

