#!/usr/bin/env python

import re
from setuptools import setup, find_packages

try:
    import pypandoc
    long_description = pypandoc.convert('README.md', 'rst')
except (IOError, ImportError):
    long_description = open('README.md').read()

version = ''
with open('punter/__init__.py', 'r') as fd:
    version = re.search(r'^__version__\s*=\s*[\'"]([^\'"]*)[\'"]',
                        fd.read(), re.MULTILINE).group(1)

if not version:
    raise RuntimeError('Cannot find version information')


setup(
    name='punter',
    version=version,
    description='Python wrapper for the Email Hunter API',
    long_description=long_description,
    author='Joshua Goodlett',
    author_email='joshuagoodlett@gmail.com',
    url='https://github.com/jgoodlet/punter',
    license='MIT',
    packages=find_packages(),
    tests_require=['pytest'],
    install_requires=['requests>=2.7.0'],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4'
    ]
)