# Generated by Django 3.1.4 on 2020-12-16 17:56

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="LinearIssue",
            fields=[
                ("id", models.UUIDField(primary_key=True, serialize=False)),
                ("identifier", models.CharField(max_length=10)),
                ("team_name", models.CharField(max_length=100, verbose_name="team")),
                (
                    "project_name",
                    models.CharField(
                        blank=True, default="", max_length=100, verbose_name="project"
                    ),
                ),
                (
                    "milestone_name",
                    models.CharField(
                        blank=True, default="", max_length=100, verbose_name="milestone"
                    ),
                ),
                ("title", models.CharField(blank=True, default="", max_length=100)),
                (
                    "estimate",
                    models.IntegerField(
                        choices=[
                            (1, "👕"),
                            (2, "👕👕"),
                            (3, "👕👕👕"),
                            (5, "👕👕👕👕"),
                            (8, "👕👕👕👕👕"),
                        ],
                        null=True,
                    ),
                ),
                (
                    "assignee_name",
                    models.CharField(max_length=100, verbose_name="assigned to"),
                ),
                ("state", models.CharField(max_length=100)),
                (
                    "created_at",
                    models.DateTimeField(
                        help_text="When this issue was created in Linear"
                    ),
                ),
                (
                    "last_updated_at",
                    models.DateTimeField(
                        help_text="When this issue was updated in Linear"
                    ),
                ),
                (
                    "last_refreshed_at",
                    models.DateTimeField(
                        help_text="When this issue was last refreshed from Linear, via import or webhook"
                    ),
                ),
            ],
            options={
                "ordering": ["identifier"],
                "permissions": [("use_api", "Can run Linear API queries")],
            },
        ),
    ]
