import * as ec2 from '@aws-cdk/aws-ec2';
import * as route53 from '@aws-cdk/aws-route53';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface VSCodeFargateProps {
    /**
     * An optional HostedZone to use.
     *
     * If not provided, then `domainName` is used to look one up using context
     *
     * @stability stable
     * @optional true
     */
    readonly hostedZone?: route53.IHostedZone;
    /**
     * An optional container image to use.
     *
     * If not provided, then 'ghcr.io/linuxserver/code-server' is used.
     *
     * @default ghcr.io/linuxserver/code-server
     * @stability stable
     */
    readonly containerImage?: string;
    /**
     * A subdomain for the new endpoint.
     *
     * @stability stable
     * @example
     *
     * vscode
     */
    readonly subdomain: string;
    /**
     * A full domain to register the new endpoint in.
     *
     * @stability stable
     * @example
     *
     * myprojects.com
     */
    readonly domainName: string;
    /**
     * An optional VPC to put ECS in.
     *
     * @default default VPC from lookup
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * A construct that consists of an ECS Service and related infrastructure to host a VSCode instance using a container (defaults to ghcr.io/linuxserver/code-server). Data is persisted via an EFS volume.
 *
 * @stability stable
 */
export declare class VSCodeFargate extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly endpoint: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: VSCodeFargateProps);
}
