#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['aedttest', 'aedttest.clusters']

package_data = \
{'': ['*'],
 'aedttest': ['static/*',
              'static/css/*',
              'static/css/css-lib/*',
              'static/js/*',
              'static/js/js-lib/*',
              'static/templates/*']}

install_requires = \
['pyaedt==0.5.9', 'Django==3.2.8', 'tomli>=2.0.0']

extras_require = \
{'deploy': ['flit==3.4.0'],
 'test': ['pre-commit==2.15.0',
          'mypy==0.960',
          'pytest==6.2.5',
          'pytest-cov==3.0.0',
          'webdriver-manager',
          'selenium>4']}

entry_points = \
{'console_scripts': ['aedt_test_runner = aedttest.aedt_test_runner:main']}

setup(name='aedttest',
      version='0.0.1',
      description='Ansys Electronics Desktop Testing Framework.\nCurrent module allows to setup and run automated tests and validate results across multiple versions of\nAnsys Electronics Desktop products, eg HFSS, Maxwell, Icepak, Q3D, etc\n',
      author=None,
      author_email='Maksim Beliaev <maksim.beliaev@ansys.com>, Bo Yang <bo.yang@ansys.com>, Samuel Lopez <samuel.lopez@ansys.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
