"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleworkspaceProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs googleworkspace}
*/
class GoogleworkspaceProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs googleworkspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleworkspaceProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'googleworkspace',
            terraformGeneratorMetadata: {
                providerName: 'googleworkspace',
                providerVersion: '0.7.0',
                providerVersionConstraint: '~> 0.7'
            },
            terraformProviderSource: 'googleworkspace'
        });
        this._accessToken = config.accessToken;
        this._credentials = config.credentials;
        this._customerId = config.customerId;
        this._impersonatedUserEmail = config.impersonatedUserEmail;
        this._oauthScopes = config.oauthScopes;
        this._serviceAccount = config.serviceAccount;
        this._alias = config.alias;
    }
    get accessToken() {
        return this._accessToken;
    }
    set accessToken(value) {
        this._accessToken = value;
    }
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenInput() {
        return this._accessToken;
    }
    get credentials() {
        return this._credentials;
    }
    set credentials(value) {
        this._credentials = value;
    }
    resetCredentials() {
        this._credentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get credentialsInput() {
        return this._credentials;
    }
    get customerId() {
        return this._customerId;
    }
    set customerId(value) {
        this._customerId = value;
    }
    resetCustomerId() {
        this._customerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customerIdInput() {
        return this._customerId;
    }
    get impersonatedUserEmail() {
        return this._impersonatedUserEmail;
    }
    set impersonatedUserEmail(value) {
        this._impersonatedUserEmail = value;
    }
    resetImpersonatedUserEmail() {
        this._impersonatedUserEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonatedUserEmailInput() {
        return this._impersonatedUserEmail;
    }
    get oauthScopes() {
        return this._oauthScopes;
    }
    set oauthScopes(value) {
        this._oauthScopes = value;
    }
    resetOauthScopes() {
        this._oauthScopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthScopesInput() {
        return this._oauthScopes;
    }
    get serviceAccount() {
        return this._serviceAccount;
    }
    set serviceAccount(value) {
        this._serviceAccount = value;
    }
    resetServiceAccount() {
        this._serviceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountInput() {
        return this._serviceAccount;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_token: cdktf.stringToTerraform(this._accessToken),
            credentials: cdktf.stringToTerraform(this._credentials),
            customer_id: cdktf.stringToTerraform(this._customerId),
            impersonated_user_email: cdktf.stringToTerraform(this._impersonatedUserEmail),
            oauth_scopes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._oauthScopes),
            service_account: cdktf.stringToTerraform(this._serviceAccount),
            alias: cdktf.stringToTerraform(this._alias),
        };
    }
}
exports.GoogleworkspaceProvider = GoogleworkspaceProvider;
_a = JSII_RTTI_SYMBOL_1;
GoogleworkspaceProvider[_a] = { fqn: "@cdktf/provider-googleworkspace.provider.GoogleworkspaceProvider", version: "5.0.0" };
// =================
// STATIC PROPERTIES
// =================
GoogleworkspaceProvider.tfResourceType = "googleworkspace";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHJvdmlkZXIvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFTQSwrQkFBK0I7QUFpRC9COztFQUVFO0FBQ0YsTUFBYSx1QkFBd0IsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBT2xFLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFNBQXdDLEVBQUU7UUFDekYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxpQkFBaUI7WUFDeEMsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxpQkFBaUI7Z0JBQy9CLGVBQWUsRUFBRSxPQUFPO2dCQUN4Qix5QkFBeUIsRUFBRSxRQUFRO2FBQ3BDO1lBQ0QsdUJBQXVCLEVBQUUsaUJBQWlCO1NBQzNDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUM7UUFDM0QsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQVFELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQXlCO1FBQzlDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQXlCO1FBQzlDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQXlCO1FBQzdDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBeUI7UUFDeEQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDO0lBQ00sMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxTQUFTLENBQUM7SUFDMUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztJQUNyQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBMkI7UUFDaEQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBeUI7UUFDakQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFDRCxJQUFXLEtBQUssQ0FBQyxLQUF5QjtRQUN4QyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBQ00sVUFBVTtRQUNmLElBQUksQ0FBQyxNQUFNLEdBQUcsU0FBUyxDQUFDO0lBQzFCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3ZELFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN0RCx1QkFBdUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDO1lBQzdFLFlBQVksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ2pGLGVBQWUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQztZQUM5RCxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDNUMsQ0FBQztJQUNKLENBQUM7O0FBdktILDBEQXdLQzs7O0FBdEtDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csc0NBQWMsR0FBRyxpQkFBaUIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluYy5cbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG4gKi9cblxuLy8gaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9nb29nbGV3b3Jrc3BhY2UvMC43LjAvZG9jc1xuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIEdvb2dsZXdvcmtzcGFjZVByb3ZpZGVyQ29uZmlnIHtcbiAgLyoqXG4gICogQSB0ZW1wb3JhcnkgW09BdXRoIDIuMCBhY2Nlc3MgdG9rZW5dIG9idGFpbmVkIGZyb20gdGhlIEdvb2dsZSBBdXRob3JpemF0aW9uIHNlcnZlciwgaS5lLiB0aGUgYEF1dGhvcml6YXRpb246IEJlYXJlcmAgdG9rZW4gdXNlZCB0byBhdXRoZW50aWNhdGUgSFRUUCByZXF1ZXN0cyB0byBHb29nbGUgQWRtaW4gU0RLIEFQSXMuIFRoaXMgaXMgYW4gYWx0ZXJuYXRpdmUgdG8gYGNyZWRlbnRpYWxzYCwgYW5kIGlnbm9yZXMgdGhlIGBvYXV0aF9zY29wZXNgIGZpZWxkLiBJZiBib3RoIGFyZSBzcGVjaWZpZWQsIGBhY2Nlc3NfdG9rZW5gIHdpbGwgYmUgdXNlZCBvdmVyIHRoZSBgY3JlZGVudGlhbHNgIGZpZWxkLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9nb29nbGV3b3Jrc3BhY2UvMC43LjAvZG9jcyNhY2Nlc3NfdG9rZW4gR29vZ2xld29ya3NwYWNlUHJvdmlkZXIjYWNjZXNzX3Rva2VufVxuICAqL1xuICByZWFkb25seSBhY2Nlc3NUb2tlbj86IHN0cmluZztcbiAgLyoqXG4gICogRWl0aGVyIHRoZSBwYXRoIHRvIG9yIHRoZSBjb250ZW50cyBvZiBhIHNlcnZpY2UgYWNjb3VudCBrZXkgZmlsZSBpbiBKU09OIGZvcm1hdCB5b3UgY2FuIG1hbmFnZSBrZXkgZmlsZXMgdXNpbmcgdGhlIENsb3VkIENvbnNvbGUpLiAgSWYgbm90IHByb3ZpZGVkLCB0aGUgYXBwbGljYXRpb24gZGVmYXVsdCBjcmVkZW50aWFscyB3aWxsIGJlIHVzZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL2dvb2dsZXdvcmtzcGFjZS8wLjcuMC9kb2NzI2NyZWRlbnRpYWxzIEdvb2dsZXdvcmtzcGFjZVByb3ZpZGVyI2NyZWRlbnRpYWxzfVxuICAqL1xuICByZWFkb25seSBjcmVkZW50aWFscz86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGN1c3RvbWVyIGlkIHByb3ZpZGVkIHdpdGggeW91ciBHb29nbGUgV29ya3NwYWNlIHN1YnNjcmlwdGlvbi4gSXQgaXMgZm91bmQgaW4gdGhlIGFkbWluIGNvbnNvbGUgdW5kZXIgQWNjb3VudCBTZXR0aW5ncy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvZ29vZ2xld29ya3NwYWNlLzAuNy4wL2RvY3MjY3VzdG9tZXJfaWQgR29vZ2xld29ya3NwYWNlUHJvdmlkZXIjY3VzdG9tZXJfaWR9XG4gICovXG4gIHJlYWRvbmx5IGN1c3RvbWVySWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBpbXBlcnNvbmF0ZWQgdXNlcidzIGVtYWlsIHdpdGggYWNjZXNzIHRvIHRoZSBBZG1pbiBBUElzIGNhbiBhY2Nlc3MgdGhlIEFkbWluIFNESyBEaXJlY3RvcnkgQVBJLiBgaW1wZXJzb25hdGVkX3VzZXJfZW1haWxgIGlzIHJlcXVpcmVkIGZvciBhbGwgc2VydmljZXMgZXhjZXB0IGdyb3VwIGFuZCB1c2VyIG1hbmFnZW1lbnQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL2dvb2dsZXdvcmtzcGFjZS8wLjcuMC9kb2NzI2ltcGVyc29uYXRlZF91c2VyX2VtYWlsIEdvb2dsZXdvcmtzcGFjZVByb3ZpZGVyI2ltcGVyc29uYXRlZF91c2VyX2VtYWlsfVxuICAqL1xuICByZWFkb25seSBpbXBlcnNvbmF0ZWRVc2VyRW1haWw/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBsaXN0IG9mIHRoZSBzY29wZXMgcmVxdWlyZWQgZm9yIHlvdXIgYXBwbGljYXRpb24gKGZvciBhIGxpc3Qgb2YgcG9zc2libGUgc2NvcGVzLCBzZWUgW0F1dGhvcml6ZSByZXF1ZXN0c10oaHR0cHM6Ly9kZXZlbG9wZXJzLmdvb2dsZS5jb20vYWRtaW4tc2RrL2RpcmVjdG9yeS92MS9ndWlkZXMvYXV0aG9yaXppbmcpKVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9nb29nbGV3b3Jrc3BhY2UvMC43LjAvZG9jcyNvYXV0aF9zY29wZXMgR29vZ2xld29ya3NwYWNlUHJvdmlkZXIjb2F1dGhfc2NvcGVzfVxuICAqL1xuICByZWFkb25seSBvYXV0aFNjb3Blcz86IHN0cmluZ1tdO1xuICAvKipcbiAgKiBUaGUgc2VydmljZSBhY2NvdW50IHVzZWQgdG8gY3JlYXRlIHRoZSBwcm92aWRlZCBgYWNjZXNzX3Rva2VuYCBpZiBhdXRoZW50aWNhdGluZyB1c2luZyB0aGUgYGFjY2Vzc190b2tlbmAgbWV0aG9kIGFuZCBuZWVkaW5nIHRvIGltcGVyc29uYXRlIGEgdXNlci4gVGhpcyBzZXJ2aWNlIGFjY291bnQgd2lsbCByZXF1aXJlIHRoZSBHQ1Agcm9sZSBgU2VydmljZSBBY2NvdW50IFRva2VuIENyZWF0b3JgIGlmIG5lZWRpbmcgdG8gaW1wZXJzb25hdGUgYSB1c2VyLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9nb29nbGV3b3Jrc3BhY2UvMC43LjAvZG9jcyNzZXJ2aWNlX2FjY291bnQgR29vZ2xld29ya3NwYWNlUHJvdmlkZXIjc2VydmljZV9hY2NvdW50fVxuICAqL1xuICByZWFkb25seSBzZXJ2aWNlQWNjb3VudD86IHN0cmluZztcbiAgLyoqXG4gICogQWxpYXMgbmFtZVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9nb29nbGV3b3Jrc3BhY2UvMC43LjAvZG9jcyNhbGlhcyBHb29nbGV3b3Jrc3BhY2VQcm92aWRlciNhbGlhc31cbiAgKi9cbiAgcmVhZG9ubHkgYWxpYXM/OiBzdHJpbmc7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvZ29vZ2xld29ya3NwYWNlLzAuNy4wL2RvY3MgZ29vZ2xld29ya3NwYWNlfVxuKi9cbmV4cG9ydCBjbGFzcyBHb29nbGV3b3Jrc3BhY2VQcm92aWRlciBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVByb3ZpZGVyIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJnb29nbGV3b3Jrc3BhY2VcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIC8qKlxuICAqIENyZWF0ZSBhIG5ldyB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9nb29nbGV3b3Jrc3BhY2UvMC43LjAvZG9jcyBnb29nbGV3b3Jrc3BhY2V9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIEdvb2dsZXdvcmtzcGFjZVByb3ZpZGVyQ29uZmlnID0ge31cbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogR29vZ2xld29ya3NwYWNlUHJvdmlkZXJDb25maWcgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnZ29vZ2xld29ya3NwYWNlJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2dvb2dsZXdvcmtzcGFjZScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzAuNy4wJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDAuNydcbiAgICAgIH0sXG4gICAgICB0ZXJyYWZvcm1Qcm92aWRlclNvdXJjZTogJ2dvb2dsZXdvcmtzcGFjZSdcbiAgICB9KTtcbiAgICB0aGlzLl9hY2Nlc3NUb2tlbiA9IGNvbmZpZy5hY2Nlc3NUb2tlbjtcbiAgICB0aGlzLl9jcmVkZW50aWFscyA9IGNvbmZpZy5jcmVkZW50aWFscztcbiAgICB0aGlzLl9jdXN0b21lcklkID0gY29uZmlnLmN1c3RvbWVySWQ7XG4gICAgdGhpcy5faW1wZXJzb25hdGVkVXNlckVtYWlsID0gY29uZmlnLmltcGVyc29uYXRlZFVzZXJFbWFpbDtcbiAgICB0aGlzLl9vYXV0aFNjb3BlcyA9IGNvbmZpZy5vYXV0aFNjb3BlcztcbiAgICB0aGlzLl9zZXJ2aWNlQWNjb3VudCA9IGNvbmZpZy5zZXJ2aWNlQWNjb3VudDtcbiAgICB0aGlzLl9hbGlhcyA9IGNvbmZpZy5hbGlhcztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYWNjZXNzX3Rva2VuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FjY2Vzc1Rva2VuPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhY2Nlc3NUb2tlbigpIHtcbiAgICByZXR1cm4gdGhpcy5fYWNjZXNzVG9rZW47XG4gIH1cbiAgcHVibGljIHNldCBhY2Nlc3NUb2tlbih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYWNjZXNzVG9rZW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBY2Nlc3NUb2tlbigpIHtcbiAgICB0aGlzLl9hY2Nlc3NUb2tlbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWNjZXNzVG9rZW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWNjZXNzVG9rZW47XG4gIH1cblxuICAvLyBjcmVkZW50aWFscyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcmVkZW50aWFscz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY3JlZGVudGlhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NyZWRlbnRpYWxzO1xuICB9XG4gIHB1YmxpYyBzZXQgY3JlZGVudGlhbHModmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2NyZWRlbnRpYWxzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q3JlZGVudGlhbHMoKSB7XG4gICAgdGhpcy5fY3JlZGVudGlhbHMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNyZWRlbnRpYWxzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NyZWRlbnRpYWxzO1xuICB9XG5cbiAgLy8gY3VzdG9tZXJfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3VzdG9tZXJJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY3VzdG9tZXJJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3VzdG9tZXJJZDtcbiAgfVxuICBwdWJsaWMgc2V0IGN1c3RvbWVySWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2N1c3RvbWVySWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDdXN0b21lcklkKCkge1xuICAgIHRoaXMuX2N1c3RvbWVySWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGN1c3RvbWVySWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3VzdG9tZXJJZDtcbiAgfVxuXG4gIC8vIGltcGVyc29uYXRlZF91c2VyX2VtYWlsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2ltcGVyc29uYXRlZFVzZXJFbWFpbD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaW1wZXJzb25hdGVkVXNlckVtYWlsKCkge1xuICAgIHJldHVybiB0aGlzLl9pbXBlcnNvbmF0ZWRVc2VyRW1haWw7XG4gIH1cbiAgcHVibGljIHNldCBpbXBlcnNvbmF0ZWRVc2VyRW1haWwodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2ltcGVyc29uYXRlZFVzZXJFbWFpbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEltcGVyc29uYXRlZFVzZXJFbWFpbCgpIHtcbiAgICB0aGlzLl9pbXBlcnNvbmF0ZWRVc2VyRW1haWwgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGltcGVyc29uYXRlZFVzZXJFbWFpbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pbXBlcnNvbmF0ZWRVc2VyRW1haWw7XG4gIH1cblxuICAvLyBvYXV0aF9zY29wZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb2F1dGhTY29wZXM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgb2F1dGhTY29wZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX29hdXRoU2NvcGVzO1xuICB9XG4gIHB1YmxpYyBzZXQgb2F1dGhTY29wZXModmFsdWU6IHN0cmluZ1tdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fb2F1dGhTY29wZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRPYXV0aFNjb3BlcygpIHtcbiAgICB0aGlzLl9vYXV0aFNjb3BlcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb2F1dGhTY29wZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fb2F1dGhTY29wZXM7XG4gIH1cblxuICAvLyBzZXJ2aWNlX2FjY291bnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2VydmljZUFjY291bnQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNlcnZpY2VBY2NvdW50KCkge1xuICAgIHJldHVybiB0aGlzLl9zZXJ2aWNlQWNjb3VudDtcbiAgfVxuICBwdWJsaWMgc2V0IHNlcnZpY2VBY2NvdW50KHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zZXJ2aWNlQWNjb3VudCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNlcnZpY2VBY2NvdW50KCkge1xuICAgIHRoaXMuX3NlcnZpY2VBY2NvdW50ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZXJ2aWNlQWNjb3VudElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zZXJ2aWNlQWNjb3VudDtcbiAgfVxuXG4gIC8vIGFsaWFzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsaWFzPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhbGlhcygpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxpYXM7XG4gIH1cbiAgcHVibGljIHNldCBhbGlhcyh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fYWxpYXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBbGlhcygpIHtcbiAgICB0aGlzLl9hbGlhcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWxpYXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxpYXM7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGFjY2Vzc190b2tlbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWNjZXNzVG9rZW4pLFxuICAgICAgY3JlZGVudGlhbHM6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2NyZWRlbnRpYWxzKSxcbiAgICAgIGN1c3RvbWVyX2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jdXN0b21lcklkKSxcbiAgICAgIGltcGVyc29uYXRlZF91c2VyX2VtYWlsOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pbXBlcnNvbmF0ZWRVc2VyRW1haWwpLFxuICAgICAgb2F1dGhfc2NvcGVzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtLCBmYWxzZSkodGhpcy5fb2F1dGhTY29wZXMpLFxuICAgICAgc2VydmljZV9hY2NvdW50OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zZXJ2aWNlQWNjb3VudCksXG4gICAgICBhbGlhczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWxpYXMpLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==