/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleworkspaceProviderConfig {
    /**
    * A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the `Authorization: Bearer` token used to authenticate HTTP requests to Google Admin SDK APIs. This is an alternative to `credentials`, and ignores the `oauth_scopes` field. If both are specified, `access_token` will be used over the `credentials` field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#access_token GoogleworkspaceProvider#access_token}
    */
    readonly accessToken?: string;
    /**
    * Either the path to or the contents of a service account key file in JSON format you can manage key files using the Cloud Console).  If not provided, the application default credentials will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#credentials GoogleworkspaceProvider#credentials}
    */
    readonly credentials?: string;
    /**
    * The customer id provided with your Google Workspace subscription. It is found in the admin console under Account Settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#customer_id GoogleworkspaceProvider#customer_id}
    */
    readonly customerId?: string;
    /**
    * The impersonated user's email with access to the Admin APIs can access the Admin SDK Directory API. `impersonated_user_email` is required for all services except group and user management.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#impersonated_user_email GoogleworkspaceProvider#impersonated_user_email}
    */
    readonly impersonatedUserEmail?: string;
    /**
    * The list of the scopes required for your application (for a list of possible scopes, see [Authorize requests](https://developers.google.com/admin-sdk/directory/v1/guides/authorizing))
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#oauth_scopes GoogleworkspaceProvider#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * The service account used to create the provided `access_token` if authenticating using the `access_token` method and needing to impersonate a user. This service account will require the GCP role `Service Account Token Creator` if needing to impersonate a user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#service_account GoogleworkspaceProvider#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs#alias GoogleworkspaceProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs googleworkspace}
*/
export declare class GoogleworkspaceProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "googleworkspace";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs googleworkspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleworkspaceProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleworkspaceProviderConfig);
    private _accessToken?;
    get accessToken(): string | undefined;
    set accessToken(value: string | undefined);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _credentials?;
    get credentials(): string | undefined;
    set credentials(value: string | undefined);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _customerId?;
    get customerId(): string | undefined;
    set customerId(value: string | undefined);
    resetCustomerId(): void;
    get customerIdInput(): string | undefined;
    private _impersonatedUserEmail?;
    get impersonatedUserEmail(): string | undefined;
    set impersonatedUserEmail(value: string | undefined);
    resetImpersonatedUserEmail(): void;
    get impersonatedUserEmailInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[] | undefined;
    set oauthScopes(value: string[] | undefined);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
