/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrgUnitConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defaults to `false`. Determines if a sub-organizational unit can inherit the settings of the parent organization. False means a sub-organizational unit inherits the settings of the nearest parent organizational unit. For more information on inheritance and users in an organization structure, see the [administration help center](https://support.google.com/a/answer/4352075).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit#block_inheritance OrgUnit#block_inheritance}
    */
    readonly blockInheritance?: boolean | cdktf.IResolvable;
    /**
    * Description of the organizational unit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit#description OrgUnit#description}
    */
    readonly description?: string;
    /**
    * The organizational unit's path name. For example, an organizational unit's name within the /corp/support/sales_support parent path is sales_support.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit#name OrgUnit#name}
    */
    readonly name: string;
    /**
    * The unique ID of the parent organizational unit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit#parent_org_unit_id OrgUnit#parent_org_unit_id}
    */
    readonly parentOrgUnitId?: string;
    /**
    * The organizational unit's parent path. For example, /corp/sales is the parent path for /corp/sales/sales_support organizational unit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit#parent_org_unit_path OrgUnit#parent_org_unit_path}
    */
    readonly parentOrgUnitPath?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit googleworkspace_org_unit}
*/
export declare class OrgUnit extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_org_unit";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/org_unit googleworkspace_org_unit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrgUnitConfig
    */
    constructor(scope: Construct, id: string, config: OrgUnitConfig);
    private _blockInheritance?;
    get blockInheritance(): boolean | cdktf.IResolvable;
    set blockInheritance(value: boolean | cdktf.IResolvable);
    resetBlockInheritance(): void;
    get blockInheritanceInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get orgUnitId(): string;
    get orgUnitPath(): string;
    private _parentOrgUnitId?;
    get parentOrgUnitId(): string;
    set parentOrgUnitId(value: string);
    resetParentOrgUnitId(): void;
    get parentOrgUnitIdInput(): string | undefined;
    private _parentOrgUnitPath?;
    get parentOrgUnitPath(): string;
    set parentOrgUnitPath(value: string);
    resetParentOrgUnitPath(): void;
    get parentOrgUnitPathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
