"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupSettings = exports.GroupSettingsTimeoutsOutputReference = exports.groupSettingsTimeoutsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function groupSettingsTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.groupSettingsTimeoutsToTerraform = groupSettingsTimeoutsToTerraform;
class GroupSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.GroupSettingsTimeoutsOutputReference = GroupSettingsTimeoutsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GroupSettingsTimeoutsOutputReference[_a] = { fqn: "@cdktf/provider-googleworkspace.groupSettings.GroupSettingsTimeoutsOutputReference", version: "5.0.0" };
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings googleworkspace_group_settings}
*/
class GroupSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings googleworkspace_group_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupSettingsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'googleworkspace_group_settings',
            terraformGeneratorMetadata: {
                providerName: 'googleworkspace',
                providerVersion: '0.7.0',
                providerVersionConstraint: '~> 0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new GroupSettingsTimeoutsOutputReference(this, "timeouts");
        this._allowExternalMembers = config.allowExternalMembers;
        this._allowWebPosting = config.allowWebPosting;
        this._archiveOnly = config.archiveOnly;
        this._customFooterText = config.customFooterText;
        this._customReplyTo = config.customReplyTo;
        this._defaultMessageDenyNotificationText = config.defaultMessageDenyNotificationText;
        this._email = config.email;
        this._enableCollaborativeInbox = config.enableCollaborativeInbox;
        this._includeCustomFooter = config.includeCustomFooter;
        this._includeInGlobalAddressList = config.includeInGlobalAddressList;
        this._isArchived = config.isArchived;
        this._membersCanPostAsTheGroup = config.membersCanPostAsTheGroup;
        this._messageModerationLevel = config.messageModerationLevel;
        this._primaryLanguage = config.primaryLanguage;
        this._replyTo = config.replyTo;
        this._sendMessageDenyNotification = config.sendMessageDenyNotification;
        this._spamModerationLevel = config.spamModerationLevel;
        this._whoCanAssistContent = config.whoCanAssistContent;
        this._whoCanContactOwner = config.whoCanContactOwner;
        this._whoCanDiscoverGroup = config.whoCanDiscoverGroup;
        this._whoCanJoin = config.whoCanJoin;
        this._whoCanLeaveGroup = config.whoCanLeaveGroup;
        this._whoCanModerateContent = config.whoCanModerateContent;
        this._whoCanModerateMembers = config.whoCanModerateMembers;
        this._whoCanPostMessage = config.whoCanPostMessage;
        this._whoCanViewGroup = config.whoCanViewGroup;
        this._whoCanViewMembership = config.whoCanViewMembership;
        this._timeouts.internalValue = config.timeouts;
    }
    get allowExternalMembers() {
        return this.getBooleanAttribute('allow_external_members');
    }
    set allowExternalMembers(value) {
        this._allowExternalMembers = value;
    }
    resetAllowExternalMembers() {
        this._allowExternalMembers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowExternalMembersInput() {
        return this._allowExternalMembers;
    }
    get allowWebPosting() {
        return this.getBooleanAttribute('allow_web_posting');
    }
    set allowWebPosting(value) {
        this._allowWebPosting = value;
    }
    resetAllowWebPosting() {
        this._allowWebPosting = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowWebPostingInput() {
        return this._allowWebPosting;
    }
    get archiveOnly() {
        return this.getBooleanAttribute('archive_only');
    }
    set archiveOnly(value) {
        this._archiveOnly = value;
    }
    resetArchiveOnly() {
        this._archiveOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnlyInput() {
        return this._archiveOnly;
    }
    get customFooterText() {
        return this.getStringAttribute('custom_footer_text');
    }
    set customFooterText(value) {
        this._customFooterText = value;
    }
    resetCustomFooterText() {
        this._customFooterText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customFooterTextInput() {
        return this._customFooterText;
    }
    get customReplyTo() {
        return this.getStringAttribute('custom_reply_to');
    }
    set customReplyTo(value) {
        this._customReplyTo = value;
    }
    resetCustomReplyTo() {
        this._customReplyTo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customReplyToInput() {
        return this._customReplyTo;
    }
    // custom_roles_enabled_for_settings_to_be_merged - computed: true, optional: false, required: false
    get customRolesEnabledForSettingsToBeMerged() {
        return this.getBooleanAttribute('custom_roles_enabled_for_settings_to_be_merged');
    }
    get defaultMessageDenyNotificationText() {
        return this.getStringAttribute('default_message_deny_notification_text');
    }
    set defaultMessageDenyNotificationText(value) {
        this._defaultMessageDenyNotificationText = value;
    }
    resetDefaultMessageDenyNotificationText() {
        this._defaultMessageDenyNotificationText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultMessageDenyNotificationTextInput() {
        return this._defaultMessageDenyNotificationText;
    }
    // description - computed: true, optional: false, required: false
    get description() {
        return this.getStringAttribute('description');
    }
    get email() {
        return this.getStringAttribute('email');
    }
    set email(value) {
        this._email = value;
    }
    // Temporarily expose input value. Use with caution.
    get emailInput() {
        return this._email;
    }
    get enableCollaborativeInbox() {
        return this.getBooleanAttribute('enable_collaborative_inbox');
    }
    set enableCollaborativeInbox(value) {
        this._enableCollaborativeInbox = value;
    }
    resetEnableCollaborativeInbox() {
        this._enableCollaborativeInbox = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableCollaborativeInboxInput() {
        return this._enableCollaborativeInbox;
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get includeCustomFooter() {
        return this.getBooleanAttribute('include_custom_footer');
    }
    set includeCustomFooter(value) {
        this._includeCustomFooter = value;
    }
    resetIncludeCustomFooter() {
        this._includeCustomFooter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeCustomFooterInput() {
        return this._includeCustomFooter;
    }
    get includeInGlobalAddressList() {
        return this.getBooleanAttribute('include_in_global_address_list');
    }
    set includeInGlobalAddressList(value) {
        this._includeInGlobalAddressList = value;
    }
    resetIncludeInGlobalAddressList() {
        this._includeInGlobalAddressList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeInGlobalAddressListInput() {
        return this._includeInGlobalAddressList;
    }
    get isArchived() {
        return this.getBooleanAttribute('is_archived');
    }
    set isArchived(value) {
        this._isArchived = value;
    }
    resetIsArchived() {
        this._isArchived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isArchivedInput() {
        return this._isArchived;
    }
    get membersCanPostAsTheGroup() {
        return this.getBooleanAttribute('members_can_post_as_the_group');
    }
    set membersCanPostAsTheGroup(value) {
        this._membersCanPostAsTheGroup = value;
    }
    resetMembersCanPostAsTheGroup() {
        this._membersCanPostAsTheGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get membersCanPostAsTheGroupInput() {
        return this._membersCanPostAsTheGroup;
    }
    get messageModerationLevel() {
        return this.getStringAttribute('message_moderation_level');
    }
    set messageModerationLevel(value) {
        this._messageModerationLevel = value;
    }
    resetMessageModerationLevel() {
        this._messageModerationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageModerationLevelInput() {
        return this._messageModerationLevel;
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get primaryLanguage() {
        return this.getStringAttribute('primary_language');
    }
    set primaryLanguage(value) {
        this._primaryLanguage = value;
    }
    resetPrimaryLanguage() {
        this._primaryLanguage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryLanguageInput() {
        return this._primaryLanguage;
    }
    get replyTo() {
        return this.getStringAttribute('reply_to');
    }
    set replyTo(value) {
        this._replyTo = value;
    }
    resetReplyTo() {
        this._replyTo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replyToInput() {
        return this._replyTo;
    }
    get sendMessageDenyNotification() {
        return this.getBooleanAttribute('send_message_deny_notification');
    }
    set sendMessageDenyNotification(value) {
        this._sendMessageDenyNotification = value;
    }
    resetSendMessageDenyNotification() {
        this._sendMessageDenyNotification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendMessageDenyNotificationInput() {
        return this._sendMessageDenyNotification;
    }
    get spamModerationLevel() {
        return this.getStringAttribute('spam_moderation_level');
    }
    set spamModerationLevel(value) {
        this._spamModerationLevel = value;
    }
    resetSpamModerationLevel() {
        this._spamModerationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamModerationLevelInput() {
        return this._spamModerationLevel;
    }
    get whoCanAssistContent() {
        return this.getStringAttribute('who_can_assist_content');
    }
    set whoCanAssistContent(value) {
        this._whoCanAssistContent = value;
    }
    resetWhoCanAssistContent() {
        this._whoCanAssistContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanAssistContentInput() {
        return this._whoCanAssistContent;
    }
    get whoCanContactOwner() {
        return this.getStringAttribute('who_can_contact_owner');
    }
    set whoCanContactOwner(value) {
        this._whoCanContactOwner = value;
    }
    resetWhoCanContactOwner() {
        this._whoCanContactOwner = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanContactOwnerInput() {
        return this._whoCanContactOwner;
    }
    get whoCanDiscoverGroup() {
        return this.getStringAttribute('who_can_discover_group');
    }
    set whoCanDiscoverGroup(value) {
        this._whoCanDiscoverGroup = value;
    }
    resetWhoCanDiscoverGroup() {
        this._whoCanDiscoverGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanDiscoverGroupInput() {
        return this._whoCanDiscoverGroup;
    }
    get whoCanJoin() {
        return this.getStringAttribute('who_can_join');
    }
    set whoCanJoin(value) {
        this._whoCanJoin = value;
    }
    resetWhoCanJoin() {
        this._whoCanJoin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanJoinInput() {
        return this._whoCanJoin;
    }
    get whoCanLeaveGroup() {
        return this.getStringAttribute('who_can_leave_group');
    }
    set whoCanLeaveGroup(value) {
        this._whoCanLeaveGroup = value;
    }
    resetWhoCanLeaveGroup() {
        this._whoCanLeaveGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanLeaveGroupInput() {
        return this._whoCanLeaveGroup;
    }
    get whoCanModerateContent() {
        return this.getStringAttribute('who_can_moderate_content');
    }
    set whoCanModerateContent(value) {
        this._whoCanModerateContent = value;
    }
    resetWhoCanModerateContent() {
        this._whoCanModerateContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanModerateContentInput() {
        return this._whoCanModerateContent;
    }
    get whoCanModerateMembers() {
        return this.getStringAttribute('who_can_moderate_members');
    }
    set whoCanModerateMembers(value) {
        this._whoCanModerateMembers = value;
    }
    resetWhoCanModerateMembers() {
        this._whoCanModerateMembers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanModerateMembersInput() {
        return this._whoCanModerateMembers;
    }
    get whoCanPostMessage() {
        return this.getStringAttribute('who_can_post_message');
    }
    set whoCanPostMessage(value) {
        this._whoCanPostMessage = value;
    }
    resetWhoCanPostMessage() {
        this._whoCanPostMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanPostMessageInput() {
        return this._whoCanPostMessage;
    }
    get whoCanViewGroup() {
        return this.getStringAttribute('who_can_view_group');
    }
    set whoCanViewGroup(value) {
        this._whoCanViewGroup = value;
    }
    resetWhoCanViewGroup() {
        this._whoCanViewGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanViewGroupInput() {
        return this._whoCanViewGroup;
    }
    get whoCanViewMembership() {
        return this.getStringAttribute('who_can_view_membership');
    }
    set whoCanViewMembership(value) {
        this._whoCanViewMembership = value;
    }
    resetWhoCanViewMembership() {
        this._whoCanViewMembership = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanViewMembershipInput() {
        return this._whoCanViewMembership;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_external_members: cdktf.booleanToTerraform(this._allowExternalMembers),
            allow_web_posting: cdktf.booleanToTerraform(this._allowWebPosting),
            archive_only: cdktf.booleanToTerraform(this._archiveOnly),
            custom_footer_text: cdktf.stringToTerraform(this._customFooterText),
            custom_reply_to: cdktf.stringToTerraform(this._customReplyTo),
            default_message_deny_notification_text: cdktf.stringToTerraform(this._defaultMessageDenyNotificationText),
            email: cdktf.stringToTerraform(this._email),
            enable_collaborative_inbox: cdktf.booleanToTerraform(this._enableCollaborativeInbox),
            include_custom_footer: cdktf.booleanToTerraform(this._includeCustomFooter),
            include_in_global_address_list: cdktf.booleanToTerraform(this._includeInGlobalAddressList),
            is_archived: cdktf.booleanToTerraform(this._isArchived),
            members_can_post_as_the_group: cdktf.booleanToTerraform(this._membersCanPostAsTheGroup),
            message_moderation_level: cdktf.stringToTerraform(this._messageModerationLevel),
            primary_language: cdktf.stringToTerraform(this._primaryLanguage),
            reply_to: cdktf.stringToTerraform(this._replyTo),
            send_message_deny_notification: cdktf.booleanToTerraform(this._sendMessageDenyNotification),
            spam_moderation_level: cdktf.stringToTerraform(this._spamModerationLevel),
            who_can_assist_content: cdktf.stringToTerraform(this._whoCanAssistContent),
            who_can_contact_owner: cdktf.stringToTerraform(this._whoCanContactOwner),
            who_can_discover_group: cdktf.stringToTerraform(this._whoCanDiscoverGroup),
            who_can_join: cdktf.stringToTerraform(this._whoCanJoin),
            who_can_leave_group: cdktf.stringToTerraform(this._whoCanLeaveGroup),
            who_can_moderate_content: cdktf.stringToTerraform(this._whoCanModerateContent),
            who_can_moderate_members: cdktf.stringToTerraform(this._whoCanModerateMembers),
            who_can_post_message: cdktf.stringToTerraform(this._whoCanPostMessage),
            who_can_view_group: cdktf.stringToTerraform(this._whoCanViewGroup),
            who_can_view_membership: cdktf.stringToTerraform(this._whoCanViewMembership),
            timeouts: groupSettingsTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.GroupSettings = GroupSettings;
_b = JSII_RTTI_SYMBOL_1;
GroupSettings[_b] = { fqn: "@cdktf/provider-googleworkspace.groupSettings.GroupSettings", version: "5.0.0" };
// =================
// STATIC PROPERTIES
// =================
GroupSettings.tfResourceType = "googleworkspace_group_settings";
//# sourceMappingURL=data:application/json;base64,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