/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defaults to `false`. Identifies whether members external to your organization can join the group. If true, Google Workspace users external to your organization can become members of this group. If false, users not belonging to the organization are not allowed to become members of this group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#allow_external_members GroupSettings#allow_external_members}
    */
    readonly allowExternalMembers?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `true`. Allows posting from web. If true, allows any member to post to the group forum. If false, Members only use Gmail to communicate with the group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#allow_web_posting GroupSettings#allow_web_posting}
    */
    readonly allowWebPosting?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `false`. Allows the group to be archived only. If true, Group is archived and the group is inactive. New messages to this group are rejected. The older archived messages are browsable and searchable. If true, the `who_can_post_message` property is set to `NONE_CAN_POST`. If reverted from true to false, `who_can_post_message` is set to `ALL_MANAGERS_CAN_POST`. If false, The group is active and can receive messages. When false, updating `who_can_post_message` to `NONE_CAN_POST`, results in an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#archive_only GroupSettings#archive_only}
    */
    readonly archiveOnly?: boolean | cdktf.IResolvable;
    /**
    * Set the content of custom footer text. The maximum number of characters is 1,000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#custom_footer_text GroupSettings#custom_footer_text}
    */
    readonly customFooterText?: string;
    /**
    * An email address used when replying to a message if the `reply_to` property is set to `REPLY_TO_CUSTOM`. This address is defined by an account administrator. When the group's `reply_to` property is set to `REPLY_TO_CUSTOM`, the `custom_reply_to` property holds a custom email address used when replying to a message, the `custom_reply_to` property must have a text value or an error is returned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#custom_reply_to GroupSettings#custom_reply_to}
    */
    readonly customReplyTo?: string;
    /**
    * When a message is rejected, this is text for the rejection notification sent to the message's author. By default, this property is empty and has no value in the API's response body. The maximum notification text size is 10,000 characters. Requires `send_message_deny_notification` property to be true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#default_message_deny_notification_text GroupSettings#default_message_deny_notification_text}
    */
    readonly defaultMessageDenyNotificationText?: string;
    /**
    * The group's email address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#email GroupSettings#email}
    */
    readonly email: string;
    /**
    * Defaults to `false`. Specifies whether a collaborative inbox will remain turned on for the group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#enable_collaborative_inbox GroupSettings#enable_collaborative_inbox}
    */
    readonly enableCollaborativeInbox?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `false`. Whether to include custom footer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#include_custom_footer GroupSettings#include_custom_footer}
    */
    readonly includeCustomFooter?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `true`. Enables the group to be included in the Global Address List. If true, the group is included in the Global Address List. If false, it is not included in the Global Address List.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#include_in_global_address_list GroupSettings#include_in_global_address_list}
    */
    readonly includeInGlobalAddressList?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `false`. Allows the Group contents to be archived. If true, archive messages sent to the group. If false, Do not keep an archive of messages sent to this group. If false, previously archived messages remain in the archive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#is_archived GroupSettings#is_archived}
    */
    readonly isArchived?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `false`. Enables members to post messages as the group. If true, group member can post messages using the group's email address instead of their own email address. Message appear to originate from the group itself. Any message moderation settings on individual users or new members do not apply to posts made on behalf of the group. If false, members can not post in behalf of the group's email address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#members_can_post_as_the_group GroupSettings#members_can_post_as_the_group}
    */
    readonly membersCanPostAsTheGroup?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `MODERATE_NONE`. Moderation level of incoming messages. Possible values are:
      - `MODERATE_ALL_MESSAGES`: All messages are sent to the group owner's email address for approval. If approved, the message is sent to the group.
      - `MODERATE_NON_MEMBERS`: All messages from non group members are sent to the group owner's email address for approval. If approved, the message is sent to the group.
      - `MODERATE_NEW_MEMBERS`: All messages from new members are sent to the group owner's email address for approval. If approved, the message is sent to the group.
      - `MODERATE_NONE`: No moderator approval is required. Messages are delivered directly to the group.
      Note: When the `who_can_post_message` is set to `ANYONE_CAN_POST`, we recommend the `message_moderation_level` be set to `MODERATE_NON_MEMBERS` to protect the group from possible spam.When `member_can_post_as_the_group` is true, any message moderation settings on individual users or new members will not apply to posts made on behalf of the group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#message_moderation_level GroupSettings#message_moderation_level}
    */
    readonly messageModerationLevel?: string;
    /**
    * The primary language for group. For a group's primary language use the language tags from the Google Workspace languages found at Google Workspace Email Settings API Email Language Tags.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#primary_language GroupSettings#primary_language}
    */
    readonly primaryLanguage?: string;
    /**
    * Defaults to `REPLY_TO_IGNORE`. Specifies who receives the default reply. Possible values are:
      - `REPLY_TO_CUSTOM`: For replies to messages, use the group's custom email address. When set to `REPLY_TO_CUSTOM`, the `custom_reply_to` property holds the custom email address used when replying to a message, the customReplyTo property must have a value. Otherwise an error is returned.
      - `REPLY_TO_SENDER`: The reply sent to author of message.
      - `REPLY_TO_LIST`: This reply message is sent to the group.
      - `REPLY_TO_OWNER`: The reply is sent to the owner(s) of the group. This does not include the group's managers.
      - `REPLY_TO_IGNORE`: Group users individually decide where the message reply is sent.
      - `REPLY_TO_MANAGERS`: This reply message is sent to the group's managers, which includes all managers and the group owner.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#reply_to GroupSettings#reply_to}
    */
    readonly replyTo?: string;
    /**
    * Defaults to `false`. Allows a member to be notified if the member's message to the group is denied by the group owner. If true, when a message is rejected, send the deny message notification to the message author. The `default_message_deny_notification_text` property is dependent on the `send_message_deny_notification` property being true. If false, when a message is rejected, no notification is sent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#send_message_deny_notification GroupSettings#send_message_deny_notification}
    */
    readonly sendMessageDenyNotification?: boolean | cdktf.IResolvable;
    /**
    * Defaults to `MODERATE`. Specifies moderation levels for messages detected as spam. Possible values are:
      - `ALLOW`: Post the message to the group.
      - `MODERATE`: Send the message to the moderation queue. This is the default.
      - `SILENTLY_MODERATE`: Send the message to the moderation queue, but do not send notification to moderators.
      - `REJECT`: Immediately reject the message.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#spam_moderation_level GroupSettings#spam_moderation_level}
    */
    readonly spamModerationLevel?: string;
    /**
    * Defaults to `NONE`. Specifies who can moderate metadata. Possible values are:
      - `ALL_MEMBERS`
      - `OWNERS_AND_MANAGERS`
      - `MANAGERS_ONLY`
      - `OWNERS_ONLY`
      - `NONE`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_assist_content GroupSettings#who_can_assist_content}
    */
    readonly whoCanAssistContent?: string;
    /**
    * Defaults to `ANYONE_CAN_CONTACT`. Permission to contact owner of the group via web UI. Possible values are:
      - `ALL_IN_DOMAIN_CAN_CONTACT`
      - `ALL_MANAGERS_CAN_CONTACT`
      - `ALL_MEMBERS_CAN_CONTACT`
      - `ANYONE_CAN_CONTACT`
      - `ALL_OWNERS_CAN_CONTACT`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_contact_owner GroupSettings#who_can_contact_owner}
    */
    readonly whoCanContactOwner?: string;
    /**
    * Defaults to `ALL_IN_DOMAIN_CAN_DISCOVER`. Specifies the set of users for whom this group is discoverable. Possible values are:
      - `ANYONE_CAN_DISCOVER`
      - `ALL_IN_DOMAIN_CAN_DISCOVER`
      - `ALL_MEMBERS_CAN_DISCOVER`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_discover_group GroupSettings#who_can_discover_group}
    */
    readonly whoCanDiscoverGroup?: string;
    /**
    * Defaults to `CAN_REQUEST_TO_JOIN`. Permission to join group. Possible values are:
      - `ANYONE_CAN_JOIN`: Any Internet user, both inside and outside your domain, can join the group.
      - `ALL_IN_DOMAIN_CAN_JOIN`: Anyone in the account domain can join. This includes accounts with multiple domains.
      - `INVITED_CAN_JOIN`: Candidates for membership can be invited to join.
      - `CAN_REQUEST_TO_JOIN`: Non members can request an invitation to join.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_join GroupSettings#who_can_join}
    */
    readonly whoCanJoin?: string;
    /**
    * Defaults to `ALL_MEMBERS_CAN_LEAVE`. Permission to leave the group. Possible values are:
      - `ALL_MANAGERS_CAN_LEAVE`
      - `ALL_MEMBERS_CAN_LEAVE`
      - `NONE_CAN_LEAVE`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_leave_group GroupSettings#who_can_leave_group}
    */
    readonly whoCanLeaveGroup?: string;
    /**
    * Defaults to `OWNERS_AND_MANAGERS`. Specifies who can moderate content. Possible values are:
      - `ALL_MEMBERS`
      - `OWNERS_AND_MANAGERS`
      - `OWNERS_ONLY`
      - `NONE`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_moderate_content GroupSettings#who_can_moderate_content}
    */
    readonly whoCanModerateContent?: string;
    /**
    * Defaults to `OWNERS_AND_MANAGERS`. Specifies who can manage members. Possible values are:
      - `ALL_MEMBERS`
      - `OWNERS_AND_MANAGERS`
      - `OWNERS_ONLY`
      - `NONE`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_moderate_members GroupSettings#who_can_moderate_members}
    */
    readonly whoCanModerateMembers?: string;
    /**
    * Permissions to post messages. Possible values are:
      - `NONE_CAN_POST`: The group is disabled and archived. No one can post a message to this group. * When archiveOnly is false, updating whoCanPostMessage to NONE_CAN_POST, results in an error. * If archiveOnly is reverted from true to false, whoCanPostMessages is set to ALL_MANAGERS_CAN_POST.
      - `ALL_MANAGERS_CAN_POST`: Managers, including group owners, can post messages.
      - `ALL_MEMBERS_CAN_POST`: Any group member can post a message.
      - `ALL_OWNERS_CAN_POST`: Only group owners can post a message.
      - `ALL_IN_DOMAIN_CAN_POST`: Anyone in the account can post a message.
      - `ANYONE_CAN_POST`: Any Internet user who outside your account can access your Google Groups service and post a message.
      *Note: When `who_can_post_message` is set to `ANYONE_CAN_POST`, we recommend the`message_moderation_level` be set to `MODERATE_NON_MEMBERS` to protect the group from possible spam. Users not belonging to the organization are not allowed to become members of this group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_post_message GroupSettings#who_can_post_message}
    */
    readonly whoCanPostMessage?: string;
    /**
    * Defaults to `ALL_MEMBERS_CAN_VIEW`. Permissions to view group messages. Possible values are:
      - `ANYONE_CAN_VIEW`: Any Internet user can view the group's messages.
      - `ALL_IN_DOMAIN_CAN_VIEW`: Anyone in your account can view this group's messages.
      - `ALL_MEMBERS_CAN_VIEW`: All group members can view the group's messages.
      - `ALL_MANAGERS_CAN_VIEW`: Any group manager can view this group's messages.
      - `ALL_OWNERS_CAN_VIEW`: The group owners can view this group's messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_view_group GroupSettings#who_can_view_group}
    */
    readonly whoCanViewGroup?: string;
    /**
    * Defaults to `ALL_MEMBERS_CAN_VIEW`. Permissions to view membership. Possible values are:
      - `ALL_IN_DOMAIN_CAN_VIEW`: Anyone in the account can view the group members list. If a group already has external members, those members can still send email to this group.
      - `ALL_MEMBERS_CAN_VIEW`: The group members can view the group members list.
      - `ALL_MANAGERS_CAN_VIEW`: The group managers can view group members list.
      - `ALL_OWNERS_CAN_VIEW`: The group owners can view group members list.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#who_can_view_membership GroupSettings#who_can_view_membership}
    */
    readonly whoCanViewMembership?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#timeouts GroupSettings#timeouts}
    */
    readonly timeouts?: GroupSettingsTimeouts;
}
export interface GroupSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#create GroupSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings#update GroupSettings#update}
    */
    readonly update?: string;
}
export declare function groupSettingsTimeoutsToTerraform(struct?: GroupSettingsTimeouts | cdktf.IResolvable): any;
export declare class GroupSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GroupSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GroupSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings googleworkspace_group_settings}
*/
export declare class GroupSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_group_settings";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_settings googleworkspace_group_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupSettingsConfig
    */
    constructor(scope: Construct, id: string, config: GroupSettingsConfig);
    private _allowExternalMembers?;
    get allowExternalMembers(): boolean | cdktf.IResolvable;
    set allowExternalMembers(value: boolean | cdktf.IResolvable);
    resetAllowExternalMembers(): void;
    get allowExternalMembersInput(): boolean | cdktf.IResolvable | undefined;
    private _allowWebPosting?;
    get allowWebPosting(): boolean | cdktf.IResolvable;
    set allowWebPosting(value: boolean | cdktf.IResolvable);
    resetAllowWebPosting(): void;
    get allowWebPostingInput(): boolean | cdktf.IResolvable | undefined;
    private _archiveOnly?;
    get archiveOnly(): boolean | cdktf.IResolvable;
    set archiveOnly(value: boolean | cdktf.IResolvable);
    resetArchiveOnly(): void;
    get archiveOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _customFooterText?;
    get customFooterText(): string;
    set customFooterText(value: string);
    resetCustomFooterText(): void;
    get customFooterTextInput(): string | undefined;
    private _customReplyTo?;
    get customReplyTo(): string;
    set customReplyTo(value: string);
    resetCustomReplyTo(): void;
    get customReplyToInput(): string | undefined;
    get customRolesEnabledForSettingsToBeMerged(): cdktf.IResolvable;
    private _defaultMessageDenyNotificationText?;
    get defaultMessageDenyNotificationText(): string;
    set defaultMessageDenyNotificationText(value: string);
    resetDefaultMessageDenyNotificationText(): void;
    get defaultMessageDenyNotificationTextInput(): string | undefined;
    get description(): string;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _enableCollaborativeInbox?;
    get enableCollaborativeInbox(): boolean | cdktf.IResolvable;
    set enableCollaborativeInbox(value: boolean | cdktf.IResolvable);
    resetEnableCollaborativeInbox(): void;
    get enableCollaborativeInboxInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _includeCustomFooter?;
    get includeCustomFooter(): boolean | cdktf.IResolvable;
    set includeCustomFooter(value: boolean | cdktf.IResolvable);
    resetIncludeCustomFooter(): void;
    get includeCustomFooterInput(): boolean | cdktf.IResolvable | undefined;
    private _includeInGlobalAddressList?;
    get includeInGlobalAddressList(): boolean | cdktf.IResolvable;
    set includeInGlobalAddressList(value: boolean | cdktf.IResolvable);
    resetIncludeInGlobalAddressList(): void;
    get includeInGlobalAddressListInput(): boolean | cdktf.IResolvable | undefined;
    private _isArchived?;
    get isArchived(): boolean | cdktf.IResolvable;
    set isArchived(value: boolean | cdktf.IResolvable);
    resetIsArchived(): void;
    get isArchivedInput(): boolean | cdktf.IResolvable | undefined;
    private _membersCanPostAsTheGroup?;
    get membersCanPostAsTheGroup(): boolean | cdktf.IResolvable;
    set membersCanPostAsTheGroup(value: boolean | cdktf.IResolvable);
    resetMembersCanPostAsTheGroup(): void;
    get membersCanPostAsTheGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _messageModerationLevel?;
    get messageModerationLevel(): string;
    set messageModerationLevel(value: string);
    resetMessageModerationLevel(): void;
    get messageModerationLevelInput(): string | undefined;
    get name(): string;
    private _primaryLanguage?;
    get primaryLanguage(): string;
    set primaryLanguage(value: string);
    resetPrimaryLanguage(): void;
    get primaryLanguageInput(): string | undefined;
    private _replyTo?;
    get replyTo(): string;
    set replyTo(value: string);
    resetReplyTo(): void;
    get replyToInput(): string | undefined;
    private _sendMessageDenyNotification?;
    get sendMessageDenyNotification(): boolean | cdktf.IResolvable;
    set sendMessageDenyNotification(value: boolean | cdktf.IResolvable);
    resetSendMessageDenyNotification(): void;
    get sendMessageDenyNotificationInput(): boolean | cdktf.IResolvable | undefined;
    private _spamModerationLevel?;
    get spamModerationLevel(): string;
    set spamModerationLevel(value: string);
    resetSpamModerationLevel(): void;
    get spamModerationLevelInput(): string | undefined;
    private _whoCanAssistContent?;
    get whoCanAssistContent(): string;
    set whoCanAssistContent(value: string);
    resetWhoCanAssistContent(): void;
    get whoCanAssistContentInput(): string | undefined;
    private _whoCanContactOwner?;
    get whoCanContactOwner(): string;
    set whoCanContactOwner(value: string);
    resetWhoCanContactOwner(): void;
    get whoCanContactOwnerInput(): string | undefined;
    private _whoCanDiscoverGroup?;
    get whoCanDiscoverGroup(): string;
    set whoCanDiscoverGroup(value: string);
    resetWhoCanDiscoverGroup(): void;
    get whoCanDiscoverGroupInput(): string | undefined;
    private _whoCanJoin?;
    get whoCanJoin(): string;
    set whoCanJoin(value: string);
    resetWhoCanJoin(): void;
    get whoCanJoinInput(): string | undefined;
    private _whoCanLeaveGroup?;
    get whoCanLeaveGroup(): string;
    set whoCanLeaveGroup(value: string);
    resetWhoCanLeaveGroup(): void;
    get whoCanLeaveGroupInput(): string | undefined;
    private _whoCanModerateContent?;
    get whoCanModerateContent(): string;
    set whoCanModerateContent(value: string);
    resetWhoCanModerateContent(): void;
    get whoCanModerateContentInput(): string | undefined;
    private _whoCanModerateMembers?;
    get whoCanModerateMembers(): string;
    set whoCanModerateMembers(value: string);
    resetWhoCanModerateMembers(): void;
    get whoCanModerateMembersInput(): string | undefined;
    private _whoCanPostMessage?;
    get whoCanPostMessage(): string;
    set whoCanPostMessage(value: string);
    resetWhoCanPostMessage(): void;
    get whoCanPostMessageInput(): string | undefined;
    private _whoCanViewGroup?;
    get whoCanViewGroup(): string;
    set whoCanViewGroup(value: string);
    resetWhoCanViewGroup(): void;
    get whoCanViewGroupInput(): string | undefined;
    private _whoCanViewMembership?;
    get whoCanViewMembership(): string;
    set whoCanViewMembership(value: string);
    resetWhoCanViewMembership(): void;
    get whoCanViewMembershipInput(): string | undefined;
    private _timeouts;
    get timeouts(): GroupSettingsTimeoutsOutputReference;
    putTimeouts(value: GroupSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GroupSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
