/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defaults to `ALL_MAIL`. Defines mail delivery preferences of member. Acceptable values are:
      - `ALL_MAIL`: All messages, delivered as soon as they arrive.
      - `DAILY`: No more than one message a day.
      - `DIGEST`: Up to 25 messages bundled into a single message.
      - `DISABLED`: Remove subscription.
      - `NONE`: No messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#delivery_settings GroupMember#delivery_settings}
    */
    readonly deliverySettings?: string;
    /**
    * The member's email address. A member can be a user or another group. This property is required when adding a member to a group. The email must be unique and cannot be an alias of another group. If the email address is changed, the API automatically reflects the email address changes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#email GroupMember#email}
    */
    readonly email: string;
    /**
    * Identifies the group in the API request. The value can be the group's email address, group alias, or the unique group ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#group_id GroupMember#group_id}
    */
    readonly groupId: string;
    /**
    * Defaults to `MEMBER`. The member's role in a group. The API returns an error for cycles in group memberships. For example, if group1 is a member of group2, group2 cannot be a member of group1. Acceptable values are:
      - `MANAGER`: This role is only available if the Google Groups for Business is enabled using the Admin Console. A `MANAGER` role can do everything done by an `OWNER` role except make a member an `OWNER` or delete the group. A group can have multiple `MANAGER` members.
      - `MEMBER`: This role can subscribe to a group, view discussion archives, and view the group's membership list.
      - `OWNER`: This role can send messages to the group, add or remove members, change member roles, change group's settings, and delete the group. An OWNER must be a member of the group. A group can have more than one OWNER.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#role GroupMember#role}
    */
    readonly role?: string;
    /**
    * Defaults to `USER`. The type of group member. Acceptable values are:
      - `CUSTOMER`: The member represents all users in a domain. An email address is not returned and the ID returned is the customer ID.
      - `GROUP`: The member is another group.
      - `USER`: The member is a user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#type GroupMember#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#timeouts GroupMember#timeouts}
    */
    readonly timeouts?: GroupMemberTimeouts;
}
export interface GroupMemberTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#create GroupMember#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member#update GroupMember#update}
    */
    readonly update?: string;
}
export declare function groupMemberTimeoutsToTerraform(struct?: GroupMemberTimeouts | cdktf.IResolvable): any;
export declare class GroupMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GroupMemberTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GroupMemberTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member googleworkspace_group_member}
*/
export declare class GroupMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_group_member";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/group_member googleworkspace_group_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMemberConfig
    */
    constructor(scope: Construct, id: string, config: GroupMemberConfig);
    private _deliverySettings?;
    get deliverySettings(): string;
    set deliverySettings(value: string);
    resetDeliverySettings(): void;
    get deliverySettingsInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get etag(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    get memberId(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    get status(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GroupMemberTimeoutsOutputReference;
    putTimeouts(value: GroupMemberTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GroupMemberTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
