/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GmailSendAsAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * A name that appears in the 'From:' header for mail sent using this alias. For custom 'from' addresses, when this is empty, Gmail will populate the 'From:' header with the name that is used for the primary address associated with the account. If the admin has disabled the ability for users to update their name format, requests to update this field for the primary login will silently fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#display_name GmailSendAsAlias#display_name}
    */
    readonly displayName?: string;
    /**
    * Whether this address is selected as the default 'From:' address in situations such as composing a new message or sending a vacation auto-reply. Every Gmail account has exactly one default send-as address, so the only legal value that clients may write to this field is true. Changing this from false to true for an address will result in this field becoming false for the other previous default address. Toggling an existing alias' default to false is not possible, another alias must be added/imported and toggled to true to remove the default from an existing alias. To avoid drift with Terraform, please change the previous default's config to false AFTER a new default is applied and perform a refresh to synchronize with remote state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#is_default GmailSendAsAlias#is_default}
    */
    readonly isDefault?: boolean | cdktf.IResolvable;
    /**
    * User's primary email address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#primary_email GmailSendAsAlias#primary_email}
    */
    readonly primaryEmail: string;
    /**
    * An optional email address that is included in a 'Reply-To:' header for mail sent using this alias. If this is empty, Gmail will not generate a 'Reply-To:' header.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#reply_to_address GmailSendAsAlias#reply_to_address}
    */
    readonly replyToAddress?: string;
    /**
    * The email address that appears in the 'From:' header for mail sent using this alias.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#send_as_email GmailSendAsAlias#send_as_email}
    */
    readonly sendAsEmail: string;
    /**
    * An optional HTML signature that is included in messages composed with this alias in the Gmail web UI. This signature is added to new emails only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#signature GmailSendAsAlias#signature}
    */
    readonly signature?: string;
    /**
    * Defaults to `true`. Whether Gmail should treat this address as an alias for the user's primary email address. This setting only applies to custom 'from' aliases. See https://support.google.com/a/answer/1710338 for help on making this decision
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#treat_as_alias GmailSendAsAlias#treat_as_alias}
    */
    readonly treatAsAlias?: boolean | cdktf.IResolvable;
    /**
    * smtp_msa block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#smtp_msa GmailSendAsAlias#smtp_msa}
    */
    readonly smtpMsa?: GmailSendAsAliasSmtpMsa;
}
export interface GmailSendAsAliasSmtpMsa {
    /**
    * The hostname of the SMTP service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#host GmailSendAsAlias#host}
    */
    readonly host: string;
    /**
    * The password that will be used for authentication with the SMTP service. This is a write-only field that can be specified in requests to create or update SendAs settings; it is never populated in responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#password GmailSendAsAlias#password}
    */
    readonly password?: string;
    /**
    * The port of the SMTP service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#port GmailSendAsAlias#port}
    */
    readonly port: number;
    /**
    * Defaults to `securityModeUnspecified`. The protocol that will be used to secure communication with the SMTP service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#security_mode GmailSendAsAlias#security_mode}
    */
    readonly securityMode?: string;
    /**
    * The username that will be used for authentication with the SMTP service. This is a write-only field that can be specified in requests to create or update SendAs settings; it is never populated in responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias#username GmailSendAsAlias#username}
    */
    readonly username?: string;
}
export declare function gmailSendAsAliasSmtpMsaToTerraform(struct?: GmailSendAsAliasSmtpMsaOutputReference | GmailSendAsAliasSmtpMsa): any;
export declare class GmailSendAsAliasSmtpMsaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GmailSendAsAliasSmtpMsa | undefined;
    set internalValue(value: GmailSendAsAliasSmtpMsa | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _securityMode?;
    get securityMode(): string;
    set securityMode(value: string);
    resetSecurityMode(): void;
    get securityModeInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias googleworkspace_gmail_send_as_alias}
*/
export declare class GmailSendAsAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_gmail_send_as_alias";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/gmail_send_as_alias googleworkspace_gmail_send_as_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GmailSendAsAliasConfig
    */
    constructor(scope: Construct, id: string, config: GmailSendAsAliasConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _isDefault?;
    get isDefault(): boolean | cdktf.IResolvable;
    set isDefault(value: boolean | cdktf.IResolvable);
    resetIsDefault(): void;
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    get isPrimary(): cdktf.IResolvable;
    private _primaryEmail?;
    get primaryEmail(): string;
    set primaryEmail(value: string);
    get primaryEmailInput(): string | undefined;
    private _replyToAddress?;
    get replyToAddress(): string;
    set replyToAddress(value: string);
    resetReplyToAddress(): void;
    get replyToAddressInput(): string | undefined;
    private _sendAsEmail?;
    get sendAsEmail(): string;
    set sendAsEmail(value: string);
    get sendAsEmailInput(): string | undefined;
    private _signature?;
    get signature(): string;
    set signature(value: string);
    resetSignature(): void;
    get signatureInput(): string | undefined;
    private _treatAsAlias?;
    get treatAsAlias(): boolean | cdktf.IResolvable;
    set treatAsAlias(value: boolean | cdktf.IResolvable);
    resetTreatAsAlias(): void;
    get treatAsAliasInput(): boolean | cdktf.IResolvable | undefined;
    get verificationStatus(): string;
    private _smtpMsa;
    get smtpMsa(): GmailSendAsAliasSmtpMsaOutputReference;
    putSmtpMsa(value: GmailSendAsAliasSmtpMsa): void;
    resetSmtpMsa(): void;
    get smtpMsaInput(): GmailSendAsAliasSmtpMsa | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
