/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DomainAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * The domain alias name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/domain_alias#domain_alias_name DomainAlias#domain_alias_name}
    */
    readonly domainAliasName: string;
    /**
    * The parent domain name that the domain alias is associated with. This can either be a primary or secondary domain name within a customer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/domain_alias#parent_domain_name DomainAlias#parent_domain_name}
    */
    readonly parentDomainName?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/domain_alias googleworkspace_domain_alias}
*/
export declare class DomainAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_domain_alias";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/domain_alias googleworkspace_domain_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DomainAliasConfig
    */
    constructor(scope: Construct, id: string, config: DomainAliasConfig);
    get creationTime(): number;
    private _domainAliasName?;
    get domainAliasName(): string;
    set domainAliasName(value: string);
    get domainAliasNameInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _parentDomainName?;
    get parentDomainName(): string;
    set parentDomainName(value: string);
    resetParentDomainName(): void;
    get parentDomainNameInput(): string | undefined;
    get verified(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
