/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique identifier of the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/schema#schema_id DataGoogleworkspaceSchema#schema_id}
    */
    readonly schemaId?: string;
    /**
    * The schema's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/schema#schema_name DataGoogleworkspaceSchema#schema_name}
    */
    readonly schemaName?: string;
}
export interface DataGoogleworkspaceSchemaFieldsNumericIndexingSpec {
}
export declare function dataGoogleworkspaceSchemaFieldsNumericIndexingSpecToTerraform(struct?: DataGoogleworkspaceSchemaFieldsNumericIndexingSpec): any;
export declare class DataGoogleworkspaceSchemaFieldsNumericIndexingSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceSchemaFieldsNumericIndexingSpec | undefined;
    set internalValue(value: DataGoogleworkspaceSchemaFieldsNumericIndexingSpec | undefined);
    get maxValue(): number;
    get minValue(): number;
}
export declare class DataGoogleworkspaceSchemaFieldsNumericIndexingSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceSchemaFieldsNumericIndexingSpecOutputReference;
}
export interface DataGoogleworkspaceSchemaFields {
}
export declare function dataGoogleworkspaceSchemaFieldsToTerraform(struct?: DataGoogleworkspaceSchemaFields): any;
export declare class DataGoogleworkspaceSchemaFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceSchemaFields | undefined;
    set internalValue(value: DataGoogleworkspaceSchemaFields | undefined);
    get displayName(): string;
    get etag(): string;
    get fieldId(): string;
    get fieldName(): string;
    get fieldType(): string;
    get indexed(): cdktf.IResolvable;
    get multiValued(): cdktf.IResolvable;
    private _numericIndexingSpec;
    get numericIndexingSpec(): DataGoogleworkspaceSchemaFieldsNumericIndexingSpecList;
    get readAccessType(): string;
}
export declare class DataGoogleworkspaceSchemaFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceSchemaFieldsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/schema googleworkspace_schema}
*/
export declare class DataGoogleworkspaceSchema extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_schema";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/schema googleworkspace_schema} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceSchemaConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleworkspaceSchemaConfig);
    get displayName(): string;
    get etag(): string;
    private _fields;
    get fields(): DataGoogleworkspaceSchemaFieldsList;
    get id(): string;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
