/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/role#name DataGoogleworkspaceRole#name}
    */
    readonly name: string;
}
export interface DataGoogleworkspaceRolePrivileges {
}
export declare function dataGoogleworkspaceRolePrivilegesToTerraform(struct?: DataGoogleworkspaceRolePrivileges): any;
export declare class DataGoogleworkspaceRolePrivilegesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceRolePrivileges | undefined;
    set internalValue(value: DataGoogleworkspaceRolePrivileges | undefined);
    get privilegeName(): string;
    get serviceId(): string;
}
export declare class DataGoogleworkspaceRolePrivilegesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceRolePrivilegesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/role googleworkspace_role}
*/
export declare class DataGoogleworkspaceRole extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_role";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/role googleworkspace_role} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceRoleConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceRoleConfig);
    get description(): string;
    get etag(): string;
    get id(): string;
    get isSuperAdminRole(): cdktf.IResolvable;
    get isSystemRole(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privileges;
    get privileges(): DataGoogleworkspaceRolePrivilegesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
