/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The group's email address. If your account has multiple domains,select the appropriate domain for the email address. The email must be unique.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group#email DataGoogleworkspaceGroup#email}
    */
    readonly email?: string;
    /**
    * The unique ID of a group. A group id can be used as a group request URI's groupKey.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group#id DataGoogleworkspaceGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group googleworkspace_group}
*/
export declare class DataGoogleworkspaceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_group";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group googleworkspace_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleworkspaceGroupConfig);
    get adminCreated(): cdktf.IResolvable;
    get aliases(): string[];
    get description(): string;
    get directMembersCount(): number;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get nonEditableAliases(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
