/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceGroupMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * The member's email address. A member can be a user or another group. This property is required when adding a member to a group. The email must be unique and cannot be an alias of another group. If the email address is changed, the API automatically reflects the email address changes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group_member#email DataGoogleworkspaceGroupMember#email}
    */
    readonly email?: string;
    /**
    * Identifies the group in the API request. The value can be the group's email address, group alias, or the unique group ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group_member#group_id DataGoogleworkspaceGroupMember#group_id}
    */
    readonly groupId: string;
    /**
    * The unique ID of the group member. A member id can be used as a member request URI's memberKey.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group_member#member_id DataGoogleworkspaceGroupMember#member_id}
    */
    readonly memberId?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group_member googleworkspace_group_member}
*/
export declare class DataGoogleworkspaceGroupMember extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_group_member";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/data-sources/group_member googleworkspace_group_member} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceGroupMemberConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceGroupMemberConfig);
    get deliverySettings(): string;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    get etag(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    private _memberId?;
    get memberId(): string;
    set memberId(value: string);
    resetMemberId(): void;
    get memberIdInput(): string | undefined;
    get role(): string;
    get status(): string;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
