/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ChromePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy#id ChromePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The target org unit on which this policy is applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy#org_unit_id ChromePolicy#org_unit_id}
    */
    readonly orgUnitId: string;
    /**
    * policies block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy#policies ChromePolicy#policies}
    */
    readonly policies: ChromePolicyPolicies[] | cdktf.IResolvable;
}
export interface ChromePolicyPolicies {
    /**
    * The full qualified name of the policy schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy#schema_name ChromePolicy#schema_name}
    */
    readonly schemaName: string;
    /**
    * JSON encoded map that represents key/value pairs that correspond to the given schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy#schema_values ChromePolicy#schema_values}
    */
    readonly schemaValues: {
        [key: string]: string;
    };
}
export declare function chromePolicyPoliciesToTerraform(struct?: ChromePolicyPolicies | cdktf.IResolvable): any;
export declare class ChromePolicyPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ChromePolicyPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: ChromePolicyPolicies | cdktf.IResolvable | undefined);
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _schemaValues?;
    get schemaValues(): {
        [key: string]: string;
    };
    set schemaValues(value: {
        [key: string]: string;
    });
    get schemaValuesInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class ChromePolicyPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ChromePolicyPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ChromePolicyPoliciesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy googleworkspace_chrome_policy}
*/
export declare class ChromePolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_chrome_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/googleworkspace/0.7.0/docs/resources/chrome_policy googleworkspace_chrome_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChromePolicyConfig
    */
    constructor(scope: Construct, id: string, config: ChromePolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orgUnitId?;
    get orgUnitId(): string;
    set orgUnitId(value: string);
    get orgUnitIdInput(): string | undefined;
    private _policies;
    get policies(): ChromePolicyPoliciesList;
    putPolicies(value: ChromePolicyPolicies[] | cdktf.IResolvable): void;
    get policiesInput(): cdktf.IResolvable | ChromePolicyPolicies[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
