# datclass

python package datclass

## install

```sh
pip install -U datclass
pip install git+ssh://git@github.com/foyoux/datclass.git
pip install git+https://github.com/foyoux/datclass.git
```

## basic usage

<details>
<summary>Example 1</summary>

```py
from dataclasses import dataclass, field
from typing import Dict, List

from datclass import DatClass


@dataclass
class User(DatClass):
    name: str = None
    age: int = None


@dataclass
class Group(DatClass):
    name: str = None
    users: List[User] = field(default_factory=list)  # allow nested
    meta: Dict = field(default_factory=dict)


if __name__ == '__main__':
    dat = {
        'name': 'foyoux',
        'users': [
            {'name': 'foyou', 'age': 18},
            {'name': 'hello', 'age': 8, 'sex': 'male'},  # allow extra field
        ],
        'meta': {
            'field1': 'value1',
            'field2': 'value2',
            'field3': 'value3',
        },
    }

    group = Group(**dat)

    print(group.name, group.meta)
    for user in group.users:
        print(user.name, user.age)

```

</details>

## `datclass` command

```sh
usage: datclass [-h] [-v] [-n NAME] [-r] [-o OUTPUT] [file]

positional arguments:
  file                  input file - likes-json

options:
  -h, --help            show this help message and exit
  -v, --version         show program's version number and exit
  -n NAME, --name NAME  main dat class name
  -r, --recursive       recursive generate dat class
  -o OUTPUT, --output OUTPUT
                        output file - *.py
```
