# coding: utf-8

"""
    aind-slims-service

     ## aind-slims-service  Service to pull data from SLIMS.  

    The version of the OpenAPI document: 0.2.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SlimsSpimData(BaseModel):
    """
    Expected Model that needs to be extracted from SLIMS
    """ # noqa: E501
    experiment_run_created_on: Optional[datetime] = None
    specimen_id: Optional[StrictStr] = None
    subject_id: Optional[StrictStr] = None
    protocol_name: Optional[StrictStr] = None
    protocol_id: Optional[StrictStr] = None
    date_performed: Optional[StrictInt] = None
    chamber_immersion_medium: Optional[StrictStr] = None
    sample_immersion_medium: Optional[StrictStr] = None
    chamber_refractive_index: Optional[StrictStr] = None
    sample_refractive_index: Optional[StrictStr] = None
    instrument_id: Optional[StrictStr] = None
    experimenter_name: Optional[StrictStr] = None
    z_direction: Optional[StrictStr] = None
    y_direction: Optional[StrictStr] = None
    x_direction: Optional[StrictStr] = None
    imaging_channels: Optional[List[StrictStr]] = None
    stitching_channels: Optional[StrictStr] = None
    ccf_registration_channels: Optional[StrictStr] = None
    cell_segmentation_channels: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["experiment_run_created_on", "specimen_id", "subject_id", "protocol_name", "protocol_id", "date_performed", "chamber_immersion_medium", "sample_immersion_medium", "chamber_refractive_index", "sample_refractive_index", "instrument_id", "experimenter_name", "z_direction", "y_direction", "x_direction", "imaging_channels", "stitching_channels", "ccf_registration_channels", "cell_segmentation_channels"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlimsSpimData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if experiment_run_created_on (nullable) is None
        # and model_fields_set contains the field
        if self.experiment_run_created_on is None and "experiment_run_created_on" in self.model_fields_set:
            _dict['experiment_run_created_on'] = None

        # set to None if specimen_id (nullable) is None
        # and model_fields_set contains the field
        if self.specimen_id is None and "specimen_id" in self.model_fields_set:
            _dict['specimen_id'] = None

        # set to None if subject_id (nullable) is None
        # and model_fields_set contains the field
        if self.subject_id is None and "subject_id" in self.model_fields_set:
            _dict['subject_id'] = None

        # set to None if protocol_name (nullable) is None
        # and model_fields_set contains the field
        if self.protocol_name is None and "protocol_name" in self.model_fields_set:
            _dict['protocol_name'] = None

        # set to None if protocol_id (nullable) is None
        # and model_fields_set contains the field
        if self.protocol_id is None and "protocol_id" in self.model_fields_set:
            _dict['protocol_id'] = None

        # set to None if date_performed (nullable) is None
        # and model_fields_set contains the field
        if self.date_performed is None and "date_performed" in self.model_fields_set:
            _dict['date_performed'] = None

        # set to None if chamber_immersion_medium (nullable) is None
        # and model_fields_set contains the field
        if self.chamber_immersion_medium is None and "chamber_immersion_medium" in self.model_fields_set:
            _dict['chamber_immersion_medium'] = None

        # set to None if sample_immersion_medium (nullable) is None
        # and model_fields_set contains the field
        if self.sample_immersion_medium is None and "sample_immersion_medium" in self.model_fields_set:
            _dict['sample_immersion_medium'] = None

        # set to None if chamber_refractive_index (nullable) is None
        # and model_fields_set contains the field
        if self.chamber_refractive_index is None and "chamber_refractive_index" in self.model_fields_set:
            _dict['chamber_refractive_index'] = None

        # set to None if sample_refractive_index (nullable) is None
        # and model_fields_set contains the field
        if self.sample_refractive_index is None and "sample_refractive_index" in self.model_fields_set:
            _dict['sample_refractive_index'] = None

        # set to None if instrument_id (nullable) is None
        # and model_fields_set contains the field
        if self.instrument_id is None and "instrument_id" in self.model_fields_set:
            _dict['instrument_id'] = None

        # set to None if experimenter_name (nullable) is None
        # and model_fields_set contains the field
        if self.experimenter_name is None and "experimenter_name" in self.model_fields_set:
            _dict['experimenter_name'] = None

        # set to None if z_direction (nullable) is None
        # and model_fields_set contains the field
        if self.z_direction is None and "z_direction" in self.model_fields_set:
            _dict['z_direction'] = None

        # set to None if y_direction (nullable) is None
        # and model_fields_set contains the field
        if self.y_direction is None and "y_direction" in self.model_fields_set:
            _dict['y_direction'] = None

        # set to None if x_direction (nullable) is None
        # and model_fields_set contains the field
        if self.x_direction is None and "x_direction" in self.model_fields_set:
            _dict['x_direction'] = None

        # set to None if imaging_channels (nullable) is None
        # and model_fields_set contains the field
        if self.imaging_channels is None and "imaging_channels" in self.model_fields_set:
            _dict['imaging_channels'] = None

        # set to None if stitching_channels (nullable) is None
        # and model_fields_set contains the field
        if self.stitching_channels is None and "stitching_channels" in self.model_fields_set:
            _dict['stitching_channels'] = None

        # set to None if ccf_registration_channels (nullable) is None
        # and model_fields_set contains the field
        if self.ccf_registration_channels is None and "ccf_registration_channels" in self.model_fields_set:
            _dict['ccf_registration_channels'] = None

        # set to None if cell_segmentation_channels (nullable) is None
        # and model_fields_set contains the field
        if self.cell_segmentation_channels is None and "cell_segmentation_channels" in self.model_fields_set:
            _dict['cell_segmentation_channels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlimsSpimData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "experiment_run_created_on": obj.get("experiment_run_created_on"),
            "specimen_id": obj.get("specimen_id"),
            "subject_id": obj.get("subject_id"),
            "protocol_name": obj.get("protocol_name"),
            "protocol_id": obj.get("protocol_id"),
            "date_performed": obj.get("date_performed"),
            "chamber_immersion_medium": obj.get("chamber_immersion_medium"),
            "sample_immersion_medium": obj.get("sample_immersion_medium"),
            "chamber_refractive_index": obj.get("chamber_refractive_index"),
            "sample_refractive_index": obj.get("sample_refractive_index"),
            "instrument_id": obj.get("instrument_id"),
            "experimenter_name": obj.get("experimenter_name"),
            "z_direction": obj.get("z_direction"),
            "y_direction": obj.get("y_direction"),
            "x_direction": obj.get("x_direction"),
            "imaging_channels": obj.get("imaging_channels"),
            "stitching_channels": obj.get("stitching_channels"),
            "ccf_registration_channels": obj.get("ccf_registration_channels"),
            "cell_segmentation_channels": obj.get("cell_segmentation_channels")
        })
        return _obj


