# coding: utf-8

"""
    aind-slims-service

     ## aind-slims-service  Service to pull data from SLIMS.  

    The version of the OpenAPI document: 0.2.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_slims_service_async_client.models.ecephys_reward_spouts import EcephysRewardSpouts
from aind_slims_service_async_client.models.ecephys_stream_module import EcephysStreamModule
from typing import Optional, Set
from typing_extensions import Self

class SlimsEcephysData(BaseModel):
    """
    Expected Model that needs to be extracted from SLIMS
    """ # noqa: E501
    experiment_run_created_on: Optional[datetime] = None
    subject_id: Optional[StrictStr] = None
    operator: Optional[StrictStr] = None
    instrument: Optional[StrictStr] = None
    session_type: Optional[StrictStr] = None
    device_calibrations: Optional[StrictInt] = None
    mouse_platform_name: Optional[StrictStr] = None
    active_mouse_platform: Optional[StrictBool] = None
    session_name: Optional[StrictStr] = None
    animal_weight_prior: Optional[StrictStr] = None
    animal_weight_after: Optional[StrictStr] = None
    animal_weight_unit: Optional[StrictStr] = None
    reward_consumed: Optional[StrictStr] = None
    reward_consumed_unit: Optional[StrictStr] = None
    stimulus_epochs: Optional[StrictInt] = None
    link_to_stimulus_epoch_code: Optional[StrictStr] = None
    reward_solution: Optional[StrictStr] = None
    other_reward_solution: Optional[StrictStr] = None
    reward_spouts: Optional[List[EcephysRewardSpouts]] = None
    stream_modalities: Optional[List[StrictStr]] = None
    stream_modules: Optional[List[EcephysStreamModule]] = None
    daq_names: Optional[List[StrictStr]] = None
    camera_names: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["experiment_run_created_on", "subject_id", "operator", "instrument", "session_type", "device_calibrations", "mouse_platform_name", "active_mouse_platform", "session_name", "animal_weight_prior", "animal_weight_after", "animal_weight_unit", "reward_consumed", "reward_consumed_unit", "stimulus_epochs", "link_to_stimulus_epoch_code", "reward_solution", "other_reward_solution", "reward_spouts", "stream_modalities", "stream_modules", "daq_names", "camera_names"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SlimsEcephysData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in reward_spouts (list)
        _items = []
        if self.reward_spouts:
            for _item_reward_spouts in self.reward_spouts:
                if _item_reward_spouts:
                    _items.append(_item_reward_spouts.to_dict())
            _dict['reward_spouts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in stream_modules (list)
        _items = []
        if self.stream_modules:
            for _item_stream_modules in self.stream_modules:
                if _item_stream_modules:
                    _items.append(_item_stream_modules.to_dict())
            _dict['stream_modules'] = _items
        # set to None if experiment_run_created_on (nullable) is None
        # and model_fields_set contains the field
        if self.experiment_run_created_on is None and "experiment_run_created_on" in self.model_fields_set:
            _dict['experiment_run_created_on'] = None

        # set to None if subject_id (nullable) is None
        # and model_fields_set contains the field
        if self.subject_id is None and "subject_id" in self.model_fields_set:
            _dict['subject_id'] = None

        # set to None if operator (nullable) is None
        # and model_fields_set contains the field
        if self.operator is None and "operator" in self.model_fields_set:
            _dict['operator'] = None

        # set to None if instrument (nullable) is None
        # and model_fields_set contains the field
        if self.instrument is None and "instrument" in self.model_fields_set:
            _dict['instrument'] = None

        # set to None if session_type (nullable) is None
        # and model_fields_set contains the field
        if self.session_type is None and "session_type" in self.model_fields_set:
            _dict['session_type'] = None

        # set to None if device_calibrations (nullable) is None
        # and model_fields_set contains the field
        if self.device_calibrations is None and "device_calibrations" in self.model_fields_set:
            _dict['device_calibrations'] = None

        # set to None if mouse_platform_name (nullable) is None
        # and model_fields_set contains the field
        if self.mouse_platform_name is None and "mouse_platform_name" in self.model_fields_set:
            _dict['mouse_platform_name'] = None

        # set to None if active_mouse_platform (nullable) is None
        # and model_fields_set contains the field
        if self.active_mouse_platform is None and "active_mouse_platform" in self.model_fields_set:
            _dict['active_mouse_platform'] = None

        # set to None if session_name (nullable) is None
        # and model_fields_set contains the field
        if self.session_name is None and "session_name" in self.model_fields_set:
            _dict['session_name'] = None

        # set to None if animal_weight_prior (nullable) is None
        # and model_fields_set contains the field
        if self.animal_weight_prior is None and "animal_weight_prior" in self.model_fields_set:
            _dict['animal_weight_prior'] = None

        # set to None if animal_weight_after (nullable) is None
        # and model_fields_set contains the field
        if self.animal_weight_after is None and "animal_weight_after" in self.model_fields_set:
            _dict['animal_weight_after'] = None

        # set to None if animal_weight_unit (nullable) is None
        # and model_fields_set contains the field
        if self.animal_weight_unit is None and "animal_weight_unit" in self.model_fields_set:
            _dict['animal_weight_unit'] = None

        # set to None if reward_consumed (nullable) is None
        # and model_fields_set contains the field
        if self.reward_consumed is None and "reward_consumed" in self.model_fields_set:
            _dict['reward_consumed'] = None

        # set to None if reward_consumed_unit (nullable) is None
        # and model_fields_set contains the field
        if self.reward_consumed_unit is None and "reward_consumed_unit" in self.model_fields_set:
            _dict['reward_consumed_unit'] = None

        # set to None if stimulus_epochs (nullable) is None
        # and model_fields_set contains the field
        if self.stimulus_epochs is None and "stimulus_epochs" in self.model_fields_set:
            _dict['stimulus_epochs'] = None

        # set to None if link_to_stimulus_epoch_code (nullable) is None
        # and model_fields_set contains the field
        if self.link_to_stimulus_epoch_code is None and "link_to_stimulus_epoch_code" in self.model_fields_set:
            _dict['link_to_stimulus_epoch_code'] = None

        # set to None if reward_solution (nullable) is None
        # and model_fields_set contains the field
        if self.reward_solution is None and "reward_solution" in self.model_fields_set:
            _dict['reward_solution'] = None

        # set to None if other_reward_solution (nullable) is None
        # and model_fields_set contains the field
        if self.other_reward_solution is None and "other_reward_solution" in self.model_fields_set:
            _dict['other_reward_solution'] = None

        # set to None if reward_spouts (nullable) is None
        # and model_fields_set contains the field
        if self.reward_spouts is None and "reward_spouts" in self.model_fields_set:
            _dict['reward_spouts'] = None

        # set to None if stream_modalities (nullable) is None
        # and model_fields_set contains the field
        if self.stream_modalities is None and "stream_modalities" in self.model_fields_set:
            _dict['stream_modalities'] = None

        # set to None if stream_modules (nullable) is None
        # and model_fields_set contains the field
        if self.stream_modules is None and "stream_modules" in self.model_fields_set:
            _dict['stream_modules'] = None

        # set to None if daq_names (nullable) is None
        # and model_fields_set contains the field
        if self.daq_names is None and "daq_names" in self.model_fields_set:
            _dict['daq_names'] = None

        # set to None if camera_names (nullable) is None
        # and model_fields_set contains the field
        if self.camera_names is None and "camera_names" in self.model_fields_set:
            _dict['camera_names'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SlimsEcephysData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "experiment_run_created_on": obj.get("experiment_run_created_on"),
            "subject_id": obj.get("subject_id"),
            "operator": obj.get("operator"),
            "instrument": obj.get("instrument"),
            "session_type": obj.get("session_type"),
            "device_calibrations": obj.get("device_calibrations"),
            "mouse_platform_name": obj.get("mouse_platform_name"),
            "active_mouse_platform": obj.get("active_mouse_platform"),
            "session_name": obj.get("session_name"),
            "animal_weight_prior": obj.get("animal_weight_prior"),
            "animal_weight_after": obj.get("animal_weight_after"),
            "animal_weight_unit": obj.get("animal_weight_unit"),
            "reward_consumed": obj.get("reward_consumed"),
            "reward_consumed_unit": obj.get("reward_consumed_unit"),
            "stimulus_epochs": obj.get("stimulus_epochs"),
            "link_to_stimulus_epoch_code": obj.get("link_to_stimulus_epoch_code"),
            "reward_solution": obj.get("reward_solution"),
            "other_reward_solution": obj.get("other_reward_solution"),
            "reward_spouts": [EcephysRewardSpouts.from_dict(_item) for _item in obj["reward_spouts"]] if obj.get("reward_spouts") is not None else None,
            "stream_modalities": obj.get("stream_modalities"),
            "stream_modules": [EcephysStreamModule.from_dict(_item) for _item in obj["stream_modules"]] if obj.get("stream_modules") is not None else None,
            "daq_names": obj.get("daq_names"),
            "camera_names": obj.get("camera_names")
        })
        return _obj


