# coding: utf-8

"""
    aind-slims-service

     ## aind-slims-service  Service to pull data from SLIMS.  

    The version of the OpenAPI document: 0.2.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_slims_service_async_client.models.histology_reagent_data import HistologyReagentData
from typing import Optional, Set
from typing_extensions import Self

class HistologyWashData(BaseModel):
    """
    Expected wash information from SLIMS.
    """ # noqa: E501
    wash_name: Optional[StrictStr] = None
    wash_type: Optional[StrictStr] = None
    start_time: Optional[datetime] = None
    end_time: Optional[datetime] = None
    modified_by: Optional[StrictStr] = None
    reagents: Optional[List[HistologyReagentData]] = None
    mass: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["wash_name", "wash_type", "start_time", "end_time", "modified_by", "reagents", "mass"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HistologyWashData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in reagents (list)
        _items = []
        if self.reagents:
            for _item_reagents in self.reagents:
                if _item_reagents:
                    _items.append(_item_reagents.to_dict())
            _dict['reagents'] = _items
        # set to None if wash_name (nullable) is None
        # and model_fields_set contains the field
        if self.wash_name is None and "wash_name" in self.model_fields_set:
            _dict['wash_name'] = None

        # set to None if wash_type (nullable) is None
        # and model_fields_set contains the field
        if self.wash_type is None and "wash_type" in self.model_fields_set:
            _dict['wash_type'] = None

        # set to None if start_time (nullable) is None
        # and model_fields_set contains the field
        if self.start_time is None and "start_time" in self.model_fields_set:
            _dict['start_time'] = None

        # set to None if end_time (nullable) is None
        # and model_fields_set contains the field
        if self.end_time is None and "end_time" in self.model_fields_set:
            _dict['end_time'] = None

        # set to None if modified_by (nullable) is None
        # and model_fields_set contains the field
        if self.modified_by is None and "modified_by" in self.model_fields_set:
            _dict['modified_by'] = None

        # set to None if mass (nullable) is None
        # and model_fields_set contains the field
        if self.mass is None and "mass" in self.model_fields_set:
            _dict['mass'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HistologyWashData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "wash_name": obj.get("wash_name"),
            "wash_type": obj.get("wash_type"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time"),
            "modified_by": obj.get("modified_by"),
            "reagents": [HistologyReagentData.from_dict(_item) for _item in obj["reagents"]] if obj.get("reagents") is not None else None,
            "mass": obj.get("mass")
        })
        return _obj


