# aind-slims-service-async-client

## aind-slims-service

Service to pull data from SLIMS.



This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.2.3
- Package version: 0.2.3
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import aind_slims_service_async_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import aind_slims_service_async_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import aind_slims_service_async_client
from aind_slims_service_async_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = aind_slims_service_async_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with aind_slims_service_async_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = aind_slims_service_async_client.DefaultApi(api_client)
    input_id = '440_SmartSPIM1_20240327' # str | Instrument ID
    partial_match = False # bool | If true, will search for a partial match that contains the input_id string (optional) (default to False)

    try:
        # Get Aind Instrument
        api_response = await api_instance.get_aind_instrument(input_id, partial_match=partial_match)
        print("The response of DefaultApi->get_aind_instrument:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->get_aind_instrument: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_aind_instrument**](docs/DefaultApi.md#get_aind_instrument) | **GET** /aind_instruments/{input_id} | Get Aind Instrument
*DefaultApi* | [**get_ecephys_sessions**](docs/DefaultApi.md#get_ecephys_sessions) | **GET** /ecephys_sessions | Get Ecephys Sessions
*DefaultApi* | [**get_histology_data**](docs/DefaultApi.md#get_histology_data) | **GET** /histology | Get Histology Data
*DefaultApi* | [**get_smartspim_imaging**](docs/DefaultApi.md#get_smartspim_imaging) | **GET** /smartspim_imaging | Get Smartspim Imaging
*DefaultApi* | [**get_viral_injections**](docs/DefaultApi.md#get_viral_injections) | **GET** /viral_injections | Get Viral Injections
*DefaultApi* | [**get_water_restriction_data**](docs/DefaultApi.md#get_water_restriction_data) | **GET** /water_restriction | Get Water Restriction Data
*HealthcheckApi* | [**get_health**](docs/HealthcheckApi.md#get_health) | **GET** /healthcheck | Perform a Health Check


## Documentation For Models

 - [EcephysRewardSpouts](docs/EcephysRewardSpouts.md)
 - [EcephysStreamModule](docs/EcephysStreamModule.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [HistologyReagentData](docs/HistologyReagentData.md)
 - [HistologyWashData](docs/HistologyWashData.md)
 - [SlimsEcephysData](docs/SlimsEcephysData.md)
 - [SlimsHistologyData](docs/SlimsHistologyData.md)
 - [SlimsSpimData](docs/SlimsSpimData.md)
 - [SlimsViralInjectionData](docs/SlimsViralInjectionData.md)
 - [SlimsViralMaterialData](docs/SlimsViralMaterialData.md)
 - [SlimsWaterRestrictionData](docs/SlimsWaterRestrictionData.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




