"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stack = exports.BaseStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tfe = require("@cdktf/provider-tfe");
const cdktf_1 = require("cdktf");
const MULTI_STACK_BASE_SYMBOL = Symbol(`multi-stack-tfe-base`);
const MULTI_STACK_STACK_SYMBOL = Symbol(`multi-stack-tfe-stack`);
class BaseStack extends cdktf_1.TerraformStack {
    constructor(scope, organizationName, prefix, options = {}) {
        super(scope, "base");
        this.organizationName = organizationName;
        this.prefix = prefix;
        this.options = options;
        Object.defineProperty(this, MULTI_STACK_BASE_SYMBOL, { value: true });
        this.tfeProvider = new tfe.TfeProvider(this, "tfe", {
            hostname: options.hostname,
            token: options.token,
            sslSkipVerify: options.sslSkipVerify,
        });
        new cdktf_1.RemoteBackend(this, this.getRemoteBackendOptions("base"));
        this.organization = new tfe.DataTfeOrganization(this, "organization", {
            name: organizationName,
        });
    }
    static isBaseStack(x) {
        return x !== null && typeof x === "object" && MULTI_STACK_BASE_SYMBOL in x;
    }
    static baseStackOf(construct) {
        const app = cdktf_1.App.of(construct);
        const base = app.node.children.find(BaseStack.isBaseStack);
        if (!base) {
            throw new Error(`No BaseStack for multi-stack app could be identified for the construct at path '${construct.node.path}'. The base stack needs to have the same app as the scope as this construct.`);
        }
        return base;
    }
    getRemoteBackendOptions(stackName) {
        return {
            workspaces: {
                name: this.getWorkspaceName(stackName),
            },
            organization: this.organizationName,
            // optional
            hostname: this.options.hostname,
            token: this.options.token,
        };
    }
    /**
     * If you want to have more control over the workspace name, you can override this method.
     */
    getWorkspaceName(stackName) {
        return `${this.prefix}-${stackName}`;
    }
    bootstrapWorkspace(stackName, stackConfig = {}) {
        const config = {
            ...(this.options.defaultWorkspaceConfig || {}),
            ...stackConfig,
        };
        return new tfe.Workspace(this, `tfe-multi-stack-workspace-${stackName}`, {
            ...config,
            name: this.getWorkspaceName(stackName),
            organization: this.organization.name,
            tagNames: [this.prefix, ...(config.tagNames || [])],
            remoteStateConsumerIds: [...(config.remoteStateConsumerIds || [])],
        });
    }
}
exports.BaseStack = BaseStack;
_a = JSII_RTTI_SYMBOL_1;
BaseStack[_a] = { fqn: "cdktf-multi-stack-tfe.BaseStack", version: "0.0.15" };
class Stack extends cdktf_1.TerraformStack {
    constructor(scope, stackName, config) {
        super(scope, stackName);
        Object.defineProperty(this, MULTI_STACK_STACK_SYMBOL, { value: true });
        const baseStack = BaseStack.baseStackOf(this);
        this.workspace = baseStack.bootstrapWorkspace(stackName, config);
        new cdktf_1.RemoteBackend(this, baseStack.getRemoteBackendOptions(stackName));
    }
    static isMultiStackStack(x) {
        return x !== null && typeof x === "object" && MULTI_STACK_STACK_SYMBOL in x;
    }
    addDependency(dependency) {
        var _c, _d;
        if (!this.dependencies.includes(dependency) &&
            Stack.isMultiStackStack(dependency)) {
            (_c = dependency.workspace.remoteStateConsumerIdsInput) === null || _c === void 0 ? void 0 : _c.push(this.workspace.id);
            const currentDependencies = (_d = dependency.workspace.dependsOn) !== null && _d !== void 0 ? _d : [];
            currentDependencies.push(cdktf_1.insideTfExpression(this.workspace.fqn));
            // This is not working as the result is wrapped in a terraform expression where it's not allowed to
            dependency.workspace.dependsOn = currentDependencies;
        }
        super.addDependency(dependency);
    }
}
exports.Stack = Stack;
_b = JSII_RTTI_SYMBOL_1;
Stack[_b] = { fqn: "cdktf-multi-stack-tfe.Stack", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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