namespace Carna
{

namespace py
{



// ----------------------------------------------------------------------------------
// free
// ----------------------------------------------------------------------------------

template< typename T >
void free( T* ptr )
{
    delete ptr;
}



// ----------------------------------------------------------------------------------
// DEF_FREE
// ----------------------------------------------------------------------------------

#define DEF_FREE( cls ) def( "free", &Carna::py::free< cls > )



// ----------------------------------------------------------------------------------
// float2huv
// ----------------------------------------------------------------------------------

inline short float2huv( float value )
{
    return static_cast< short >( value * ((1 << 12) - 1) + 0.5 ) - 1024;
}



// ----------------------------------------------------------------------------------
// huv2float
// ----------------------------------------------------------------------------------

inline float huv2float( short value )
{
    return (value + 1024) / float((1 << 12) - 1);
}



}  // namespace Carna :: py

}  // namespace Carna

