/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.nio.Config;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SendBuffer
implements Config {
    private static final int HEADER = 0;
    private static final int LONGS = 1;
    private static final int DOUBLES = 2;
    private static final int INTS = 3;
    private static final int FLOATS = 4;
    private static final int SHORTS = 5;
    private static final int CHARS = 6;
    private static final int BYTES = 7;
    private static final int PADDING = 8;
    private static final int NR_OF_BUFFERS = 9;
    private static final int SIZEOF_HEADER = 16;
    private static final int SIZEOF_PADDING = 8;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    static final int BUFFER_CACHE_SIZE = 128;
    static SendBuffer[] cache = new SendBuffer[128];
    static int cacheSize = 0;
    private static Logger logger = LoggerFactory.getLogger(SendBuffer.class);
    private int copies = 0;
    SendBuffer parent = null;
    private static long nextSequenceNr = 0L;
    ShortBuffer header;
    LongBuffer longs;
    DoubleBuffer doubles;
    IntBuffer ints;
    FloatBuffer floats;
    ShortBuffer shorts;
    CharBuffer chars;
    ByteBuffer bytes;
    ByteBuffer[] byteBuffers;
    long sequenceNr;

    static synchronized SendBuffer get() {
        if (cacheSize > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("SendBuffer: got empty buffer from cache");
            }
            cache[--cacheSize].clear();
            return cache[cacheSize];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SendBuffer: got new empty buffer");
        }
        return new SendBuffer();
    }

    static synchronized void recycle(SendBuffer buffer) {
        if (buffer.parent == null) {
            if (buffer.copies != 0) {
                return;
            }
            if (cacheSize >= 128) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SendBuffer: cache full apon recycling buffer, throwing away");
                }
                return;
            }
            SendBuffer.cache[SendBuffer.cacheSize] = buffer;
            ++cacheSize;
            if (logger.isDebugEnabled()) {
                logger.debug("SendBuffer: recycled buffer");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("SendBuffer: recycling child buffer");
            }
            --buffer.parent.copies;
            if (buffer.parent.copies == 0) {
                if (cacheSize >= 128) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("SendBuffer: cache full apon recycling parent of child buffer, throwing away");
                    }
                    return;
                }
                SendBuffer.cache[SendBuffer.cacheSize] = buffer.parent;
                ++cacheSize;
                if (logger.isDebugEnabled()) {
                    logger.debug("SendBuffer: recycled parent buffer");
                }
            }
        }
    }

    static synchronized SendBuffer[] replicate(SendBuffer original, int copies) {
        SendBuffer[] result = new SendBuffer[copies];
        for (int i = 0; i < copies; ++i) {
            result[i] = new SendBuffer(original);
        }
        original.copies += copies;
        return result;
    }

    SendBuffer() {
        ByteOrder order = ByteOrder.nativeOrder();
        this.byteBuffers = new ByteBuffer[9];
        this.byteBuffers[0] = ByteBuffer.allocateDirect(16).order(order);
        this.byteBuffers[8] = ByteBuffer.allocateDirect(8).order(order);
        if (order == ByteOrder.BIG_ENDIAN) {
            this.byteBuffers[0].put(0, (byte)1);
        } else {
            this.byteBuffers[0].put(0, (byte)0);
        }
        for (int i = 1; i < 8; ++i) {
            this.byteBuffers[i] = ByteBuffer.allocateDirect(6144).order(order);
        }
        this.header = this.byteBuffers[0].asShortBuffer();
        this.longs = this.byteBuffers[1].asLongBuffer();
        this.doubles = this.byteBuffers[2].asDoubleBuffer();
        this.ints = this.byteBuffers[3].asIntBuffer();
        this.floats = this.byteBuffers[4].asFloatBuffer();
        this.shorts = this.byteBuffers[5].asShortBuffer();
        this.chars = this.byteBuffers[6].asCharBuffer();
        this.bytes = this.byteBuffers[7].duplicate();
        this.clear();
    }

    SendBuffer(SendBuffer parent) {
        this.parent = parent;
        this.byteBuffers = new ByteBuffer[9];
        for (int i = 0; i < 9; ++i) {
            this.byteBuffers[i] = parent.byteBuffers[i].duplicate();
        }
    }

    void clear() {
        this.longs.clear();
        this.doubles.clear();
        this.ints.clear();
        this.floats.clear();
        this.shorts.clear();
        this.chars.clear();
        this.bytes.clear();
        this.parent = null;
        this.copies = 0;
        this.sequenceNr = nextSequenceNr++;
    }

    void flip() {
        short[] headerArray = new short[8];
        headerArray[1] = (short)(this.longs.position() * 8);
        headerArray[2] = (short)(this.doubles.position() * 8);
        headerArray[3] = (short)(this.ints.position() * 4);
        headerArray[4] = (short)(this.floats.position() * 4);
        headerArray[5] = (short)(this.shorts.position() * 2);
        headerArray[6] = (short)(this.chars.position() * 2);
        headerArray[7] = (short)(this.bytes.position() * 1);
        this.header.clear();
        this.header.put(headerArray);
        this.byteBuffers[0].position(0);
        this.byteBuffers[0].limit(16);
        this.byteBuffers[1].position(0);
        this.byteBuffers[1].limit(headerArray[1]);
        this.byteBuffers[2].position(0);
        this.byteBuffers[2].limit(headerArray[2]);
        this.byteBuffers[3].position(0);
        this.byteBuffers[3].limit(headerArray[3]);
        this.byteBuffers[4].position(0);
        this.byteBuffers[4].limit(headerArray[4]);
        this.byteBuffers[5].position(0);
        this.byteBuffers[5].limit(headerArray[5]);
        this.byteBuffers[6].position(0);
        this.byteBuffers[6].limit(headerArray[6]);
        this.byteBuffers[7].position(0);
        this.byteBuffers[7].limit(headerArray[7]);
        int totalLength = 16 + headerArray[1] + headerArray[2] + headerArray[3] + headerArray[4] + headerArray[5] + headerArray[6] + headerArray[7];
        int paddingLength = 8 - totalLength % 8;
        this.byteBuffers[8].position(0).limit(paddingLength);
        this.byteBuffers[0].put(1, (byte)paddingLength);
        if (logger.isDebugEnabled()) {
            logger.debug("flipping buffer, sending: l[" + this.longs.position() + "] d[" + this.doubles.position() + "] i[" + this.ints.position() + "] f[" + this.floats.position() + "] s[" + this.shorts.position() + "] c[" + this.chars.position() + "] b[" + this.bytes.position() + "] total size: " + this.remaining() + " padding size: " + paddingLength);
        }
    }

    void mark() {
        for (int i = 0; i < this.byteBuffers.length; ++i) {
            this.byteBuffers[i].mark();
        }
    }

    void reset() {
        for (int i = 0; i < this.byteBuffers.length; ++i) {
            this.byteBuffers[i].reset();
        }
    }

    long remaining() {
        long result = 0L;
        for (int i = 0; i < this.byteBuffers.length; ++i) {
            result += (long)this.byteBuffers[i].remaining();
        }
        return result;
    }

    boolean isEmpty() {
        return this.longs.position() == 0 && this.doubles.position() == 0 && this.ints.position() == 0 && this.floats.position() == 0 && this.shorts.position() == 0 && this.chars.position() == 0 && this.bytes.position() == 0;
    }

    boolean hasRemaining() {
        return this.byteBuffers[8].hasRemaining();
    }
}

