/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.io.DataInputStream;
import ibis.ipl.ConnectionClosedException;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.ReadMessage;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.ReceivePortConnectionInfo;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.nio.NioDissipator;
import ibis.ipl.impl.nio.Protocol;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NioReceivePort
extends ReceivePort
implements Runnable,
Protocol {
    private static Logger logger = LoggerFactory.getLogger(NioReceivePort.class);
    private boolean reader_busy = false;

    NioReceivePort(Ibis ibis, PortType type, String name, MessageUpcall upcall, ReceivePortConnectUpcall connUpcall, Properties properties) throws IOException {
        super(ibis, type, name, upcall, connUpcall, properties);
        if (upcall != null) {
            ThreadPool.createNew((Runnable)this, (String)"NioReceivePort with upcall");
        }
    }

    void addConnection(SendPortIdentifier id, NioDissipator dissipator) throws IOException {
        ConnectionInfo info = new ConnectionInfo(id, this, dissipator);
        this.addInfo(id, info);
    }

    byte connectionRequested(SendPortIdentifier spi, PortType capabilities, Channel channel) {
        byte r;
        if (logger.isDebugEnabled()) {
            logger.debug("handling connection request");
        }
        if ((r = this.connectionAllowed(spi, capabilities)) != 0) {
            return r;
        }
        try {
            this.newConnection(spi, channel);
        }
        catch (IOException e) {
            this.lostConnection(spi, e);
            logger.error("newConnection() failed");
            return 1;
        }
        if (logger.isInfoEnabled()) {
            logger.info("new incoming connection from " + spi + " to " + this.ident);
        }
        return r;
    }

    private boolean waitForNotify(long deadline) {
        if (deadline == 0L) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return true;
        }
        if (deadline == -1L) {
            return false;
        }
        long time = System.currentTimeMillis();
        if (time >= deadline) {
            return false;
        }
        try {
            this.wait(deadline - time);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadMessage getMessage(long timeout) throws IOException {
        long deadline = timeout;
        if (deadline > 0L) {
            deadline += System.currentTimeMillis();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("trying to fetch message");
        }
        NioReceivePort nioReceivePort = this;
        synchronized (nioReceivePort) {
            while (this.reader_busy && !this.closed) {
                if (this.waitForNotify(deadline)) continue;
                logger.error("timeout while waiting on previous message");
                throw new ReceiveTimedOutException("previous message not finished yet");
            }
            while (this.connections.size() == 0 && !this.closed) {
                if (this.waitForNotify(deadline)) continue;
                logger.error("timeout while waiting for connection");
                throw new ReceiveTimedOutException("no connection yet");
            }
            while (this.message != null && !this.closed) {
                if (this.waitForNotify(deadline)) continue;
                logger.error("timeout while waiting on previous message");
                throw new ReceiveTimedOutException("previous message not finished yet");
            }
            if (this.closed) {
                throw new IOException("receive() on closed port");
            }
            this.reader_busy = true;
        }
        try {
            NioDissipator dissipator = this.getReadyDissipator(deadline);
            ConnectionInfo info = dissipator.info;
            info.message.setFinished(false);
            if (this.numbered) {
                try {
                    info.message.setSequenceNumber(info.message.readLong());
                }
                catch (IOException e) {
                    this.errorOnRead(dissipator, e);
                    this.reader_busy = false;
                    ReadMessage readMessage = this.getMessage(deadline);
                    NioReceivePort nioReceivePort2 = this;
                    synchronized (nioReceivePort2) {
                        this.reader_busy = false;
                        this.notifyAll();
                    }
                    return readMessage;
                }
            }
            this.messageArrived(info.message);
            if (logger.isDebugEnabled()) {
                logger.debug("new message received");
            }
            ReadMessage readMessage = this.message;
            return readMessage;
        }
        catch (ReceiveTimedOutException e) {
            logger.debug("timeout while waiting on dissipator with message");
            throw e;
        }
        catch (ConnectionClosedException e) {
            logger.debug("receiveport closed while waiting on message");
            throw e;
        }
        finally {
            NioReceivePort nioReceivePort3 = this;
            synchronized (nioReceivePort3) {
                this.reader_busy = false;
                this.notifyAll();
            }
        }
    }

    protected ReadMessage doPoll() throws IOException {
        try {
            return this.getMessage(-1L);
        }
        catch (ReceiveTimedOutException receiveTimedOutException) {
            return null;
        }
    }

    public void closePort(long timeout) {
        this.closing();
        if (this.upcall != null) {
            super.closePort(timeout);
        } else {
            try {
                this.getMessage(timeout);
            }
            catch (ConnectionClosedException e) {
            }
            catch (IOException e2) {
                super.closePort(1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(this + " upcall thread");
        while (true) {
            NioDissipator dissipator;
            try {
                dissipator = this.getReadyDissipator(0L);
            }
            catch (ConnectionClosedException e2) {
                NioReceivePort nioReceivePort = this;
                synchronized (nioReceivePort) {
                    this.notifyAll();
                    return;
                }
            }
            catch (IOException e) {
                continue;
            }
            ConnectionInfo info = dissipator.info;
            info.message.setFinished(false);
            if (this.numbered) {
                try {
                    info.message.setSequenceNumber(info.message.readLong());
                }
                catch (IOException e) {
                    this.errorOnRead(dissipator, e);
                    continue;
                }
            }
            ReadMessage m = info.message;
            this.messageArrived(info.message);
            if (m.finishCalledInUpcall()) break;
        }
    }

    abstract void newConnection(SendPortIdentifier var1, Channel var2) throws IOException;

    abstract void errorOnRead(NioDissipator var1, Exception var2);

    abstract NioDissipator getReadyDissipator(long var1) throws IOException;

    abstract void closing();

    static class ConnectionInfo
    extends ReceivePortConnectionInfo {
        ConnectionInfo(SendPortIdentifier origin, NioReceivePort port, NioDissipator dissipator) throws IOException {
            super(origin, (ReceivePort)port, (DataInputStream)dissipator);
            dissipator.info = this;
        }

        protected void upcallCalledFinish() {
            super.upcallCalledFinish();
            ThreadPool.createNew((Runnable)((NioReceivePort)this.port), (String)"NioReceivePort with upcall");
        }
    }
}

