/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public final class ChannelAccumulator
extends DataOutputStream {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int BUFFER_SIZE = 1024;
    long count = 0L;
    ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    WritableByteChannel channel;

    public ChannelAccumulator(WritableByteChannel channel) {
        this.channel = channel;
    }

    public int bufferSize() {
        return 1024;
    }

    public void flush() throws IOException {
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            this.count += (long)this.channel.write(this.buffer);
        }
        this.buffer.clear();
    }

    public void close() throws IOException {
        this.flush();
    }

    public void reallyClose() throws IOException {
        this.flush();
        this.channel.close();
    }

    public long bytesWritten() {
        return this.count;
    }

    public void resetBytesWritten() {
        this.count = 0L;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public void writeByte(byte value) throws IOException {
        try {
            this.buffer.put(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.put(value);
        }
    }

    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    public void writeChar(char value) throws IOException {
        try {
            this.buffer.putChar(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putChar(value);
        }
    }

    public void writeShort(short value) throws IOException {
        try {
            this.buffer.putShort(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putShort(value);
        }
    }

    public void writeInt(int value) throws IOException {
        try {
            this.buffer.putInt(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putInt(value);
        }
    }

    public void writeLong(long value) throws IOException {
        try {
            this.buffer.putLong(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putLong(value);
        }
    }

    public void writeFloat(float value) throws IOException {
        try {
            this.buffer.putFloat(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putFloat(value);
        }
    }

    public void writeDouble(double value) throws IOException {
        try {
            this.buffer.putDouble(value);
        }
        catch (BufferOverflowException e) {
            this.flush();
            this.buffer.putDouble(value);
        }
    }

    public void writeArray(boolean[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeBoolean(source[i]);
        }
    }

    public void writeArray(byte[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeByte(source[i]);
        }
    }

    public void writeArray(char[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeChar(source[i]);
        }
    }

    public void writeArray(short[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeShort(source[i]);
        }
    }

    public void writeArray(int[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeInt(source[i]);
        }
    }

    public void writeArray(long[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeLong(source[i]);
        }
    }

    public void writeArray(float[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeFloat(source[i]);
        }
    }

    public void writeArray(double[] source, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.writeDouble(source[i]);
        }
    }

    public void writeByteBuffer(ByteBuffer value) throws IOException {
        for (int i = value.position(); i < value.limit(); ++i) {
            this.writeByte(value.get());
        }
    }
}

