/*
 * Decompiled with CFR 0.152.
 */
package ibis.io.rewriter;

import ibis.compile.ASMRepository;
import ibis.compile.IbiscComponent;
import ibis.io.rewriter.ASMCodeGenerator;
import ibis.io.rewriter.ASMRewriterConstants;
import ibis.io.rewriter.ASMSerializationInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class ASMIOGenerator
extends IbiscComponent
implements ASMRewriterConstants,
Opcodes {
    boolean local = true;
    boolean file = false;
    boolean force_generated_calls = false;
    boolean silent = true;
    boolean use_jme = false;
    Vector<ClassNode> classes_to_rewrite = new Vector();
    Vector<ClassNode> target_classes = new Vector();
    Vector<ClassNode> classes_to_save = new Vector();
    HashMap<String, ClassNode> arguments = new HashMap();
    boolean fromIbisc = false;

    public ASMIOGenerator() {
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isFromIbisc() {
        return this.fromIbisc;
    }

    protected boolean forceGeneratedCalls() {
        return this.force_generated_calls;
    }

    protected boolean useJME() {
        return this.use_jme;
    }

    private boolean removeTarget(ClassNode clazz) {
        return this.target_classes.remove(clazz);
    }

    private void addTarget(ClassNode clazz) {
        this.target_classes.add(clazz);
    }

    private boolean removeSave(ClassNode clazz) {
        return this.classes_to_save.remove(clazz);
    }

    private void addSave(ClassNode clazz) {
        this.classes_to_save.add(clazz);
    }

    protected void replace(ClassNode clazz, ClassNode newclazz) {
        if (this.removeTarget(clazz)) {
            ASMRepository.removeClass((String)clazz.name);
            ASMRepository.addClass((ClassNode)newclazz);
            this.addTarget(newclazz);
        }
        if (this.removeSave(clazz)) {
            this.addSave(newclazz);
        }
    }

    protected void markRewritten(ClassNode clazz, ClassNode instgen) {
        if (this.isFromIbisc()) {
            this.setModified(this.wrapper.getInfo((Object)clazz));
            if (instgen != null) {
                this.addEntry(this.wrapper.getInfo((Object)instgen), clazz.name.replaceAll("/", "."));
            }
        }
        this.addSave(clazz);
        if (instgen != null) {
            this.addSave(instgen);
        }
    }

    public ASMIOGenerator(boolean verbose, boolean local, boolean file, boolean force_generated_calls, boolean silent, boolean use_jme) {
        this();
        this.verbose = verbose;
        this.local = local;
        this.file = file;
        this.force_generated_calls = force_generated_calls;
        this.silent = silent;
        this.use_jme = use_jme;
    }

    public boolean processArgs(ArrayList<String> args) {
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg.equals("-iogen-force")) {
                this.force_generated_calls = true;
                args.remove(i);
                --i;
            }
            if (!arg.equals("-jme")) continue;
            this.use_jme = true;
            args.remove(i);
            --i;
        }
        return true;
    }

    public String getUsageString() {
        return "[-iogen-force] [-jme]";
    }

    public void process(Iterator<?> classes) {
        ClassNode clazz;
        int i;
        this.fromIbisc = true;
        this.arguments = new HashMap();
        Iterator<?> i2 = classes;
        while (i2.hasNext()) {
            ClassNode cl = (ClassNode)i2.next();
            this.arguments.put(cl.name, cl);
        }
        for (ClassNode cl : this.arguments.values()) {
            if (this.useJME() || !ASMSerializationInfo.isSerializable(cl) || ASMSerializationInfo.isIbisSerializable(cl)) continue;
            this.addClass(cl);
        }
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            this.addReferencesToRewrite(clazz);
        }
        this.do_sort_classes(this.classes_to_rewrite);
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            if (this.useJME()) continue;
            new ASMCodeGenerator(this, clazz).generateEmptyMethods();
        }
        if (this.verbose) {
            System.out.println("Ibisc: IOGenerator rewriting classes");
        }
        this.do_sort_classes(this.target_classes);
        for (i = 0; i < this.target_classes.size(); ++i) {
            clazz = this.target_classes.get(i);
            if (this.verbose) {
                System.out.println("Target Class: " + clazz.name);
            }
            if ((clazz.access & 0x200) == 512) continue;
            if (!this.silent) {
                System.out.println("  Rewrite class : " + clazz.name);
            }
            if (this.useJME()) continue;
            new ASMCodeGenerator(this, clazz).generateCode();
        }
    }

    public String rewriterImpl() {
        return "ASM";
    }

    private void addTargetClass(ClassNode clazz) {
        String nm;
        if (!this.useJME() && !this.target_classes.contains(clazz) && !ASMSerializationInfo.isIbisSerializable(clazz) && this.arguments.containsKey(nm = clazz.name)) {
            this.target_classes.add(clazz);
            if (this.verbose) {
                System.out.println("Adding target class : " + nm);
            }
        }
    }

    private void addRewriteClass(Type t, ClassNode clazz) {
        String name;
        ClassNode c;
        if (t.getSort() == 9) {
            this.addRewriteClass(t.getElementType(), clazz);
        } else if (t.getSort() == 10 && (c = ASMCodeGenerator.lookupClass(name = t.getInternalName())) != null && (!this.local || ASMCodeGenerator.getPackageName(clazz.name).equals(ASMCodeGenerator.getPackageName(c.name)))) {
            this.addClass(c);
        }
    }

    private void addRewriteClass(ClassNode clazz) {
        if (!(this.useJME() || this.classes_to_rewrite.contains(clazz) || ASMSerializationInfo.isIbisSerializable(clazz))) {
            this.classes_to_rewrite.add(clazz);
            if (this.verbose) {
                System.out.println("Adding rewrite class : " + clazz.name);
            }
        }
    }

    private void addClass(ClassNode clazz) {
        boolean serializable = false;
        if (clazz.name.equals("java/lang/Class")) {
            return;
        }
        if (clazz.name.equals("java/lang/String")) {
            return;
        }
        try {
            if (ASMRepository.instanceOf((ClassNode)clazz, (String)"java/lang/Enum")) {
                return;
            }
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (!this.classes_to_rewrite.contains(clazz)) {
            ClassNode[] super_classes;
            try {
                super_classes = ASMRepository.getSuperClasses((ClassNode)clazz);
            }
            catch (ClassNotFoundException e) {
                super_classes = null;
            }
            if (super_classes != null) {
                for (int i = 0; i < super_classes.length; ++i) {
                    if (this.useJME() || !ASMSerializationInfo.isSerializable(super_classes[i])) continue;
                    serializable = true;
                    if (!ASMSerializationInfo.isIbisSerializable(super_classes[i])) {
                        if (this.local && !ASMCodeGenerator.getPackageName(clazz.name).equals(ASMCodeGenerator.getPackageName(super_classes[i].name))) continue;
                        this.addRewriteClass(super_classes[i]);
                        continue;
                    }
                    if (!this.verbose) continue;
                    System.out.println(clazz.name + " already implements " + "ibis/io/Serializable");
                }
            }
            if (!this.useJME()) {
                serializable |= ASMSerializationInfo.isSerializable(clazz);
            }
        } else {
            serializable = true;
        }
        if (serializable) {
            this.addRewriteClass(clazz);
            this.addTargetClass(clazz);
        }
    }

    void addReferencesToRewrite(ClassNode clazz) {
        List fields = clazz.fields;
        for (FieldNode field : fields) {
            if ((field.access & 0x88) != 0) continue;
            Type field_type = Type.getType((String)field.desc);
            if (field_type.getSort() == 9) {
                field_type = field_type.getElementType();
            }
            if (field_type.getSort() != 10 || field_type.getInternalName().equals("java/lang/String") || !ASMSerializationInfo.isFinal(field_type)) continue;
            this.addRewriteClass(field_type, clazz);
        }
    }

    private void do_sort_classes(Vector<ClassNode> t) {
        int l = t.size();
        for (int i = 0; i < l; ++i) {
            ClassNode clazz = t.get(i);
            int sav_index = i;
            for (int j = i + 1; j < l; ++j) {
                ClassNode clazz2 = t.get(j);
                if (!ASMSerializationInfo.predecessor(clazz2.name, clazz)) continue;
                clazz = clazz2;
                sav_index = j;
            }
            if (sav_index == i) continue;
            t.setElementAt(t.get(i), sav_index);
            t.setElementAt(clazz, i);
        }
    }

    private void scanClass(Vector<String> classnames) {
        ClassNode clazz;
        int i;
        int lngth = classnames.size();
        Object[] names = classnames.toArray();
        Arrays.sort(names);
        for (i = lngth - 1; i >= 0; --i) {
            String nm = (String)names[i];
            this.arguments.put(nm, null);
        }
        for (i = lngth - 1; i >= 0; --i) {
            if (this.verbose) {
                System.out.println("  Loading class : " + (String)names[i]);
            }
            String className = (String)names[i];
            ClassNode clazz2 = null;
            if (!this.file) {
                clazz2 = ASMCodeGenerator.lookupClass(className);
                if (clazz2 == null) {
                    System.err.println("Warning: could not load class " + className + ". Please check your classpath.");
                }
            } else {
                System.err.println("class name = " + className);
                try {
                    ASMRepository.parseClassFile((String)(className.replace('.', File.separatorChar) + ".class"));
                }
                catch (Exception e) {
                    System.err.println("got exception while loading class: " + e);
                    System.exit(1);
                }
            }
            if (clazz2 == null) continue;
            if (ASMSerializationInfo.isSerializable(clazz2)) {
                if (!ASMSerializationInfo.isIbisSerializable(clazz2)) {
                    this.addClass(clazz2);
                    continue;
                }
                if (!this.verbose) continue;
                System.out.println(clazz2.name + " already implements " + "ibis/io/Serializable");
                continue;
            }
            if (this.verbose) {
                System.out.println(clazz2.name + " is not serializable");
            }
            ASMRepository.removeClass((String)clazz2.name);
        }
        if (this.verbose) {
            System.out.println("Preparing classes");
        }
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            this.addReferencesToRewrite(clazz);
        }
        ASMRepository.clearCache();
        this.do_sort_classes(this.classes_to_rewrite);
        for (i = 0; i < this.classes_to_rewrite.size(); ++i) {
            clazz = this.classes_to_rewrite.get(i);
            if (this.useJME()) continue;
            new ASMCodeGenerator(this, clazz).generateEmptyMethods();
        }
        if (this.verbose) {
            System.out.println("Rewriting classes");
        }
        this.do_sort_classes(this.target_classes);
        for (i = 0; i < this.target_classes.size(); ++i) {
            clazz = this.target_classes.get(i);
            if ((clazz.access & 0x200) == 512) continue;
            if (!this.silent) {
                System.out.println("  Rewrite class : " + clazz.name);
            }
            if (this.useJME()) continue;
            new ASMCodeGenerator(this, clazz).generateCode();
        }
        if (this.verbose) {
            System.out.println("Saving classes");
        }
        for (i = 0; i < this.classes_to_save.size(); ++i) {
            clazz = this.classes_to_save.get(i);
            String cl = clazz.name;
            String classfile = "";
            try {
                if (this.local) {
                    int index = cl.lastIndexOf(47);
                    classfile = cl.substring(index + 1) + ".class";
                } else {
                    classfile = cl.replace('/', File.separatorChar) + ".class";
                }
                if (this.verbose) {
                    System.out.println("  Saving class : " + classfile);
                }
                ASMRepository.dump((String)classfile, (ClassNode)clazz);
                continue;
            }
            catch (IOException e) {
                System.err.println("got exception while writing " + classfile + ": " + e);
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    private static void usage() {
        System.out.println("Usage : java IOGenerator [-dir|-local] [-package <package>] [-v] [-jme]<fully qualified classname list | classfiles>");
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean local = true;
        boolean file = false;
        boolean force_generated_calls = false;
        boolean silent = false;
        boolean use_jme = false;
        Vector<String> files = new Vector<String>();
        String pack = null;
        if (args.length == 0) {
            ASMIOGenerator.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (!args[i].startsWith("-")) {
                files.add(args[i]);
                continue;
            }
            if (args[i].equals("-dir")) {
                local = false;
                continue;
            }
            if (args[i].equals("-local")) {
                local = true;
                continue;
            }
            if (args[i].equals("-file")) {
                file = true;
                continue;
            }
            if (args[i].equals("-silent")) {
                silent = true;
                continue;
            }
            if (args[i].equals("-force")) {
                force_generated_calls = true;
                continue;
            }
            if (args[i].equals("-jme")) {
                use_jme = true;
                continue;
            }
            if (args[i].equals("-package")) {
                pack = args[i + 1];
                ++i;
                continue;
            }
            ASMIOGenerator.usage();
        }
        Vector<String> newArgs = new Vector<String>();
        for (int i = 0; i < files.size(); ++i) {
            int index;
            String name = (String)files.elementAt(i);
            int colon = name.indexOf(58);
            if (colon != -1) {
                name = name.substring(colon + 1);
            }
            if ((index = name.lastIndexOf(".class")) != -1) {
                name = name.substring(0, index);
                name = name.replace(File.separatorChar, '.');
                if (pack == null) {
                    newArgs.add(name);
                    continue;
                }
                newArgs.add(pack + "." + name);
                continue;
            }
            File f = new File(name);
            name = name.replace(File.separatorChar, '.');
            if (f.isDirectory()) {
                ASMIOGenerator.processDirectory(f, newArgs, name);
                continue;
            }
            if (pack == null) {
                newArgs.add(name);
                continue;
            }
            newArgs.add(pack + "." + name);
        }
        new ASMIOGenerator(verbose, local, file, force_generated_calls, silent, use_jme).scanClass(newArgs);
    }

    private static void processDirectory(File f, Vector<String> args, String name) {
        File[] list = f.listFiles();
        String prefix = "";
        if (!name.equals(".")) {
            prefix = name + ".";
        }
        for (int i = 0; i < list.length; ++i) {
            String fname = list[i].getName();
            if (list[i].isDirectory()) {
                ASMIOGenerator.processDirectory(list[i], args, prefix + fname);
                continue;
            }
            int index = fname.lastIndexOf(".class");
            if (index == -1) continue;
            args.add(prefix + fname.substring(0, index));
        }
    }
}

