/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataInputStream;
import ibis.io.DummyInputStream;
import ibis.io.SerializationError;
import ibis.io.SerializationInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;

public final class SunSerializationInputStream
extends ObjectInputStream
implements SerializationInput {
    private InputStream in;

    public SunSerializationInputStream(InputStream s) throws IOException {
        super(new DummyInputStream(s));
        this.in = s;
    }

    public SunSerializationInputStream(DataInputStream s) throws IOException {
        super(new DummyInputStream(s));
        this.in = s;
    }

    @Override
    public String serializationImplName() {
        return "sun";
    }

    @Override
    public boolean reInitOnNewConnection() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public void statistics() {
    }

    @Override
    public void readArray(boolean[] ref, int off, int len) throws IOException {
        try {
            boolean[] temp = (boolean[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'boolean[]' not found", f);
        }
    }

    @Override
    public void readArray(byte[] ref, int off, int len) throws IOException {
        try {
            byte[] temp = (byte[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'byte[]' not found", f);
        }
    }

    @Override
    public void readByteBuffer(ByteBuffer b) throws IOException {
        byte[] temp;
        int len = b.limit() - b.position();
        try {
            temp = (byte[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'byte[]' not found", f);
        }
        b.put(temp);
    }

    @Override
    public void readArray(char[] ref, int off, int len) throws IOException {
        try {
            char[] temp = (char[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'char[]' not found", f);
        }
    }

    @Override
    public void readArray(short[] ref, int off, int len) throws IOException {
        try {
            short[] temp = (short[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'short[]' not found", f);
        }
    }

    @Override
    public void readArray(int[] ref, int off, int len) throws IOException {
        try {
            int[] temp = (int[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'int[]' not found", f);
        }
    }

    @Override
    public void readArray(long[] ref, int off, int len) throws IOException {
        try {
            long[] temp = (long[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'long[]' not found", f);
        }
    }

    @Override
    public void readArray(float[] ref, int off, int len) throws IOException {
        try {
            float[] temp = (float[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'float[]' not found", f);
        }
    }

    @Override
    public void readArray(double[] ref, int off, int len) throws IOException {
        try {
            double[] temp = (double[])this.readObject();
            if (temp.length != len) {
                throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
            }
            System.arraycopy(temp, 0, ref, off, len);
        }
        catch (ClassNotFoundException f) {
            throw new SerializationError("class 'double[]' not found", f);
        }
    }

    @Override
    public void readArray(Object[] ref, int off, int len) throws IOException, ClassNotFoundException {
        Object[] temp = (Object[])this.readObject();
        if (temp.length != len) {
            throw new ArrayIndexOutOfBoundsException("Received sub array has wrong len");
        }
        System.arraycopy(temp, 0, ref, off, len);
    }

    @Override
    public void readArray(boolean[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(byte[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(short[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(char[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(int[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(long[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(float[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(double[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(Object[] ref) throws IOException, ClassNotFoundException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public String readString() throws IOException {
        try {
            return (String)this.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new SerializationError("class 'String' not found", e);
        }
    }

    @Override
    public void realClose() throws IOException {
        this.close();
        this.in.close();
    }
}

