/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.IOProperties;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JavaDependantStuff {
    private static ClassLoader customClassLoader;
    private static HashMap<String, Class<?>> primitiveTypes;
    static final Logger logger;
    static final boolean DEBUG;
    Class<?> clazz;
    ObjectStreamClass objectStreamClass;

    JavaDependantStuff(Class<?> clazz) {
        this.clazz = clazz;
        this.objectStreamClass = ObjectStreamClass.lookup(clazz);
    }

    static Class<?> getClassFromName(String typeName) throws ClassNotFoundException {
        Class<?> cl = primitiveTypes.get(typeName);
        if (cl != null) {
            return cl;
        }
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            try {
                if (DEBUG && logger.isDebugEnabled()) {
                    logger.debug("Could not load class " + typeName + " using Class.forName(), trying " + "Thread.currentThread()." + "getContextClassLoader().loadClass()");
                    logger.debug("Default class loader is " + JavaDependantStuff.class.getClassLoader());
                    logger.debug("now trying " + Thread.currentThread().getContextClassLoader());
                }
                return Thread.currentThread().getContextClassLoader().loadClass(typeName);
            }
            catch (ClassNotFoundException e2) {
                if (typeName.length() > 0 && typeName.charAt(0) == '[') {
                    int dim;
                    char[] s = typeName.toCharArray();
                    for (dim = 0; dim < s.length && s[dim] == '['; ++dim) {
                    }
                    int begin = dim;
                    int end = s.length;
                    if (dim < s.length && s[dim] == 'L') {
                        ++begin;
                    }
                    if (s[end - 1] == ';') {
                        --end;
                    }
                    typeName = typeName.substring(begin, end);
                    int[] dims = new int[dim];
                    for (int i = 0; i < dim; ++i) {
                        dims[i] = 0;
                    }
                    return Array.newInstance(JavaDependantStuff.getClassFromName(typeName), dims).getClass();
                }
                return JavaDependantStuff.loadClassFromCustomCL(typeName);
            }
        }
    }

    private static Class<?> loadClassFromCustomCL(String className) throws ClassNotFoundException {
        if (DEBUG && logger.isDebugEnabled()) {
            System.out.println("loadClassTest " + className);
        }
        if (customClassLoader == null) {
            throw new ClassNotFoundException(className);
        }
        if (DEBUG && logger.isDebugEnabled()) {
            System.out.println("******* Calling custom classloader");
        }
        return customClassLoader.loadClass(className);
    }

    abstract void setFieldDouble(Object var1, String var2, double var3) throws IOException;

    abstract void setFieldLong(Object var1, String var2, long var3) throws IOException;

    abstract void setFieldFloat(Object var1, String var2, float var3) throws IOException;

    abstract void setFieldInt(Object var1, String var2, int var3) throws IOException;

    abstract void setFieldShort(Object var1, String var2, short var3) throws IOException;

    abstract void setFieldChar(Object var1, String var2, char var3) throws IOException;

    abstract void setFieldByte(Object var1, String var2, byte var3) throws IOException;

    abstract void setFieldBoolean(Object var1, String var2, boolean var3) throws IOException;

    abstract void setFieldString(Object var1, String var2, String var3) throws IOException;

    abstract void setFieldClass(Object var1, String var2, Class<?> var3) throws IOException;

    abstract void setFieldObject(Object var1, String var2, Object var3, String var4) throws IOException;

    abstract Object newInstance();

    static {
        primitiveTypes = new HashMap();
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("void", Void.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        logger = LoggerFactory.getLogger(JavaDependantStuff.class);
        DEBUG = IOProperties.DEBUG;
        String clName = System.getProperty("ibis.io.serialization.classloader");
        if (clName != null) {
            try {
                Class<?> classDefinition = Class.forName(clName);
                customClassLoader = (ClassLoader)classDefinition.newInstance();
            }
            catch (Exception e) {
                logger.warn("Warning: could not find or load custom classloader " + clName, (Throwable)e);
            }
        }
    }
}

