/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.spdy.CompressionFactory;

public class StandardCompressionFactory
implements CompressionFactory {
    @Override
    public CompressionFactory.Compressor newCompressor() {
        return new StandardCompressor();
    }

    @Override
    public CompressionFactory.Decompressor newDecompressor() {
        return new StandardDecompressor();
    }

    public static class StandardDecompressor
    implements CompressionFactory.Decompressor {
        private final Inflater inflater = new Inflater();

        @Override
        public void setDictionary(byte[] dictionary) {
            this.inflater.setDictionary(dictionary);
        }

        @Override
        public void setInput(byte[] input) {
            this.inflater.setInput(input);
        }

        @Override
        public int decompress(byte[] output) throws ZipException {
            try {
                return this.inflater.inflate(output);
            }
            catch (DataFormatException x) {
                throw (ZipException)new ZipException().initCause(x);
            }
        }
    }

    public static class StandardCompressor
    implements CompressionFactory.Compressor {
        private final Deflater deflater = new Deflater();

        @Override
        public void setInput(byte[] input) {
            this.deflater.setInput(input);
        }

        @Override
        public void setDictionary(byte[] dictionary) {
            this.deflater.setDictionary(dictionary);
        }

        @Override
        public int compress(byte[] output) {
            return this.deflater.deflate(output, 0, output.length, 2);
        }
    }
}

