/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.randomsteal;

import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class Server {
    public static final byte OPCODE_START = 42;
    public static final byte OPCODE_SYNC = 43;
    public static final byte OPCODE_DONE = 44;
    private final int numberOfClients;
    private final int count;
    private final int repeat;
    private final VirtualSocketFactory sf;
    private final VirtualServerSocket ss;
    private final LinkedList<Client> clients = new LinkedList();

    public Server(int numberOfClients, int count, int repeat) throws InitializationException, IOException {
        this.numberOfClients = numberOfClients;
        this.count = count;
        this.repeat = repeat;
        this.sf = VirtualSocketFactory.createSocketFactory();
        this.ss = this.sf.createServerSocket(0, 0, null);
        System.out.println("Created server on " + this.ss.getLocalSocketAddress());
    }

    public void start() {
        try {
            while (this.clients.size() < this.numberOfClients) {
                System.out.println("Server waiting for connections");
                Client tmp = new Client(this.ss.accept());
                System.out.println("Got connection from " + tmp.address);
                this.clients.add(tmp);
            }
            for (Client c : this.clients) {
                c.writeParameters(5000);
            }
            for (int r = 0; r < this.repeat; ++r) {
                for (Client client : this.clients) {
                    client.start(5000);
                }
                int totalTime = 0;
                for (Client c3 : this.clients) {
                    totalTime += c3.sync();
                }
                double d = (double)totalTime / (double)(this.count * this.numberOfClients);
                System.err.println("Avg. connect time: " + d + " ms.");
            }
            for (Client c : this.clients) {
                c.done(5000);
            }
        }
        catch (Exception e) {
            System.err.println("Server got exception " + e);
            e.printStackTrace(System.err);
        }
    }

    private class Client {
        final VirtualSocket s;
        final DataInputStream in;
        final DataOutputStream out;
        final VirtualSocketAddress address;

        Client(VirtualSocket s) throws IOException {
            this.s = s;
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            s.setSoTimeout(5000);
            s.setTcpNoDelay(true);
            this.address = new VirtualSocketAddress(this.in);
        }

        void writeParameters(int timeout) throws IOException {
            this.s.setSoTimeout(timeout);
            this.out.writeInt(Server.this.count);
            this.out.writeInt(Server.this.clients.size() - 1);
            for (Client c : Server.this.clients) {
                if (c == this) continue;
                c.address.write(this.out);
            }
            this.out.flush();
        }

        void start(int timeout) throws IOException {
            this.s.setSoTimeout(timeout);
            this.out.writeByte(42);
            this.out.flush();
        }

        void done(int timeout) throws IOException {
            this.s.setSoTimeout(timeout);
            this.out.writeByte(44);
            this.out.flush();
            VirtualSocketFactory.close(this.s, this.out, this.in);
        }

        int sync() throws IOException {
            this.s.setSoTimeout(0);
            if (this.in.readByte() != 43) {
                System.err.println("Client " + this.address + " returned junk!");
                return 0;
            }
            return this.in.readInt();
        }
    }
}

