/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.interactive;

import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.hub.servicelink.HubInfo;
import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public final class Test
extends Thread {
    private static int TIMEOUT = 10000;
    private static boolean interactive = false;
    private VirtualSocketFactory sf;
    private HashMap<String, Object> connectProperties;
    private ArrayList<Connection> connections = new ArrayList();
    private LinkedList<String> messages = new LinkedList();
    private HubInfo[] hubInfo;
    private ClientInfo[] clientInfo;
    private VirtualServerSocket normal;
    private VirtualServerSocket connectTest;
    private Acceptor acceptor;

    private Test(int port) throws IOException {
        this.connectProperties = new HashMap();
        try {
            this.sf = VirtualSocketFactory.createSocketFactory();
        }
        catch (InitializationException e1) {
            throw new IOException("Failed to create socketfactory!");
        }
        this.normal = this.sf.createServerSocket(port, 0, this.connectProperties);
        this.connectTest = this.sf.createServerSocket(port + 1, 0, this.connectProperties);
        System.out.println("Created server socket on " + this.normal.getLocalSocketAddress());
        System.out.println("Created connection test server socket on " + this.connectTest.getLocalSocketAddress());
        this.sf.getServiceLink().registerProperty("Test", this.normal.getLocalSocketAddress().toString());
        this.sf.getServiceLink().registerProperty("Repeat", this.connectTest.getLocalSocketAddress().toString());
        this.acceptor = new Acceptor(this.connectTest);
        this.acceptor.start();
    }

    private void closed(Connection c) {
        this.gotMessage("Connection " + c.number + " closed");
        this.connections.set(c.number, null);
    }

    private synchronized void printMessages() {
        for (String m : this.messages) {
            System.out.println(m);
        }
        this.messages.clear();
    }

    private void gotMessage(String message) {
        if (interactive) {
            this.messages.add(message);
        } else {
            System.out.println(message);
        }
    }

    private void usage() {
    }

    private int parseTargetHub(String s) {
        int target = -1;
        try {
            target = Integer.parseInt(s);
        }
        catch (Exception e) {
            System.out.println("Failed to parse target: " + s);
            return -1;
        }
        if (this.hubInfo == null) {
            System.out.println("No hub info available!");
            return -1;
        }
        if (target < 0 || target >= this.hubInfo.length) {
            System.out.println("Cannot list clients for hub [" + target + "]:  hub does not exist!");
            return -1;
        }
        return target;
    }

    private synchronized int parseTargetConnection(String s) {
        int target = -1;
        try {
            target = Integer.parseInt(s);
        }
        catch (Exception e) {
            System.out.println("Failed to parse target: " + s);
            return -1;
        }
        if (target < 0 || target >= this.connections.size()) {
            System.out.println("Cannot connect to [" + target + "]:  connection does not exist!");
            return -1;
        }
        return target;
    }

    private int parseTargetClient(String s) {
        int target = -1;
        try {
            target = Integer.parseInt(s);
        }
        catch (Exception e) {
            System.out.println("Failed to parse target: " + s);
            return -1;
        }
        if (this.clientInfo == null) {
            System.out.println("No client info available yet!");
            return -1;
        }
        if (target < 0 || target >= this.clientInfo.length) {
            System.out.println("Cannot connect to [" + target + "]:  client does not exist!");
            return -1;
        }
        return target;
    }

    private void sendData(String s) {
        int target = -1;
        StringTokenizer st = new StringTokenizer(s, " ");
        if (st.countTokens() != 3) {
            System.out.println("sending data requires parameters: target size chunks");
            return;
        }
        target = this.parseTargetConnection(st.nextToken());
        if (target == -1) {
            return;
        }
        try {
            int size = Integer.parseInt(st.nextToken());
            int chunks = Integer.parseInt(st.nextToken());
            Connection c = this.connections.get(target);
            if (c == null) {
                System.out.println("No connection to " + target);
                return;
            }
            c.sendDataMessage(size, chunks);
        }
        catch (Exception e) {
            System.out.println("sending data requires parameters: target size chunks");
        }
    }

    private void send(String s) {
        if (s.length() == 0) {
            System.out.println("send requires parameters: target <message>");
            return;
        }
        if (s.startsWith("data ")) {
            this.sendData(s.substring(5).trim());
            return;
        }
        int index = s.indexOf(32);
        int target = -1;
        if (index == -1) {
            target = this.parseTargetConnection(s);
            s = "";
        } else {
            target = this.parseTargetConnection(s.substring(0, index));
            s = s.substring(index).trim();
        }
        if (target == -1) {
            return;
        }
        Connection c = this.connections.get(target);
        if (c == null) {
            System.out.println("No connection to " + target);
            return;
        }
        c.sendMessage(s);
    }

    private void ping(String s) {
        StringTokenizer st = new StringTokenizer(s, " ");
        if (st.countTokens() != 2) {
            System.out.println("ping requires parameters: target <repeat>");
            return;
        }
        int target = this.parseTargetConnection(st.nextToken());
        if (target == -1) {
            return;
        }
        int repeat = -1;
        try {
            repeat = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            System.out.println("ping requires parameters: target <repeat>");
            return;
        }
        Connection c = this.connections.get(target);
        if (c == null) {
            System.out.println("No connection to " + target);
            return;
        }
        long time = c.ping(repeat);
        System.out.println("Ping took: " + time + " ms. (rtt. " + time / (long)repeat + ")");
    }

    private synchronized void connections() {
        int i = 0;
        for (Connection c : this.connections) {
            if (c != null) {
                System.out.println("[" + i + "]: " + c);
            }
            ++i;
        }
    }

    private void listhubs() throws IOException {
        this.hubInfo = this.sf.getServiceLink().hubDetails();
        int i = 0;
        for (HubInfo info : this.hubInfo) {
            System.out.println("[" + i++ + "] " + info.name + " (" + info.clients + " clients)");
        }
    }

    private void listclients(String s) throws IOException {
        int target = this.parseTargetHub(s);
        if (target == -1) {
            return;
        }
        HubInfo info = this.hubInfo[target];
        this.clientInfo = this.sf.getServiceLink().clients(info.hubAddress);
        int i = 0;
        for (ClientInfo c : this.clientInfo) {
            System.out.println("[" + i++ + "] " + c);
        }
    }

    private synchronized void exit() {
        for (Connection c : this.connections) {
            if (c == null) continue;
            c.close();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String s) {
        int target = this.parseTargetClient(s);
        if (target == -1) {
            return;
        }
        ClientInfo info = this.clientInfo[target];
        if (!info.hasProperty("Test")) {
            System.out.println("Cannot connect to client " + target + " since it doesn't export a \"Test\" port");
            return;
        }
        try {
            VirtualSocketAddress a = new VirtualSocketAddress(info.getProperty("Test"));
            long start = System.currentTimeMillis();
            VirtualSocket vs = this.sf.createClientSocket(a, TIMEOUT, null);
            vs.setSoTimeout(10000);
            long end = System.currentTimeMillis();
            System.out.println("Connection setup took: " + (end - start) + " ms.");
            Test test = this;
            synchronized (test) {
                Connection c = new Connection(this.connections.size(), vs);
                this.connections.add(c);
                c.start();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create connection: " + e);
        }
    }

    private synchronized void close(String s) {
        int target = this.parseTargetConnection(s);
        if (target == -1) {
            return;
        }
        Connection c = this.connections.get(target);
        if (c == null) {
            System.out.println("Connection " + target + " already closed!");
            return;
        }
        c.close();
        this.connections.set(target, null);
    }

    private void connectRepeat(String s) {
        int target = -1;
        StringTokenizer st = new StringTokenizer(s, " ");
        if (st.countTokens() != 2) {
            System.out.println("connect test requires parameters: target #connections");
            return;
        }
        target = this.parseTargetClient(st.nextToken());
        if (target == -1) {
            return;
        }
        int repeat = -1;
        try {
            repeat = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            System.out.println("connect test requires parameters: target #connections");
            return;
        }
        ClientInfo info = this.clientInfo[target];
        if (!info.hasProperty("Repeat")) {
            System.out.println("Cannot connect to client " + target + " since it doesn't export a \"Repeat\" port");
            return;
        }
        try {
            VirtualSocketAddress a = new VirtualSocketAddress(info.getProperty("Repeat"));
            System.out.println("Connecting " + repeat + " times to target " + target);
            long start = System.currentTimeMillis();
            for (int i = 0; i < repeat; ++i) {
                VirtualSocket vs = this.sf.createClientSocket(a, TIMEOUT, null);
                vs.close();
            }
            long end = System.currentTimeMillis();
            System.out.println(repeat + "connection setups took: " + (end - start) + " ms. -> avg. time: " + (end - start) / (long)repeat);
        }
        catch (Exception e) {
            System.out.println("Failed to create connection: " + e);
        }
    }

    private void parseInput() {
        boolean done = false;
        BufferedReader clin = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (!done) {
                System.out.print("> ");
                System.out.flush();
                String line = clin.readLine();
                if (line == null) {
                    this.exit();
                    done = true;
                } else if ((line = line.trim()).length() != 0) {
                    if (line.startsWith("help")) {
                        this.usage();
                    } else if (line.startsWith("send ")) {
                        this.send(line.substring(5).trim());
                    } else if (line.startsWith("hubs")) {
                        this.listhubs();
                    } else if (line.startsWith("clients")) {
                        this.listclients(line.substring(7).trim());
                    } else if (line.startsWith("connections")) {
                        this.connections();
                    } else if (line.startsWith("connect")) {
                        this.connect(line.substring(7).trim());
                    } else if (line.startsWith("repeat connect")) {
                        this.connectRepeat(line.substring(14).trim());
                    } else if (line.startsWith("close")) {
                        this.close(line.substring(5).trim());
                    } else if (line.startsWith("ping")) {
                        this.ping(line.substring(4).trim());
                    } else if (line.startsWith("exit")) {
                        this.exit();
                        done = true;
                    } else {
                        System.out.println("Unknown command, try help");
                    }
                }
                this.printMessages();
            }
        }
        catch (Exception e) {
            System.out.println("Got exception! " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnection(VirtualSocket s) {
        this.gotMessage("Incoming connection from " + s.getRemoteSocketAddress());
        Connection c = null;
        try {
            Test test = this;
            synchronized (test) {
                c = new Connection(this.connections.size(), s);
                this.connections.add(c);
                c.start();
            }
        }
        catch (Exception e) {
            System.out.println("Server got exception " + e);
        }
    }

    @Override
    public void run() {
        try {
            this.normal.setSoTimeout(1000);
        }
        catch (Exception e) {
            System.out.println("Server got exception " + e);
            return;
        }
        while (true) {
            VirtualSocket s = null;
            try {
                s = this.normal.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Exception e) {
                System.out.println("Server got exception " + e);
                return;
            }
            if (s == null) continue;
            this.handleConnection(s);
        }
    }

    public static void main(String[] args) throws IOException {
        int port = 17771;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-interactive")) {
                interactive = true;
                continue;
            }
            System.err.println("Unknown option: " + args[i]);
            System.exit(1);
        }
        Test t = new Test(port);
        if (interactive) {
            t.start();
            t.parseInput();
        } else {
            t.run();
        }
    }

    private static class Acceptor
    extends Thread {
        private final VirtualServerSocket ss;

        Acceptor(VirtualServerSocket ss) {
            this.ss = ss;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    VirtualSocket s = this.ss.accept();
                    s.close();
                }
            }
            catch (Exception e) {
                System.out.println("Acceptor got exception!");
                return;
            }
        }
    }

    private class Connection
    extends Thread {
        private final int number;
        private VirtualSocket socket;
        private DataInputStream in;
        private DataOutputStream out;
        private boolean done = false;
        private int ping = -1;
        private long pingTime = -1L;
        private boolean pingOK = true;

        Connection(int number, VirtualSocket socket) throws IOException {
            this.number = number;
            this.socket = socket;
            this.in = new DataInputStream(socket.getInputStream());
            this.out = new DataOutputStream(socket.getOutputStream());
        }

        public synchronized void done() {
            this.done = true;
        }

        private synchronized boolean getDone() {
            return this.done;
        }

        public synchronized long ping(int count) {
            while (this.ping != -1) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            this.ping = count;
            this.notifyAll();
            while (this.pingTime == -1L) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            long time = this.pingTime;
            if (!this.pingOK) {
                System.out.println("WARNING: Ping was interrupted by other traffic!");
            }
            this.ping = -1;
            this.pingTime = -1L;
            this.pingOK = true;
            this.notifyAll();
            return time;
        }

        private int getPing() {
            return this.ping;
        }

        @Override
        public String toString() {
            return this.socket.getRemoteSocketAddress().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(int opcode) throws IOException {
            switch (opcode) {
                case -1: 
                case 0: {
                    this.done();
                    break;
                }
                case 1: {
                    Test.this.gotMessage("[" + this.number + "] " + this.in.readUTF());
                    break;
                }
                case 2: {
                    int size = this.in.readInt();
                    int chunks = this.in.readInt();
                    byte[] data = new byte[size];
                    long start = System.currentTimeMillis();
                    for (int i = 0; i < chunks; ++i) {
                        this.in.readFully(data);
                    }
                    long end = System.currentTimeMillis();
                    Test.this.gotMessage("[" + this.number + "] Received " + chunks + " chunks of " + size + "bytes in " + (end - start) + " ms. (" + (double)(8L * (long)size * (long)chunks) / 1048576.0 / ((double)(end - start) / 1000.0) + " MBit/sec)");
                    break;
                }
                case 3: {
                    Connection connection = this;
                    synchronized (connection) {
                        this.out.write(4);
                        this.out.flush();
                        break;
                    }
                }
                case 4: {
                    break;
                }
                default: {
                    this.done();
                    Test.this.gotMessage("Receive junk on Connection " + this.number);
                }
            }
        }

        private synchronized void doPing(int count) throws IOException {
            long start = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                this.out.write(3);
                this.out.flush();
                int opcode = this.in.read();
                if (opcode == 4) continue;
                this.pingOK = false;
                this.handleMessage(opcode);
            }
            long end = System.currentTimeMillis();
            this.pingTime = end - start;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                this.socket.setSoTimeout(1000);
            }
            catch (Exception e) {
                Test.this.gotMessage("Failed to start connection " + this.number);
                VirtualSocketFactory.close(this.socket, this.out, this.in);
                Test.this.closed(this);
                return;
            }
            boolean done = this.getDone();
            while (!done) {
                try {
                    int ping = this.getPing();
                    if (ping > 0) {
                        this.doPing(ping);
                    } else {
                        int opcode = this.in.read();
                        this.handleMessage(opcode);
                    }
                }
                catch (SocketTimeoutException ping) {
                }
                catch (Exception e) {
                    this.done();
                    Test.this.gotMessage("Got exception on Connection " + this.number + ": " + e);
                    e.printStackTrace(System.err);
                }
                done = this.getDone();
            }
            VirtualSocketFactory.close(this.socket, this.out, this.in);
            Test.this.closed(this);
        }

        public synchronized void sendMessage(String message) {
            try {
                this.out.write(1);
                this.out.writeUTF(message);
                this.out.flush();
            }
            catch (Exception e) {
                System.out.println("Got exception on connection " + this.number + " while writing message " + e);
                VirtualSocketFactory.close(this.socket, this.out, this.in);
                Test.this.closed(this);
            }
        }

        public synchronized void sendDataMessage(int size, int chunks) {
            byte[] data = new byte[size];
            try {
                long start = System.currentTimeMillis();
                this.out.write(2);
                this.out.writeInt(size);
                this.out.writeInt(chunks);
                for (int i = 0; i < chunks; ++i) {
                    this.out.write(data);
                }
                this.out.flush();
                long end = System.currentTimeMillis();
                System.out.println("Send " + chunks + " chunks of " + size + "bytes in " + (end - start) + " ms. (" + (double)(8L * (long)size * (long)chunks) / 1048576.0 / ((double)(end - start) / 1000.0) + " MBit/sec)");
            }
            catch (Exception e) {
                System.out.println("Got exception on connection " + this.number + " while writing message " + e);
                VirtualSocketFactory.close(this.socket, this.out, this.in);
                Test.this.closed(this);
            }
        }

        public void close() {
            try {
                this.out.write(0);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            VirtualSocketFactory.close(this.socket, this.out, this.in);
        }
    }
}

