/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.hub;

import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.util.Arrays;

public class SimpleHubTest
implements Runnable {
    private VirtualSocketFactory factory;
    private int state = 0;
    private boolean done = false;

    public SimpleHubTest(VirtualSocketFactory factory) throws IOException {
        this.factory = factory;
        factory.getServiceLink().registerProperty("smartsockets.viz", "S^state=" + this.state++);
    }

    public synchronized void done() {
        this.done = true;
    }

    public synchronized boolean getDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            while (!this.getDone()) {
                Object[] hubs = this.factory.getKnownHubs();
                System.out.println("Known hubs: " + Arrays.deepToString(hubs));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.factory.getServiceLink().updateProperty("smartsockets.viz", "S^state=" + this.state++);
            }
        }
        catch (Exception e) {
            System.err.println("Oops: " + e);
            e.printStackTrace(System.err);
        }
        finally {
            try {
                this.factory.end();
            }
            catch (Exception exception) {}
        }
        System.out.println("Done!");
    }

    public static void main(String[] args) {
        try {
            VirtualSocketFactory factory = VirtualSocketFactory.createSocketFactory(null, true);
            System.out.println("Created socket factory");
            new SimpleHubTest(factory).run();
        }
        catch (Exception e) {
            System.err.println("Oops: " + e);
            e.printStackTrace(System.err);
        }
    }
}

