/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanParameterInfoSupport
extends MBeanParameterInfo
implements OpenMBeanParameterInfo,
Serializable {
    private static final long serialVersionUID = -7235016873758443122L;
    private OpenType openType = null;
    private Object defaultValue = null;
    private Set legalValues = null;
    private Comparable minValue = null;
    private Comparable maxValue = null;
    private transient int m_hashcode = 0;

    public OpenMBeanParameterInfoSupport(String name, String description, OpenType openType) {
        super(name, openType == null ? "" : openType.getClassName(), description);
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name parameter cannot be null or an empty string.");
        }
        if (description == null || description.trim().length() == 0) {
            throw new IllegalArgumentException("description parameter cannot be null or an empty string.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("OpenType parameter cannot be null.");
        }
        this.openType = openType;
    }

    public OpenMBeanParameterInfoSupport(String name, String description, OpenType openType, Object defaultValue) throws OpenDataException {
        this(name, description, openType);
        if (defaultValue != null) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("openType should not be an ArrayType or a TabularType when a default value is required.");
            }
            if (!openType.isValue(defaultValue)) {
                throw new OpenDataException("defaultValue class name " + defaultValue.getClass().getName() + " does not match the one defined in openType.");
            }
            this.defaultValue = defaultValue;
        }
    }

    public OpenMBeanParameterInfoSupport(String name, String description, OpenType openType, Object defaultValue, Object[] legalValues) throws OpenDataException {
        this(name, description, openType, defaultValue);
        if (legalValues != null && legalValues.length > 0) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("legalValues not supported if openType is an ArrayType or an instanceof TabularType");
            }
            for (int i = 0; i < legalValues.length; ++i) {
                if (openType.isValue(legalValues[i])) continue;
                throw new OpenDataException("The element at index " + i + " of type " + legalValues[i] + " is not an value specified in openType.");
            }
            this.assignLegalValues(legalValues);
            if (this.hasDefaultValue() && this.hasLegalValues() && !this.legalValues.contains(defaultValue)) {
                throw new OpenDataException("LegalValues must contain the defaultValue");
            }
        }
    }

    public OpenMBeanParameterInfoSupport(String name, String description, OpenType openType, Object defaultValue, Comparable minValue, Comparable maxValue) throws OpenDataException {
        this(name, description, openType, defaultValue);
        if (minValue != null) {
            if (!openType.isValue(minValue)) {
                throw new OpenDataException("Comparable value of " + minValue.getClass().getName() + " does not match the openType value of " + openType.getClassName());
            }
            this.minValue = minValue;
        }
        if (maxValue != null) {
            if (!openType.isValue(maxValue)) {
                throw new OpenDataException("Comparable value of " + maxValue.getClass().getName() + " does not match the openType value of " + openType.getClassName());
            }
            this.maxValue = maxValue;
        }
        if (this.hasMinValue() && this.hasMaxValue() && minValue.compareTo(maxValue) > 0) {
            throw new OpenDataException("minValue cannot be greater than maxValue.");
        }
        if (this.hasDefaultValue() && this.hasMinValue() && minValue.compareTo(defaultValue) > 0) {
            throw new OpenDataException("minValue cannot be greater than defaultValue.");
        }
        if (this.hasDefaultValue() && this.hasMaxValue() && ((Comparable)defaultValue).compareTo(maxValue) > 0) {
            throw new OpenDataException("defaultValue cannot be greater than maxValue.");
        }
    }

    private void assignLegalValues(Object[] legalValues) {
        HashSet<Object> modifiableSet = new HashSet<Object>();
        for (int i = 0; i < legalValues.length; ++i) {
            modifiableSet.add(legalValues[i]);
        }
        this.legalValues = Collections.unmodifiableSet(modifiableSet);
    }

    public OpenType getOpenType() {
        return this.openType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Set getLegalValues() {
        return this.legalValues;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public boolean isValue(Object obj) {
        if (this.hasDefaultValue() && obj == null) {
            return true;
        }
        if (!this.openType.isValue(obj)) {
            return false;
        }
        if (this.hasLegalValues() && !this.legalValues.contains(obj)) {
            return false;
        }
        if (this.hasMinValue() && this.minValue.compareTo(obj) > 0) {
            return false;
        }
        return !this.hasMaxValue() || this.maxValue.compareTo(obj) >= 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenMBeanParameterInfo)) {
            return false;
        }
        OpenMBeanParameterInfo paramObj = (OpenMBeanParameterInfo)obj;
        if (!this.getName().equals(paramObj.getName())) {
            return false;
        }
        if (!this.getOpenType().equals(paramObj.getOpenType())) {
            return false;
        }
        if (this.hasDefaultValue() && !this.getDefaultValue().equals(paramObj.getDefaultValue())) {
            return false;
        }
        if (!this.hasDefaultValue() && paramObj.hasDefaultValue()) {
            return false;
        }
        if (this.hasMinValue() && !this.getMinValue().equals(paramObj.getMinValue())) {
            return false;
        }
        if (!this.hasMinValue() && paramObj.hasMinValue()) {
            return false;
        }
        if (this.hasMaxValue() && !this.getMaxValue().equals(paramObj.getMaxValue())) {
            return false;
        }
        if (!this.hasMaxValue() && paramObj.hasMaxValue()) {
            return false;
        }
        if (this.hasLegalValues() && !((Object)this.getLegalValues()).equals(paramObj.getLegalValues())) {
            return false;
        }
        return this.hasLegalValues() || !paramObj.hasLegalValues();
    }

    public int hashCode() {
        if (this.m_hashcode == 0) {
            int result = this.getName().hashCode();
            result += this.getOpenType().hashCode();
            result += !this.hasDefaultValue() ? 0 : this.getDefaultValue().hashCode();
            result += !this.hasLegalValues() ? 0 : ((Object)this.getLegalValues()).hashCode();
            result += !this.hasMinValue() ? 0 : this.getMinValue().hashCode();
            this.m_hashcode = result += !this.hasMaxValue() ? 0 : this.getMaxValue().hashCode();
        }
        return this.m_hashcode;
    }

    public String toString() {
        StringBuffer buf2 = new StringBuffer(this.getClass().getName());
        buf2.append("\t(name = ");
        buf2.append(this.getName());
        buf2.append("\topenType = ");
        buf2.append(this.openType.toString());
        buf2.append("\tdefault value = ");
        buf2.append(String.valueOf(this.defaultValue));
        buf2.append("\tmin value = ");
        buf2.append(String.valueOf(this.minValue));
        buf2.append("\tmax value = ");
        buf2.append(String.valueOf(this.maxValue));
        buf2.append("\tlegal values = ");
        buf2.append(String.valueOf(this.legalValues));
        buf2.append(")");
        return buf2.toString();
    }
}

