/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.viz;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import ibis.smartsockets.SmartSocketsProperties;
import ibis.smartsockets.direct.DirectServerSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.servicelink.ClientInfo;
import ibis.smartsockets.hub.servicelink.HubInfo;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.viz.ClientNode;
import ibis.smartsockets.viz.HubNode;
import ibis.smartsockets.viz.UniqueColor;
import java.awt.Color;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class SmartsocketsViz
extends GLPanel
implements Runnable {
    private static final long serialVersionUID = -3629362794531051537L;
    private final boolean compact;
    private final ServiceLink sl;
    private HashMap<DirectSocketAddress, HubNode> hubs = new HashMap();
    private HashMap<DirectSocketAddress, HubNode> oldHubs = new HashMap();
    private UniqueColor c = new UniqueColor();
    private boolean done = false;

    private static Color getTextColor() {
        String textColorString = System.getProperty("smartsockets.viz.text.color");
        if (textColorString == null) {
            return null;
        }
        return Color.decode(textColorString);
    }

    private static Color getBackgroundColor() {
        String backgroundColorString = System.getProperty("smartsockets.viz.background.color");
        if (backgroundColorString == null) {
            return null;
        }
        return Color.decode(backgroundColorString);
    }

    private static DirectSocketAddress[] getAddresses(String ... hubs) throws Exception {
        DirectSocketAddress[] result = new DirectSocketAddress[hubs.length];
        for (int i = 0; i < hubs.length; ++i) {
            result[i] = DirectSocketAddress.getByAddress(hubs[i]);
        }
        return result;
    }

    public SmartsocketsViz(boolean useSliders, List<DirectSocketAddress> hubs) {
        this(useSliders, hubs.toArray(new DirectSocketAddress[0]));
    }

    public SmartsocketsViz(List<DirectSocketAddress> hubs) {
        this(hubs.toArray(new DirectSocketAddress[0]));
    }

    public SmartsocketsViz(boolean useSliders, DirectSocketAddress ... hubs) {
        this(SmartsocketsViz.getTextColor(), SmartsocketsViz.getBackgroundColor(), false, useSliders, true, hubs);
    }

    public SmartsocketsViz(DirectSocketAddress ... hubs) {
        this(SmartsocketsViz.getTextColor(), SmartsocketsViz.getBackgroundColor(), false, hubs);
    }

    public SmartsocketsViz(boolean useSliders, String ... hubs) throws Exception {
        this(SmartsocketsViz.getTextColor(), SmartsocketsViz.getBackgroundColor(), false, useSliders, true, SmartsocketsViz.getAddresses(hubs));
    }

    public SmartsocketsViz(String ... hubs) throws Exception {
        this(SmartsocketsViz.getTextColor(), SmartsocketsViz.getBackgroundColor(), false, SmartsocketsViz.getAddresses(hubs));
    }

    public SmartsocketsViz(Color textColor, Color backgroundColor, boolean showself, DirectSocketAddress ... hubs) {
        this(textColor, backgroundColor, showself, true, true, hubs);
    }

    public SmartsocketsViz(Color textColor, Color backgroundColor, boolean showself, boolean useSliders, boolean compact, String ... hubs) throws Exception {
        this(textColor, backgroundColor, showself, useSliders, compact, SmartsocketsViz.getAddresses(hubs));
    }

    public SmartsocketsViz(Color textColor, Color backgroundColor, boolean showself, boolean useSliders, boolean compact, DirectSocketAddress ... hubs) {
        super(textColor, backgroundColor, useSliders);
        this.compact = compact;
        this.initPopups();
        try {
            TypedProperties p = SmartSocketsProperties.getDefaultProperties();
            p.setProperty("smartsockets.modules.direct.ssh.in", "true");
            p.setProperty("smartsockets.modules.direct.ssh.out", "true");
            DirectSocketFactory df = DirectSocketFactory.getSocketFactory(p);
            DirectServerSocket ss = df.createServerSocket(0, 1, null);
            List<DirectSocketAddress> hubList = Arrays.asList(hubs);
            this.sl = ServiceLink.getServiceLink(null, hubList, ss.getAddressSet());
            if (showself) {
                this.sl.registerProperty("smartsockets.viz", "V^Visualization^#545454");
            } else {
                this.sl.registerProperty("smartsockets.viz", "invisible");
            }
        }
        catch (Exception e) {
            throw new Error("Failed to connect to Hub: ", e);
        }
        new Thread(this).start();
    }

    private void initPopups() {
        this.setNodePopup(null, null);
        this.initHubPopups();
    }

    private void initHubPopups() {
        PopupMenu p = new PopupMenu();
        MenuItem menuItem = new MenuItem("Expand clients");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SmartsocketsViz.this.popupNode != null && SmartsocketsViz.this.popupNode instanceof HubNode) {
                    ((HubNode)SmartsocketsViz.this.popupNode).expandClients();
                }
                SmartsocketsViz.this.tgPanel.setMaintainMouseOver(false);
                SmartsocketsViz.this.tgPanel.setMouseOverN(null);
                SmartsocketsViz.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(action);
        p.add(menuItem);
        this.setNodePopup("CollapsedHubNode", p);
        p = new PopupMenu();
        menuItem = new MenuItem("Collapse clients");
        action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SmartsocketsViz.this.popupNode != null && SmartsocketsViz.this.popupNode instanceof HubNode) {
                    ((HubNode)SmartsocketsViz.this.popupNode).collapseClients();
                }
                SmartsocketsViz.this.tgPanel.setMaintainMouseOver(false);
                SmartsocketsViz.this.tgPanel.setMouseOverN(null);
                SmartsocketsViz.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(action);
        p.add(menuItem);
        this.setNodePopup("ExpandedHubNode", p);
    }

    private synchronized HubInfo[] getHubs() {
        try {
            return this.sl.hubDetails();
        }
        catch (IOException e) {
            System.err.println("Failed to list hubs: " + e);
            e.printStackTrace(System.err);
            return null;
        }
    }

    synchronized ClientInfo[] getClientsForHub(DirectSocketAddress hub) {
        try {
            return this.sl.clients(hub);
        }
        catch (IOException e) {
            System.err.println("Failed to list hubs: " + e);
            e.printStackTrace(System.err);
            return null;
        }
    }

    private void updateHub(HubInfo info) {
        HubNode h = this.oldHubs.remove(info.hubAddress);
        if (h == null) {
            h = new HubNode(this, info);
            try {
                this.tgPanel.addNode(h);
            }
            catch (TGException e) {
                e.printStackTrace();
            }
        } else {
            h.updateInfo(info);
        }
        this.hubs.put(info.hubAddress, h);
    }

    private void updateGraph() {
        HubInfo[] p = this.getHubs();
        if (p == null) {
            return;
        }
        HashMap<DirectSocketAddress, HubNode> tmp = this.hubs;
        this.hubs = this.oldHubs;
        this.oldHubs = tmp;
        for (int i = 0; i < p.length; ++i) {
            this.updateHub(p[i]);
        }
        if (this.oldHubs.size() > 0) {
            for (HubNode hi : this.oldHubs.values()) {
                hi.delete();
            }
        }
        for (HubNode n : this.hubs.values()) {
            n.removeUnusedEdges();
            n.addAndUpdateEdges();
            n.updateClients();
        }
        HashMap<Object, ClientNode> clients = new HashMap<Object, ClientNode>();
        for (HubNode n : this.hubs.values()) {
            n.getClients(clients);
        }
        for (HubNode n : this.hubs.values()) {
            n.updateRouters(clients);
        }
        this.tgPanel.repaint();
    }

    public synchronized void done() {
        this.done = true;
        this.notifyAll();
    }

    public synchronized boolean getDone() {
        return this.done;
    }

    private synchronized void waitFor(long time) {
        try {
            this.wait(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.getDone()) {
            this.updateGraph();
            this.waitFor(5000L);
        }
        this.sl.setDone();
    }

    public static void main(String[] args) {
        System.err.println("Starting Smartsockets Vizualization...");
        if (args.length != 1) {
            System.err.println("Hub address required as a parameter...");
            System.exit(1);
        }
        LinkedList<DirectSocketAddress> hub = new LinkedList<DirectSocketAddress>();
        for (String s : args) {
            try {
                hub.add(DirectSocketAddress.getByAddress(s));
            }
            catch (Exception e1) {
                System.err.println("Couldn't parse hub address: " + s);
            }
        }
        if (hub.size() == 0) {
            System.err.println("No hubs provided!");
            System.exit(1);
        }
        final SmartsocketsViz glPanel = new SmartsocketsViz(hub);
        final Frame frame = new Frame("Smartsockets Visualization");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                glPanel.done();
                frame.remove(glPanel);
                frame.dispose();
                System.exit(0);
            }
        });
        frame.add("Center", glPanel);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public void addEdge(Edge e) {
        this.tgPanel.addEdge(e);
    }

    public void deleteEdge(Edge e) {
        this.tgPanel.deleteEdge(e);
    }

    public HubNode getHubNode(DirectSocketAddress to) {
        return this.hubs.get(to);
    }

    public void addNode(Node n) {
        try {
            this.tgPanel.addNode(n);
        }
        catch (TGException e) {
            e.printStackTrace();
        }
    }

    public void deleteNode(Node node) {
        this.tgPanel.deleteNode(node);
    }

    public Color getUniqueColor() {
        return this.c.getUniqueColor();
    }

    boolean isCompact() {
        return this.compact;
    }
}

