/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual;

import ibis.smartsockets.SmartSocketsProperties;
import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.discovery.Discovery;
import ibis.smartsockets.hub.Hub;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.util.ThreadPool;
import ibis.smartsockets.util.TypedProperties;
import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.NoLocalAddressException;
import ibis.smartsockets.virtual.NoModulesDefinedException;
import ibis.smartsockets.virtual.NoSuitableModuleException;
import ibis.smartsockets.virtual.NonFatalIOException;
import ibis.smartsockets.virtual.TargetOverloadedException;
import ibis.smartsockets.virtual.VirtualClusters;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.modules.AbstractDirectModule;
import ibis.smartsockets.virtual.modules.AcceptHandler;
import ibis.smartsockets.virtual.modules.ConnectModule;
import ibis.smartsockets.virtual.modules.direct.Direct;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualSocketFactory {
    private static final Map<String, VirtualSocketFactory> factories = new HashMap<String, VirtualSocketFactory>();
    private static VirtualSocketFactory defaultFactory = null;
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.virtual.misc");
    protected static final Logger conlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.virtual.connect");
    private static final Logger statslogger = LoggerFactory.getLogger((String)"ibis.smartsockets.statistics");
    private final DirectSocketFactory directSocketFactory;
    private final ArrayList<ConnectModule> modules = new ArrayList();
    private ConnectModule direct;
    private final TypedProperties properties;
    private final int DEFAULT_BACKLOG;
    private final int DEFAULT_TIMEOUT;
    private final int DEFAULT_ACCEPT_TIMEOUT;
    private final boolean DETAILED_EXCEPTIONS;
    private final Random random;
    private final HashMap<Integer, VirtualServerSocket> serverSockets = new HashMap();
    private int nextPort = 3000;
    private DirectSocketAddress myAddresses;
    private DirectSocketAddress hubAddress;
    private VirtualSocketAddress localVirtualAddress;
    private String localVirtualAddressAsString;
    private ServiceLink serviceLink;
    private Hub hub;
    private VirtualClusters clusters;
    private boolean printStatistics = false;
    private String statisticPrefix = null;
    private StatisticsPrinter printer = null;

    private VirtualSocketFactory(DirectSocketFactory df, TypedProperties p) throws InitializationException {
        this.directSocketFactory = df;
        if (logger.isInfoEnabled()) {
            logger.info("Creating VirtualSocketFactory");
        }
        this.random = new Random();
        this.properties = p;
        this.DETAILED_EXCEPTIONS = p.booleanProperty("smartsockets.detailed.exceptions", false);
        this.DEFAULT_BACKLOG = p.getIntProperty("smartsockets.backlog", 50);
        this.DEFAULT_ACCEPT_TIMEOUT = p.getIntProperty("smartsockets.timeout.accept", 60000);
        try {
            this.loadModules();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to load modules!", (Throwable)e);
            }
            throw new InitializationException(e.getMessage(), e);
        }
        if (this.modules.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to load any modules!");
            }
            throw new InitializationException("Failed to load any modules!");
        }
        this.DEFAULT_TIMEOUT = this.determineDefaultTimeout(p);
        this.startHub(p);
        String localCluster = p.getProperty("smartsockets.cluster.member", null);
        this.createServiceLink(localCluster);
        this.startModules();
        if (this.modules.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to start any modules!");
            }
            throw new InitializationException("Failed to load any modules!");
        }
        this.loadClusterDefinitions();
        this.localVirtualAddress = new VirtualSocketAddress(this.myAddresses, 0, this.hubAddress, this.clusters.localCluster());
        this.localVirtualAddressAsString = this.localVirtualAddress.toString();
        this.printStatistics = p.booleanProperty("smartsockets.statistics");
        if (this.printStatistics) {
            this.statisticPrefix = p.getProperty("smartsockets.statistics.prefix", "SmartSockets");
            int tmp = p.getIntProperty("smartsockets.statistics.interval", 0);
            if (tmp > 0) {
                this.printer = new StatisticsPrinter(this, tmp * 1000, this.statisticPrefix);
                ThreadPool.createNew(this.printer, "SmartSockets Statistics Printer");
            }
        }
    }

    private void startHub(TypedProperties p) throws InitializationException {
        if (p.booleanProperty("smartsockets.start.hub", false)) {
            ConnectModule d = null;
            boolean delegate = p.booleanProperty("smartsockets.hub.delegate", false);
            if (delegate) {
                if (logger.isInfoEnabled()) {
                    logger.info("Factory delegating hub accepts to direct module!");
                }
                for (ConnectModule m : this.modules) {
                    if (!m.module.equals("ConnectModule(Direct)")) continue;
                    d = (AbstractDirectModule)m;
                    break;
                }
                if (d == null) {
                    throw new InitializationException("Cannot start hub: Failed to find direct module!");
                }
                p.setProperty("smartsockets.hub.delegate.address", d.getAddresses().toString());
            }
            if (logger.isInfoEnabled()) {
                logger.info("Factory is starting hub");
            }
            try {
                this.hub = new Hub(p);
                if (logger.isInfoEnabled()) {
                    logger.info("Hub running on: " + this.hub.getHubAddress());
                }
            }
            catch (IOException e) {
                throw new InitializationException("Failed to start hub", e);
            }
            if (delegate) {
                int port = p.getIntProperty("smartsockets.hub.virtualPort", 42);
                ((AbstractDirectModule)d).installAcceptHandler(port, new HubAcceptor(this.hub));
            }
        }
    }

    private void loadClusterDefinitions() {
        this.clusters = new VirtualClusters(this, this.properties, this.getModules());
    }

    private DirectSocketAddress discoverHub(String localCluster) {
        DirectSocketAddress address;
        block7: {
            address = null;
            if (logger.isInfoEnabled()) {
                logger.info("Attempting to discover hub using UDP multicast...");
            }
            int port = this.properties.getIntProperty("smartsockets.discovery.port");
            int time = this.properties.getIntProperty("smartsockets.discovery.timeout");
            Discovery d = new Discovery(port, 0, time);
            String message = "Any Proxies? ";
            String result = d.broadcastWithReply(message = message + localCluster);
            if (result != null) {
                try {
                    address = DirectSocketAddress.getByAddress(result);
                    if (logger.isInfoEnabled()) {
                        logger.info("Hub found at: " + address.toString());
                    }
                    break block7;
                }
                catch (Exception e) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Got unknown reply to hub discovery!");
                    }
                    break block7;
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("No hubs found.");
            }
        }
        return address;
    }

    private void createServiceLink(String localCluster) {
        Object[] tmp;
        LinkedList<DirectSocketAddress> hubs = new LinkedList<DirectSocketAddress>();
        if (this.hub != null) {
            hubs.add(this.hub.getHubAddress());
        }
        if ((tmp = this.properties.getStringList("smartsockets.hub.addresses")) != null && tmp.length > 0) {
            for (String string : tmp) {
                try {
                    hubs.add(DirectSocketAddress.getByAddress(string));
                }
                catch (Exception e) {
                    logger.warn("Failed to understand hub address: " + Arrays.deepToString(tmp), (Throwable)e);
                }
            }
        }
        if (hubs.size() == 0) {
            boolean useDiscovery = this.properties.booleanProperty("smartsockets.discovery.allowed", false);
            boolean discoveryPreferred = this.properties.booleanProperty("smartsockets.discovery.preferred", false);
            DirectSocketAddress address = null;
            if (useDiscovery && (discoveryPreferred || this.hub == null)) {
                address = this.discoverHub(localCluster);
            }
            if (address != null) {
                hubs.add(address);
            }
        }
        if (hubs.size() == 0) {
            logger.warn("ServiceLink not created: no hub address available!");
            return;
        }
        boolean force = this.properties.booleanProperty("smartsockets.servicelink.force");
        try {
            this.serviceLink = ServiceLink.getServiceLink(this.properties, hubs, this.myAddresses);
            this.hubAddress = this.serviceLink.getAddress();
        }
        catch (Exception e) {
            logger.warn("Failed to obtain service link to hub!", (Throwable)e);
            if (force) {
                logger.error("Permanent failure of servicelink! -- will exit");
                System.exit(1);
            }
            return;
        }
        if (force) {
            boolean connected = false;
            for (int retries = Math.max(1, this.properties.getIntProperty("smartsockets.servicelink.retries")); !connected && retries > 0; --retries) {
                try {
                    this.serviceLink.waitConnected(this.properties.getIntProperty("smartsockets.servicelink.timeout"));
                    connected = true;
                    continue;
                }
                catch (Exception exception) {
                    logger.warn("Failed to connect service link to hub " + this.hubAddress, (Throwable)exception);
                }
            }
            if (!connected) {
                logger.error("Permanent failure of servicelink! -- will exit");
                System.exit(1);
            }
        } else {
            try {
                this.serviceLink.waitConnected(this.properties.getIntProperty("smartsockets.servicelink.timeout"));
            }
            catch (Exception e) {
                logger.warn("Failed to connect service link to hub " + this.hubAddress, (Throwable)e);
                return;
            }
        }
        String[] props = this.properties.getStringList("smartsockets.register.property", ",", null);
        if (props != null && props.length > 0) {
            try {
                if (props.length == 1) {
                    this.serviceLink.registerProperty(props[0], "");
                } else {
                    this.serviceLink.registerProperty(props[0], props[1]);
                }
            }
            catch (Exception e) {
                if (props.length == 1) {
                    logger.warn("Failed to register user property: " + props[0]);
                }
                logger.warn("Failed to register user property: " + props[0] + "=" + props[1]);
            }
        }
    }

    private ConnectModule instantiateModule(String name) {
        String classname;
        if (logger.isInfoEnabled()) {
            logger.info("Loading module: " + name);
        }
        if ((classname = this.properties.getProperty("smartsockets.modules." + name, null)) == null) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("ibis.smartsockets.virtual.modules.");
            tmp.append(name.toLowerCase());
            tmp.append(".");
            tmp.append(Character.toUpperCase(name.charAt(0)));
            tmp.append(name.substring(1));
            classname = tmp.toString();
        }
        if (logger.isInfoEnabled()) {
            logger.info("    class name: " + classname);
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> c = cl != null ? cl.loadClass(classname) : Class.forName(classname);
            if (!ConnectModule.class.isAssignableFrom(c)) {
                logger.warn("Cannot load module " + classname + " since it is  not a subclass of ConnectModule!");
                return null;
            }
            return (ConnectModule)c.newInstance();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to load module " + classname, (Throwable)e);
            }
            return null;
        }
    }

    private void loadModule(String name) throws Exception {
        ConnectModule m = this.instantiateModule(name);
        m.init(this, name, this.properties, logger);
        DirectSocketAddress tmp = m.getAddresses();
        if (tmp != null) {
            this.myAddresses = this.myAddresses == null ? tmp : DirectSocketAddress.merge(this.myAddresses, tmp);
        }
        this.modules.add(m);
    }

    private void loadModules() throws Exception {
        String[] mods = this.properties.getStringList("smartsockets.modules.define", ",", new String[0]);
        if (mods == null || mods.length == 0) {
            throw new NoModulesDefinedException("No smartsockets modules defined!");
        }
        String[] skip = this.properties.getStringList("smartsockets.modules.skip", ",", null);
        int count = mods.length;
        if (skip != null) {
            for (int s = 0; s < skip.length; ++s) {
                for (int m = 0; m < mods.length; ++m) {
                    if (!skip[s].equals(mods[m])) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info("Skipping module " + mods[m]);
                    }
                    mods[m] = null;
                    --count;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            String t = "";
            for (int i = 0; i < mods.length; ++i) {
                if (mods[i] == null) continue;
                t = t + mods[i] + " ";
            }
            logger.info("Loading " + count + " modules: " + t);
        }
        if (count == 0) {
            throw new NoModulesDefinedException("No smartsockets modules left after filtering!");
        }
        try {
            this.direct = new Direct(this.directSocketFactory);
            this.direct.init(this, "direct", this.properties, logger);
            this.myAddresses = this.direct.getAddresses();
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to load direct module!", (Throwable)e);
            }
            throw e;
        }
        if (this.myAddresses == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to retrieve my own address!");
            }
            throw new NoLocalAddressException("Failed to retrieve local address!");
        }
        for (int i = 0; i < mods.length; ++i) {
            if (mods[i] == null) continue;
            if (mods[i].equals("direct")) {
                this.modules.add(this.direct);
                continue;
            }
            try {
                this.loadModule(mods[i]);
                continue;
            }
            catch (Exception e) {
                if (logger.isInfoEnabled()) {
                    logger.info("Failed to load module: " + mods[i], (Throwable)e);
                }
                mods[i] = null;
                --count;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(count + " modules loaded.");
        }
        if (count == 0) {
            throw new NoModulesDefinedException("Failed to load any modules");
        }
    }

    private int determineDefaultTimeout(TypedProperties p) {
        int[] tmp = new int[this.modules.size()];
        int totalTimeout = 0;
        for (int i = 0; i < this.modules.size(); ++i) {
            tmp[i] = this.modules.get(i).getDefaultTimeout();
            totalTimeout += tmp[i];
        }
        int timeout = p.getIntProperty("smartsockets.timeout.connect", -1);
        if (timeout <= 0) {
            timeout = totalTimeout;
        } else {
            for (int i = 0; i < this.modules.size(); ++i) {
                double t = (double)tmp[i] / (double)totalTimeout * (double)timeout;
                this.modules.get(i).setTimeout((int)t);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Total timeout set to: " + timeout);
            for (ConnectModule m : this.modules) {
                logger.info("  " + m.getName() + ": " + m.getTimeout());
            }
        }
        return timeout;
    }

    protected ConnectModule[] getModules() {
        return this.modules.toArray(new ConnectModule[this.modules.size()]);
    }

    protected ConnectModule[] getModules(String[] names) {
        ArrayList<ConnectModule> tmp = new ArrayList<ConnectModule>();
        for (int i = 0; i < names.length; ++i) {
            boolean found = false;
            if (names[i] == null || names[i].equals("none")) continue;
            for (int j = 0; j < this.modules.size(); ++j) {
                ConnectModule m = this.modules.get(j);
                if (!m.getName().equals(names[i])) continue;
                tmp.add(m);
                found = true;
                break;
            }
            if (found) continue;
            logger.warn("Module " + names[i] + " not found!");
        }
        return tmp.toArray(new ConnectModule[tmp.size()]);
    }

    private void startModules() {
        ArrayList<ConnectModule> failed = new ArrayList<ConnectModule>();
        if (this.serviceLink == null) {
            for (ConnectModule c : this.modules) {
                if (!c.requiresServiceLink) continue;
                failed.add(c);
            }
            for (ConnectModule c : failed) {
                if (logger.isInfoEnabled()) {
                    logger.info("Module " + c.module + " removed (no serviceLink)!");
                }
                this.modules.remove(c);
            }
            failed.clear();
        }
        for (ConnectModule c : this.modules) {
            try {
                c.startModule(this.serviceLink);
            }
            catch (Exception e) {
                logger.warn("Module " + c.module + " did not accept serviceLink!", (Throwable)e);
                failed.add(c);
            }
        }
        for (ConnectModule c : failed) {
            logger.warn("Module " + c.module + " removed (exception during setup)!");
            this.modules.remove(c);
        }
        failed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualServerSocket getServerSocket(int port) {
        HashMap<Integer, VirtualServerSocket> hashMap = this.serverSockets;
        synchronized (hashMap) {
            return this.serverSockets.get(port);
        }
    }

    public ConnectModule findModule(String name) {
        if (name.equals("direct")) {
            return this.direct;
        }
        for (ConnectModule m : this.modules) {
            if (!m.module.equals(name)) continue;
            return m;
        }
        return null;
    }

    public static void close(VirtualSocket s, OutputStream out, InputStream in) {
        block11: {
            block10: {
                block9: {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!logger.isInfoEnabled()) break block9;
                        logger.info("Failed to close OutputStream", e);
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Throwable e) {
                    if (!logger.isInfoEnabled()) break block10;
                    logger.info("Failed to close InputStream", e);
                }
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable e) {
                if (!logger.isInfoEnabled()) break block11;
                logger.info("Failed to close Socket", e);
            }
        }
    }

    public static void close(VirtualSocket s, SocketChannel channel) {
        block7: {
            block6: {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Exception e) {
                        if (!logger.isInfoEnabled()) break block6;
                        logger.info("Failed to close SocketChannel", (Throwable)e);
                    }
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block7;
                    logger.info("Failed to close Socket", (Throwable)e);
                }
            }
        }
    }

    private VirtualSocket createClientSocket(ConnectModule m, VirtualSocketAddress target, int timeout, int timeLeft, boolean fillTimeout, Map<String, Object> properties) throws IOException, NonFatalIOException {
        int backoff = 1000;
        if (!m.matchRuntimeRequirements(properties)) {
            if (conlogger.isInfoEnabled()) {
                conlogger.warn("Failed: module " + m.module + " may not be used to set up connection to " + target);
            }
            m.connectNotAllowed();
            return null;
        }
        if (conlogger.isDebugEnabled()) {
            conlogger.debug("Using module " + m.module + " to set up connection to " + target + " timeout = " + timeout + " timeleft = " + timeLeft);
        }
        VirtualSocket vs = null;
        int overloaded = 0;
        long start = System.currentTimeMillis();
        boolean lastAttempt = false;
        while (true) {
            long t;
            block25: {
                if ((t = System.currentTimeMillis() - start) >= (long)timeLeft) {
                    if (conlogger.isDebugEnabled()) {
                        conlogger.debug("Timeout while using module " + m.module + " to set up connection to " + target + " timeout = " + timeout + " timeleft = " + timeLeft + " t = " + t);
                    }
                    if (overloaded > 0) {
                        m.connectRejected(t);
                        throw new TargetOverloadedException("Failed to create virtual connection to " + target + " within " + timeLeft + " ms. (Target overloaded " + overloaded + " times)");
                    }
                    m.connectFailed(t);
                    throw new SocketTimeoutException("Timeout while creating connection to " + target);
                }
                try {
                    vs = m.connect(target, timeout, properties);
                }
                catch (NonFatalIOException e) {
                    long end = System.currentTimeMillis();
                    if (conlogger.isInfoEnabled()) {
                        conlogger.info("Module " + m.module + " failed to connect to " + target + " after " + (end - start) + " ms.): " + e.getMessage());
                    }
                    m.connectFailed(end - start);
                    throw e;
                }
                t = System.currentTimeMillis() - start;
                if (vs == null) continue;
                int newTimeout = (int)((long)timeLeft - t);
                if (newTimeout <= 0) {
                    newTimeout = 1000;
                }
                if (conlogger.isInfoEnabled()) {
                    conlogger.info(this.getVirtualAddressAsString() + ": Success " + m.module + " connected to " + target + " now waiting for accept (for max. " + newTimeout + " ms.)");
                }
                try {
                    vs.waitForAccept(newTimeout);
                    vs.setTcpNoDelay(false);
                    long end = System.currentTimeMillis();
                    if (conlogger.isInfoEnabled()) {
                        conlogger.info(this.getVirtualAddressAsString() + ": Success " + m.module + " connected to " + target + " (time = " + (end - start) + " ms.)");
                    }
                    m.connectSucces(end - start);
                    return vs;
                }
                catch (TargetOverloadedException e) {
                    if (conlogger.isDebugEnabled()) {
                        conlogger.debug("Connection failed, target " + target + " overloaded (" + overloaded + ") while using  module " + m.module);
                    }
                    ++overloaded;
                }
                catch (IOException e) {
                    if (conlogger.isDebugEnabled()) {
                        conlogger.debug("Connection failed, target " + target + ", got exception (" + e.getMessage() + ") while using  module " + m.module);
                    }
                    if (fillTimeout) break block25;
                    m.connectFailed(System.currentTimeMillis() - start);
                    throw e;
                }
            }
            t = System.currentTimeMillis() - start;
            m.connectRejected(t);
            int leftover = (int)((long)timeLeft - t);
            if (!lastAttempt && leftover > 0) {
                int sleeptime = 0;
                if (backoff < leftover) {
                    sleeptime = this.random.nextInt(backoff);
                } else {
                    sleeptime = leftover;
                    lastAttempt = true;
                }
                if (sleeptime > 0) {
                    try {
                        Thread.sleep(sleeptime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (leftover < 500) {
                    timeLeft = 0;
                    continue;
                }
                backoff *= 2;
                continue;
            }
            timeLeft = 0;
        }
    }

    private String[] getNames(ConnectModule[] modules) {
        String[] names = new String[modules.length];
        for (int n = 0; n < modules.length; ++n) {
            names[n] = modules[n].getName();
        }
        return names;
    }

    private VirtualSocket createClientSocket(VirtualSocketAddress target, ConnectModule[] order, int[] timeouts, int totalTimeout, long[] timing, boolean fillTimeout, Map<String, Object> prop) throws IOException, NoSuitableModuleException {
        Throwable[] exceptions = new Throwable[order.length];
        try {
            int timeLeft = totalTimeout;
            VirtualSocket vs = null;
            for (int i = 0; i < order.length; ++i) {
                ConnectModule m = order[i];
                int timeout = timeouts != null ? timeouts[i] : m.getTimeout();
                long start = System.currentTimeMillis();
                try {
                    vs = this.createClientSocket(m, target, timeout, timeLeft, fillTimeout, prop);
                }
                catch (NonFatalIOException e) {
                    exceptions[i] = e;
                }
                if (vs != null) {
                    if (i > 0) {
                        this.clusters.succes(target, m);
                    }
                    VirtualSocket virtualSocket = vs;
                    return virtualSocket;
                }
                if (order.length <= 1 || i >= order.length - 1 || (timeLeft = (int)((long)timeLeft - (System.currentTimeMillis() - start))) > 0) continue;
                throw new NoSuitableModuleException("Timeout during  connect to " + target, this.getNames(order), exceptions);
            }
            if (logger.isInfoEnabled()) {
                logger.info("No suitable module found to connect to " + target);
            }
            throw new NoSuitableModuleException("No suitable module found to connect to " + target + " (timeouts=" + Arrays.toString(timeouts) + ", fillTimeout=" + fillTimeout + ")", this.getNames(order), exceptions);
        }
        finally {
            if (timing != null && prop != null) {
                timing[0] = System.nanoTime() - timing[0];
                prop.remove("direct.detailed.timing.ignore");
            }
        }
    }

    private int[] distributesTimeout(int timeout, int[] timeouts, ConnectModule[] modules) {
        if (timeouts == null) {
            timeouts = new int[modules.length];
        }
        for (int i = 0; i < modules.length; ++i) {
            double t = (double)modules[i].getTimeout() / (double)this.DEFAULT_TIMEOUT;
            timeouts[i] = (int)(t * (double)timeout);
        }
        return timeouts;
    }

    public VirtualSocket createClientSocket(VirtualSocketAddress target, int timeout, Map<String, Object> prop) throws IOException {
        return this.createClientSocket(target, timeout, false, prop);
    }

    public VirtualSocket createClientSocket(VirtualSocketAddress target, int timeout, boolean fillTimeout, Map<String, Object> prop) throws IOException {
        if (conlogger.isDebugEnabled()) {
            conlogger.debug("createClientSocket(" + target + ", " + timeout + ", " + fillTimeout + ", " + prop + ")");
        }
        if (timeout <= 0) {
            timeout = this.DEFAULT_TIMEOUT;
        }
        ConnectModule[] order = this.clusters.getOrder(target);
        int timeLeft = timeout;
        int[] timeouts = null;
        boolean lastAttempt = false;
        int backoff = 250;
        NoSuitableModuleException exception = null;
        LinkedList<NoSuitableModuleException> exceptions = null;
        if (this.DETAILED_EXCEPTIONS) {
            exceptions = new LinkedList<NoSuitableModuleException>();
        }
        while (true) {
            if (timeLeft <= this.DEFAULT_TIMEOUT) {
                timeouts = this.distributesTimeout(timeLeft, timeouts, order);
                fillTimeout = false;
            }
            long start = System.currentTimeMillis();
            try {
                return this.createClientSocket(target, order, timeouts, timeLeft, null, fillTimeout, prop);
            }
            catch (NoSuitableModuleException e) {
                if (conlogger.isDebugEnabled()) {
                    conlogger.debug("createClientSocket failed. Will " + (fillTimeout ? "" : "NOT ") + "retry");
                }
                if (this.DETAILED_EXCEPTIONS) {
                    exceptions.add(e);
                } else {
                    exception = e;
                }
                timeLeft = (int)((long)timeLeft - (System.currentTimeMillis() - start));
                if (!lastAttempt && fillTimeout && timeLeft > 0) {
                    int sleeptime = 0;
                    if (backoff < timeLeft) {
                        sleeptime = this.random.nextInt(backoff);
                    } else {
                        sleeptime = timeLeft;
                        lastAttempt = true;
                    }
                    if (sleeptime >= timeLeft) {
                        if (sleeptime > 500) {
                            sleeptime -= 500;
                        } else {
                            sleeptime = 0;
                            fillTimeout = false;
                        }
                    }
                    if (sleeptime > 0) {
                        try {
                            Thread.sleep(sleeptime);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    backoff *= 2;
                    continue;
                }
                fillTimeout = false;
                if (fillTimeout) continue;
                if (this.DETAILED_EXCEPTIONS) {
                    throw new NoSuitableModuleException("No suitable module found to connect to " + target + "(timeout=" + timeout + ", fillTimeout=" + fillTimeout + ")", exceptions);
                }
                throw exception;
            }
            break;
        }
    }

    private int getPort() {
        HashMap<Integer, VirtualServerSocket> hashMap = this.serverSockets;
        synchronized (hashMap) {
            while (true) {
                if (!this.serverSockets.containsKey(this.nextPort)) {
                    return this.nextPort++;
                }
                ++this.nextPort;
            }
        }
    }

    public VirtualServerSocket createServerSocket(int port, int backlog, boolean retry, Properties properties) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (properties != null) {
            for (Object string : properties.keySet()) {
                props.put((String)string, properties.getProperty((String)string));
            }
        }
        VirtualServerSocket result = null;
        while (result == null) {
            try {
                result = this.createServerSocket(port, backlog, props);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to open serversocket on port " + port + " (will retry): ", (Throwable)e);
                }
                if (retry) continue;
                return null;
            }
        }
        return result;
    }

    public VirtualServerSocket createServerSocket(Map<String, Object> props) throws IOException {
        return new VirtualServerSocket(this, this.DEFAULT_ACCEPT_TIMEOUT, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindServerSocket(VirtualServerSocket vss, int port) throws BindException {
        HashMap<Integer, VirtualServerSocket> hashMap = this.serverSockets;
        synchronized (hashMap) {
            if (this.serverSockets.containsKey(port)) {
                throw new BindException("Port " + port + " already in use!");
            }
            this.serverSockets.put(port, vss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualServerSocket createServerSocket(int port, int backlog, Map<String, Object> properties) throws IOException {
        if (backlog <= 0) {
            backlog = this.DEFAULT_BACKLOG;
        }
        if (port <= 0) {
            port = this.getPort();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Creating VirtualServerSocket(" + port + ", " + backlog + ", " + properties + ")");
        }
        HashMap<Integer, VirtualServerSocket> hashMap = this.serverSockets;
        synchronized (hashMap) {
            if (this.serverSockets.containsKey(port)) {
                throw new BindException("Port " + port + " already in use!");
            }
            VirtualSocketAddress a = new VirtualSocketAddress(this.myAddresses, port, this.hubAddress, this.clusters.localCluster());
            VirtualServerSocket vss = new VirtualServerSocket(this, a, port, backlog, this.DEFAULT_ACCEPT_TIMEOUT, properties);
            this.serverSockets.put(port, vss);
            return vss;
        }
    }

    public ServiceLink getServiceLink() {
        return this.serviceLink;
    }

    public DirectSocketAddress getLocalHost() {
        return this.myAddresses;
    }

    public String getLocalCluster() {
        return this.clusters.localCluster();
    }

    public DirectSocketAddress getLocalHub() {
        return this.hubAddress;
    }

    public void addHubs(DirectSocketAddress ... hubs) {
        if (this.hub != null) {
            this.hub.addHubs(hubs);
        } else if (this.serviceLink != null) {
            this.serviceLink.addHubs(hubs);
        }
    }

    public void addHubs(String ... hubs) {
        if (this.hub != null) {
            this.hub.addHubs(hubs);
        } else if (this.serviceLink != null) {
            this.serviceLink.addHubs(hubs);
        }
    }

    public DirectSocketAddress[] getKnownHubs() {
        block4: {
            if (this.hub != null) {
                return this.hub.knownHubs();
            }
            if (this.serviceLink != null) {
                try {
                    return this.serviceLink.hubs();
                }
                catch (IOException e) {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Failed to retrieve hub list!", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        if (this.printer != null) {
            this.printer.adjustInterval(-1);
        }
        if (this.printStatistics) {
            this.printStatistics(this.statisticPrefix + " [EXIT]");
        }
        if (this.serviceLink != null) {
            this.serviceLink.setDone();
        }
        if (this.hub != null) {
            this.hub.end();
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Set<String> keys = factories.keySet();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String s : keys) {
                if (factories.get(s) != this) continue;
                toRemove.add(s);
            }
            for (String s : toRemove) {
                factories.remove(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closed(int port) {
        HashMap<Integer, VirtualServerSocket> hashMap = this.serverSockets;
        synchronized (hashMap) {
            this.serverSockets.remove(port);
        }
    }

    public static synchronized VirtualSocketFactory getSocketFactory(String name) {
        return factories.get(name);
    }

    public static synchronized VirtualSocketFactory getOrCreateSocketFactory(String name, Properties p, boolean addDefaults) throws InitializationException {
        VirtualSocketFactory result = factories.get(name);
        if (result == null) {
            result = VirtualSocketFactory.createSocketFactory(p, addDefaults);
            factories.put(name, result);
        } else {
            TypedProperties typedProperties = new TypedProperties();
            if (addDefaults) {
                typedProperties.putAll(SmartSocketsProperties.getDefaultProperties());
            }
            if (p != null) {
                typedProperties.putAll(p);
            }
            if (!typedProperties.equals(result.properties)) {
                throw new InitializationException("could not retrieve existing factory, properties are not equal");
            }
        }
        return result;
    }

    public static synchronized void registerSocketFactory(String name, VirtualSocketFactory factory) {
        factories.put(name, factory);
    }

    public static synchronized VirtualSocketFactory getDefaultSocketFactory() throws InitializationException {
        if (defaultFactory == null) {
            defaultFactory = VirtualSocketFactory.createSocketFactory();
        }
        return defaultFactory;
    }

    public static VirtualSocketFactory createSocketFactory() throws InitializationException {
        return VirtualSocketFactory.createSocketFactory(null, true);
    }

    public static VirtualSocketFactory createSocketFactory(Map<String, ?> p, boolean addDefaults) throws InitializationException {
        return VirtualSocketFactory.createSocketFactory(new TypedProperties(p), addDefaults);
    }

    public static VirtualSocketFactory createSocketFactory(Properties properties, boolean addDefaults) throws InitializationException {
        boolean allowSSHForHub;
        TypedProperties typedProperties = new TypedProperties();
        if (addDefaults) {
            typedProperties.putAll(SmartSocketsProperties.getDefaultProperties());
        }
        if (properties != null) {
            typedProperties.putAll(properties);
        }
        if (typedProperties.booleanProperty("smartsockets.start.hub", false) && (allowSSHForHub = typedProperties.booleanProperty("smartsockets.hub.ssh", true))) {
            typedProperties.setProperty("smartsockets.modules.direct.ssh.in", "true");
        }
        VirtualSocketFactory factory = new VirtualSocketFactory(DirectSocketFactory.getSocketFactory(typedProperties), typedProperties);
        return factory;
    }

    public VirtualSocketAddress getLocalVirtual() {
        return this.localVirtualAddress;
    }

    public String getVirtualAddressAsString() {
        return this.localVirtualAddressAsString;
    }

    public void printStatistics(String prefix) {
        if (statslogger.isInfoEnabled()) {
            statslogger.info(prefix + " === VirtualSocketFactory (" + this.modules.size() + " / " + (this.serviceLink == null ? "No SL" : "SL") + ") ===");
            for (ConnectModule c : this.modules) {
                c.printStatistics(prefix);
            }
            if (this.serviceLink != null) {
                this.serviceLink.printStatistics(prefix);
            }
        }
    }

    private static class HubAcceptor
    implements AcceptHandler {
        private final Hub hub;

        private HubAcceptor(Hub hub) {
            this.hub = hub;
        }

        @Override
        public void accept(DirectSocket s, int targetPort, long time) {
            this.hub.delegateAccept(s);
        }
    }

    private static class StatisticsPrinter
    implements Runnable {
        private int timeout;
        private VirtualSocketFactory factory;
        private String prefix;

        StatisticsPrinter(VirtualSocketFactory factory, int timeout, String prefix) {
            this.timeout = timeout;
            this.factory = factory;
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int t = this.getTimeout();
            while (t > 0) {
                try {
                    StatisticsPrinter statisticsPrinter = this;
                    synchronized (statisticsPrinter) {
                        this.wait(t);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((t = this.getTimeout()) <= 0) continue;
                try {
                    this.factory.printStatistics(this.prefix);
                }
                catch (Exception e) {
                    logger.warn("Failed to print statistics", (Throwable)e);
                }
            }
        }

        private synchronized int getTimeout() {
            return this.timeout;
        }

        public synchronized void adjustInterval(int interval) {
            this.timeout = interval;
            this.notifyAll();
        }
    }
}

