/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.hub;

import ibis.smartsockets.direct.DirectServerSocket;
import ibis.smartsockets.direct.DirectSimpleSocket;
import ibis.smartsockets.direct.DirectSocket;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.direct.DirectSocketFactory;
import ibis.smartsockets.hub.CommunicationThread;
import ibis.smartsockets.hub.Connections;
import ibis.smartsockets.hub.StatisticsCallback;
import ibis.smartsockets.hub.connections.ClientConnection;
import ibis.smartsockets.hub.connections.HubConnection;
import ibis.smartsockets.hub.connections.VirtualConnections;
import ibis.smartsockets.hub.state.HubDescription;
import ibis.smartsockets.hub.state.HubList;
import ibis.smartsockets.hub.state.StateCounter;
import ibis.smartsockets.util.ThreadPool;
import ibis.smartsockets.util.TypedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Acceptor
extends CommunicationThread {
    private static final Logger hconlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.hub");
    private static final Logger cconlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.connections.client");
    private static final Logger reglogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.registration");
    private static final Logger reqlogger = LoggerFactory.getLogger((String)"ibis.smartsockets.hub.request");
    private DirectServerSocket server;
    private int sendBuffer = -1;
    private int receiveBuffer = -1;
    private boolean keepAlive = false;
    private LinkedList<DirectSocket> incoming = new LinkedList();
    private final StatisticsCallback callback;
    private final long statisticsInterval;

    Acceptor(TypedProperties p, int port, StateCounter state, Connections connections, HubList knownProxies, VirtualConnections vcs, DirectSocketFactory factory, DirectSocketAddress delegationAddress, StatisticsCallback callback, long statisticsInterval) throws IOException {
        super("HubAcceptor", state, connections, knownProxies, vcs, factory);
        this.callback = callback;
        this.statisticsInterval = statisticsInterval;
        this.keepAlive = p.booleanProperty("smartsockets.servicelink.keepalive");
        if (delegationAddress == null) {
            this.sendBuffer = p.getIntProperty("smartsockets.hub.sendbuffer", -1);
            this.receiveBuffer = p.getIntProperty("smartsockets.hub.receivebuffer", -1);
            this.server = factory.createServerSocket(port, 50, this.receiveBuffer, null);
            this.setLocal(this.server.getAddressSet());
            ThreadPool.createNew(new AcceptThread(), "Acceptor");
        } else {
            this.setLocal(delegationAddress);
        }
    }

    private boolean handleIncomingHubConnect(DirectSocket s, DataInputStream in, DataOutputStream out) throws IOException {
        String otherAsString = in.readUTF();
        DirectSocketAddress addr = DirectSocketAddress.getByAddress(otherAsString);
        if (hconlogger.isDebugEnabled()) {
            hconlogger.debug("Got connection from " + addr);
        }
        HubDescription d = this.knownHubs.add(addr);
        d.setCanReachMe();
        HubConnection c = new HubConnection(s, in, out, d, this.connections, this.knownHubs, this.state, this.virtualConnections, false, this.callback, this.statisticsInterval);
        if (!d.createConnection(c)) {
            if (hconlogger.isInfoEnabled()) {
                hconlogger.info("Connection from " + addr + " refused (duplicate)");
            }
            out.write(4);
            out.flush();
            return false;
        }
        if (hconlogger.isInfoEnabled()) {
            hconlogger.info("Incoming connection from hub " + addr + " accepted (hubs = " + this.connections.numberOfHubs() + ", clients = " + this.connections.numberOfClients() + ")");
        }
        out.write(3);
        out.flush();
        c.activate();
        this.connections.put(addr, c);
        return true;
    }

    private boolean handlePing(DirectSocket s, DataInputStream in, DataOutputStream out) throws IOException {
        in.readUTF();
        return false;
    }

    private boolean handleServiceLinkConnect(DirectSocket s, DataInputStream in, DataOutputStream out) {
        try {
            String src = in.readUTF();
            DirectSocketAddress srcAddr = DirectSocketAddress.getByAddress(src);
            if (this.connections.getClient(srcAddr) != null) {
                if (cconlogger.isDebugEnabled()) {
                    cconlogger.debug("Incoming connection from " + src + " refused, since it already exists!");
                }
                out.write(4);
                out.flush();
                DirectSocketFactory.close(s, (OutputStream)out, (InputStream)in);
                return false;
            }
            if (cconlogger.isInfoEnabled()) {
                cconlogger.info("Incoming connection from client " + src + " accepted (hubs = " + this.connections.numberOfHubs() + ", clients = " + this.connections.numberOfClients() + ")");
            }
            out.write(3);
            out.writeUTF(this.getLocalAsString());
            out.flush();
            s.setKeepAlive(this.keepAlive);
            ClientConnection c = new ClientConnection(srcAddr, s, in, out, this.connections, this.knownHubs, this.virtualConnections, this.callback, this.statisticsInterval);
            this.connections.put(srcAddr, c);
            this.knownHubs.getLocalDescription().addClient(srcAddr);
            if (reglogger.isInfoEnabled()) {
                reglogger.info("Added client: " + src);
            }
            c.activate();
            return true;
        }
        catch (IOException e) {
            cconlogger.warn("Got exception while handling connect!", (Throwable)e);
            DirectSocketFactory.close(s, (OutputStream)out, (InputStream)in);
            return false;
        }
    }

    private boolean handleSpliceInfo(DirectSocket s, DataInputStream in, DataOutputStream out) throws IOException {
        block4: {
            if (reqlogger.isInfoEnabled()) {
                reqlogger.info("Got request for splice info");
            }
            try {
                DirectSimpleSocket dss = (DirectSimpleSocket)s;
                InetSocketAddress tmp = (InetSocketAddress)dss.getRemoteSocketAddress();
                out.writeUTF(tmp.getAddress().toString());
                out.writeInt(tmp.getPort());
                out.flush();
                if (reqlogger.isInfoEnabled()) {
                    reqlogger.info("Reply to splice info request " + tmp.getAddress() + ":" + tmp.getPort());
                }
            }
            catch (Exception e) {
                if (!reqlogger.isInfoEnabled()) break block4;
                reqlogger.info("Failed to forward splice info!", (Throwable)e);
            }
        }
        return false;
    }

    private void doAccept(DirectSocket s) {
        DataInputStream in = null;
        DataOutputStream out = null;
        boolean result = false;
        if (hublogger.isDebugEnabled()) {
            hublogger.debug("Waiting for connection...");
        }
        try {
            in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            int opcode = in.read();
            switch (opcode) {
                case 1: {
                    result = this.handleIncomingHubConnect(s, in, out);
                    break;
                }
                case 7: {
                    result = this.handlePing(s, in, out);
                    break;
                }
                case 2: {
                    result = this.handleServiceLinkConnect(s, in, out);
                    break;
                }
                case 8: {
                    result = this.handleSpliceInfo(s, in, out);
                    break;
                }
            }
        }
        catch (Exception e) {
            hublogger.warn("Failed to accept connection!", (Throwable)e);
            result = false;
        }
        if (!result) {
            DirectSocketFactory.close(s, out, (InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncoming(DirectSocket s) {
        LinkedList<DirectSocket> linkedList = this.incoming;
        synchronized (linkedList) {
            this.incoming.addLast(s);
            this.incoming.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectSocket getIncoming() {
        LinkedList<DirectSocket> linkedList = this.incoming;
        synchronized (linkedList) {
            while (this.incoming.size() == 0) {
                try {
                    this.incoming.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return this.incoming.removeFirst();
        }
    }

    @Override
    public void run() {
        while (!this.getDone()) {
            DirectSocket tmp = this.getIncoming();
            if (tmp == null) continue;
            this.doAccept(tmp);
        }
    }

    private class AcceptThread
    implements Runnable {
        private AcceptThread() {
        }

        @Override
        public void run() {
            while (!Acceptor.this.getDone()) {
                DirectSocket s = null;
                try {
                    s = Acceptor.this.server.accept();
                    s.setTcpNoDelay(true);
                    if (Acceptor.this.sendBuffer > 0) {
                        s.setSendBufferSize(Acceptor.this.sendBuffer);
                    }
                    if (Acceptor.this.receiveBuffer > 0) {
                        s.setReceiveBufferSize(Acceptor.this.receiveBuffer);
                    }
                    if (hconlogger.isInfoEnabled()) {
                        hconlogger.info("Acceptor send buffer = " + s.getSendBufferSize());
                        hconlogger.info("Acceptor recv buffer = " + s.getReceiveBufferSize());
                    }
                    Acceptor.this.addIncoming(s);
                }
                catch (Exception e) {
                    CommunicationThread.hublogger.warn("Failed to accept connection!", (Throwable)e);
                    DirectSocketFactory.close(s, null, null);
                }
            }
        }
    }
}

