/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.discovery;

import ibis.smartsockets.discovery.Discovery;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.discovery");
    private final int sleep;
    private final DatagramSocket[] sockets;
    private final InetSocketAddress target;
    private final DatagramPacket packet;

    protected Sender(InetAddress[] ads, int sendport, int receiveport, int sleep, String message) throws Exception {
        super("MulticastSender");
        this.sleep = sleep;
        byte[] data = message.getBytes();
        if (data.length > 1024) {
            throw new IllegalArgumentException("Message exceeds 1024 bytes!");
        }
        byte[] tmp = new byte[data.length + 8];
        Discovery.write(tmp, 0, 0x42FF42FF);
        Discovery.write(tmp, 4, data.length);
        System.arraycopy(data, 0, tmp, 8, data.length);
        this.target = new InetSocketAddress("255.255.255.255", receiveport);
        this.packet = new DatagramPacket(tmp, tmp.length, this.target);
        this.sockets = new DatagramSocket[1];
        this.sockets[0] = new DatagramSocket(sendport);
    }

    public void send() {
        if (this.packet == null) {
            return;
        }
        for (int i = 0; i < this.sockets.length; ++i) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("MulticastSender sending data " + this.packet.getSocketAddress() + " " + this.packet);
                }
                this.sockets[i].send(this.packet);
                continue;
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) continue;
                logger.info("MulticastSender got exception ", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            long time = System.currentTimeMillis();
            this.send();
            time = System.currentTimeMillis() - time;
            if (time >= (long)this.sleep) continue;
            try {
                Sender.sleep((long)this.sleep - time);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

