/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.discovery;

import ibis.smartsockets.discovery.Callback;
import ibis.smartsockets.discovery.Discovery;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Receiver
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.smartsockets.discovery");
    private DatagramSocket socket;
    private DatagramPacket packet;
    private final Callback callback;
    private final int timeout;

    Receiver(InetAddress[] ads, int port, Callback callback) throws SocketException {
        this(ads, port, callback, 0);
    }

    Receiver(InetAddress[] ads, int port, Callback callback, int timeout) throws SocketException {
        super("discovery.Receiver");
        this.callback = callback;
        this.timeout = timeout;
        this.socket = port == 0 ? new DatagramSocket() : new DatagramSocket(port);
        this.packet = new DatagramPacket(new byte[65536], 65536);
    }

    public String receive(long timeout) throws IOException {
        long end = System.currentTimeMillis() + timeout;
        long left = timeout;
        while (timeout == 0L || left > 0L) {
            if (logger.isInfoEnabled()) {
                logger.info("Receiver waiting for data");
            }
            this.socket.receive(this.packet);
            byte[] tmp = this.packet.getData();
            if (tmp.length > 8) {
                if (Discovery.read(tmp, 0) != 0x42FF42FF) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Discarding packet, wrong MAGIC");
                    }
                } else {
                    int len = Discovery.read(tmp, 4);
                    if (logger.isInfoEnabled()) {
                        logger.info("MAGIC OK, data length = " + len);
                    }
                    if (len > 1024) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Discarding packet, wrong size");
                        }
                    } else {
                        byte[] data = new byte[len];
                        System.arraycopy(tmp, 8, data, 0, len);
                        return new String(data);
                    }
                }
            }
            if (timeout <= 0L) continue;
            left = end - System.currentTimeMillis();
        }
        throw new SocketTimeoutException();
    }

    @Override
    public void run() {
        long end = System.currentTimeMillis() + (long)this.timeout;
        long left = this.timeout;
        while (this.timeout == 0 || left > 0L) {
            try {
                String message = this.receive(left);
                boolean cont = this.callback.gotMessage(message);
                if (!cont) {
                    return;
                }
                if (this.timeout <= 0) continue;
                left = end - System.currentTimeMillis();
            }
            catch (SocketTimeoutException message) {
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) continue;
                logger.info("Receiver failed!", (Throwable)e);
            }
        }
    }
}

