/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.direct;

import ibis.smartsockets.util.NetworkUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class Network {
    public static final Network NONE = new Network(Type.NONE);
    public static final Network SITE = new Network(Type.SITE);
    public static final Network LINK = new Network(Type.LINK);
    public static final Network GLOBAL = new Network(Type.GLOBAL);
    final Type type;
    final byte[] network;
    final byte[] mask;

    Network(Type type) {
        this.type = type;
        this.network = null;
        this.mask = null;
    }

    Network(byte[] network, byte[] mask) {
        this.type = Type.SPECIFIC;
        this.network = network;
        this.mask = mask;
    }

    boolean match(InetAddress addr) {
        switch (this.type) {
            case NONE: {
                return false;
            }
            case SITE: 
            case LINK: {
                return addr.isSiteLocalAddress();
            }
            case GLOBAL: {
                return !addr.isSiteLocalAddress() && !addr.isLinkLocalAddress() && !addr.isLoopbackAddress() && !addr.isAnyLocalAddress() && !addr.isMulticastAddress();
            }
            case SPECIFIC: {
                return NetworkUtils.matchAddress(addr, this.network, this.mask);
            }
        }
        return false;
    }

    boolean match(InetAddress[] addr) {
        for (int i = 0; i < addr.length; ++i) {
            if (!this.match(addr[i])) continue;
            return true;
        }
        return false;
    }

    boolean match(InetSocketAddress[] addr) {
        for (int i = 0; i < addr.length; ++i) {
            if (!this.match(addr[i].getAddress())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        switch (this.type) {
            case NONE: {
                return "none";
            }
            case SITE: {
                return "site";
            }
            case LINK: {
                return "link";
            }
            case GLOBAL: {
                return "global";
            }
            case SPECIFIC: {
                return NetworkUtils.bytesToString(this.network) + "/" + NetworkUtils.bytesToString(this.mask);
            }
        }
        return "";
    }

    private static enum Type {
        NONE,
        SITE,
        LINK,
        GLOBAL,
        SPECIFIC;

    }
}

